/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.finder;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementSubGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.util.EnumMultiMap;
import cascading.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Match {
    protected final ExpressionGraph matchGraph;
    protected final ElementGraph elementGraph;
    protected final Map<ElementExpression, FlowElement> vertexMapping;
    protected final Collection<FlowElement> foundElements;
    protected final Collection<Scope> foundScopes;
    protected EnumMultiMap<FlowElement> captureMap;
    private ElementSubGraph matchedGraph;

    public Match(ExpressionGraph matchGraph, ElementGraph elementGraph, Map<ElementExpression, FlowElement> vertexMapping, Collection<FlowElement> foundElements, Collection<Scope> foundScopes) {
        this(matchGraph, elementGraph, vertexMapping, foundElements, foundScopes, null);
    }

    public Match(ExpressionGraph matchGraph, ElementGraph elementGraph, Map<ElementExpression, FlowElement> vertexMapping, Collection<FlowElement> foundElements, Collection<Scope> foundScopes, EnumMultiMap<FlowElement> captureMap) {
        this.matchGraph = matchGraph;
        this.elementGraph = elementGraph;
        this.vertexMapping = vertexMapping == null ? Collections.emptyMap() : vertexMapping;
        this.foundElements = foundElements;
        this.foundScopes = foundScopes;
        this.captureMap = captureMap;
    }

    public ElementGraph getElementGraph() {
        return this.elementGraph;
    }

    public ExpressionGraph getMatchGraph() {
        return this.matchGraph;
    }

    public boolean foundMatch() {
        return !this.vertexMapping.values().isEmpty();
    }

    public Map<ElementExpression, FlowElement> getVertexMapping() {
        return this.vertexMapping;
    }

    public Collection<FlowElement> getFoundElements() {
        return this.foundElements;
    }

    public ElementSubGraph getMatchedGraph() {
        if (this.matchedGraph == null) {
            this.matchedGraph = new ElementSubGraph(this.elementGraph, this.foundElements, this.foundScopes);
        }
        return this.matchedGraph;
    }

    public Set<FlowElement> getIncludedElements() {
        return this.getCapturedElements(ElementCapture.Include);
    }

    public Set<FlowElement> getCapturedElements(ElementCapture ... captures) {
        return (Set)this.getCaptureMap().getAllValues(captures);
    }

    public EnumMultiMap<FlowElement> getCaptureMap() {
        if (this.captureMap != null) {
            return this.captureMap;
        }
        this.captureMap = new EnumMultiMap();
        LinkedHashMap reversed = new LinkedHashMap();
        if (Util.reverseMap(this.vertexMapping, reversed)) {
            throw new IllegalStateException("duplicates found in mapping");
        }
        Iterator<FlowElement> iterator = ElementGraphs.getTopologicalIterator(this.getMatchedGraph());
        while (iterator.hasNext()) {
            FlowElement next = iterator.next();
            ElementExpression elementExpression = (ElementExpression)reversed.get(next);
            if (elementExpression == null) continue;
            this.captureMap.addAll(elementExpression.getCapture(), next);
        }
        return this.captureMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Match{");
        sb.append(this.getMatchedGraph());
        sb.append('}');
        return sb.toString();
    }
}

