/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.finder;

import cascading.flow.planner.iso.expression.ElementExpression;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.expression.ScopeExpression;
import cascading.flow.planner.iso.finder.IndexedGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jgrapht.DirectedGraph;

class IndexedMatchGraph
extends IndexedGraph<DirectedGraph<ElementExpression, ScopeExpression>, ElementExpression, ScopeExpression> {
    public IndexedMatchGraph(DirectedGraph<ElementExpression, ScopeExpression> graph) {
        super(graph);
    }

    @Override
    public Set<ScopeExpression> getAllEdges(Object sourceVertex, Object targetVertex) {
        Set allEdges = super.getAllEdges(sourceVertex, targetVertex);
        HashSet<ScopeExpression> results = new HashSet<ScopeExpression>(allEdges.size());
        for (ScopeExpression edge : allEdges) {
            results.add(ExpressionGraph.unwind(edge));
        }
        return results;
    }

    @Override
    public List<ScopeExpression> getAllEdgesList(Object sourceVertex, Object targetVertex) {
        ArrayList allEdges = (ArrayList)super.getAllEdgesList(sourceVertex, targetVertex);
        ListIterator<ScopeExpression> iterator = allEdges.listIterator();
        while (iterator.hasNext()) {
            iterator.set(ExpressionGraph.unwind((ScopeExpression)iterator.next()));
        }
        return allEdges;
    }
}

