/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.finder;

import cascading.flow.planner.iso.finder.GraphFinderException;
import cascading.flow.planner.iso.finder.SearchOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.graph.GraphDelegator;

class IndexedGraph<G extends Graph<Node, Edge>, Node, Edge>
extends GraphDelegator {
    private SearchOrder searchOrder;
    private G delegate;
    private Object[] index;
    private Map<Node, Integer> reverse;
    private Map<Integer, Set<Integer>> successors = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> predecessors = new HashMap<Integer, Set<Integer>>();
    private int count;
    private Iterator iterator;

    public IndexedGraph(G graph) {
        this(null, graph);
    }

    public IndexedGraph(SearchOrder searchOrder, G graph) {
        super(graph);
        this.searchOrder = searchOrder;
        this.delegate = graph;
        this.index = new Object[this.vertexSet().size()];
        this.count = -1;
        this.iterator = this.getIterator(searchOrder);
        this.reverse = new IdentityHashMap<Node, Integer>(this.index.length);
    }

    public G getDelegate() {
        return this.delegate;
    }

    public boolean containsEdge(int lhsVertex, int rhsVertex) {
        return this.getDelegate().containsEdge(this.getVertex(lhsVertex), this.getVertex(rhsVertex));
    }

    public Set<Integer> getSuccessors(int vertex) {
        Set<Integer> results = this.successors.get(vertex);
        if (results != null) {
            return results;
        }
        results = new HashSet<Integer>();
        Set edges = this.getDelegate().outgoingEdgesOf(this.getVertex(vertex));
        for (Object edge : edges) {
            Object result = this.getEdgeTarget(edge);
            Integer value = this.getIndex(result);
            if (value == null) continue;
            results.add(value);
        }
        this.successors.put(vertex, results);
        return results;
    }

    public Set<Integer> getPredecessors(int vertex) {
        Set<Integer> results = this.predecessors.get(vertex);
        if (results != null) {
            return results;
        }
        results = new HashSet<Integer>();
        Set edges = this.getDelegate().incomingEdgesOf(this.getVertex(vertex));
        for (Object edge : edges) {
            Object result = this.getEdgeSource(edge);
            Integer value = this.getIndex(result);
            if (value == null) continue;
            results.add(value);
        }
        this.predecessors.put(vertex, results);
        return results;
    }

    public Integer getIndex(Object result) {
        Integer index = this.reverse.get(result);
        if (index != null) {
            return index;
        }
        while (this.iterator.hasNext() && this.getVertex(this.count + 1) != result) {
        }
        return this.count;
    }

    private Iterator<Node> getIterator(SearchOrder searchOrder) {
        return SearchOrder.getNodeIterator(searchOrder, this.getDelegate());
    }

    public Node getVertex(int vertex) {
        while (this.count < vertex && this.iterator.hasNext()) {
            ++this.count;
            this.index[this.count] = this.iterator.next();
            this.reverse.put(this.index[this.count], this.count);
        }
        if (this.index[vertex] == null) {
            if (this.index.length != this.count - 1) {
                throw new GraphFinderException("given graph has multiple origins with search order: " + (Object)((Object)this.searchOrder) + ", likely not all paths connect HEAD and TAIL of element graph", (Graph)this.getDelegate());
            }
            throw new GraphFinderException("vertex is null: " + vertex, (Graph)this.getDelegate());
        }
        return (Node)this.index[vertex];
    }

    public Edge getEdge(int lhsVertex, int rhsVertex) {
        Node lhsNode = this.getVertex(lhsVertex);
        Node rhsNode = this.getVertex(rhsVertex);
        return (Edge)this.getDelegate().getEdge(lhsNode, rhsNode);
    }

    public Set<Edge> getAllEdges(Object sourceVertex, Object targetVertex) {
        Node lhsNode = this.getVertex((Integer)sourceVertex);
        Node rhsNode = this.getVertex((Integer)targetVertex);
        return this.getDelegate().getAllEdges(lhsNode, rhsNode);
    }

    public List<Edge> getAllEdgesList(Object sourceVertex, Object targetVertex) {
        return new ArrayList<Edge>(this.getAllEdges(sourceVertex, targetVertex));
    }
}

