/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.finder;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.expression.ScopeExpression;
import cascading.flow.planner.iso.finder.FinderContext;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.finder.SearchOrder;
import cascading.flow.planner.iso.finder.State;
import cascading.util.EnumMultiMap;
import cascading.util.Pair;
import cascading.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DirectedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFinder {
    private static final Logger LOG = LoggerFactory.getLogger(GraphFinder.class);
    ExpressionGraph matchExpression;

    public GraphFinder(ExpressionGraph matchExpression) {
        if (matchExpression == null) {
            throw new IllegalArgumentException("expressionGraph may not be null");
        }
        this.matchExpression = matchExpression;
    }

    public ExpressionGraph getMatchExpression() {
        return this.matchExpression;
    }

    public Match findFirstMatch(ElementGraph elementGraph) {
        return this.findFirstMatch(new PlannerContext(), elementGraph);
    }

    public Match findFirstMatch(PlannerContext plannerContext, ElementGraph elementGraph) {
        return this.findFirstMatch(new FinderContext(), plannerContext, elementGraph);
    }

    public Match findFirstMatch(PlannerContext plannerContext, ElementGraph elementGraph, Set<FlowElement> exclusions) {
        return this.findFirstMatch(new FinderContext(exclusions), plannerContext, elementGraph);
    }

    protected Match findFirstMatch(FinderContext finderContext, PlannerContext plannerContext, ElementGraph elementGraph) {
        Map<ElementExpression, FlowElement> mapping = this.findMapping(finderContext, plannerContext, elementGraph);
        return new Match(this.matchExpression, elementGraph, mapping, mapping.values(), this.getCapturedEdges(plannerContext, elementGraph, mapping));
    }

    public Match findAllMatches(ElementGraph elementGraph) {
        return this.findAllMatches(new PlannerContext(), elementGraph);
    }

    public Match findAllMatches(PlannerContext plannerContext, ElementGraph elementGraph) {
        return this.findAllMatches(plannerContext, elementGraph, Collections.emptySet());
    }

    public Match findAllMatches(PlannerContext plannerContext, ElementGraph elementGraph, Set<FlowElement> exclusions) {
        Set elementExpressions = this.matchExpression.getGraph().vertexSet();
        if (elementExpressions.size() != 1) {
            throw new IllegalStateException("may not search multiple matches against multi-node expression: " + this.matchExpression);
        }
        ElementExpression expression = (ElementExpression)Util.getFirst(elementExpressions);
        if (expression.getCapture() != ElementCapture.Primary) {
            throw new IllegalStateException("capture on expression must be Primary: " + expression);
        }
        LinkedHashSet<FlowElement> foundElements = new LinkedHashSet<FlowElement>();
        Iterator iterator = SearchOrder.getNodeIterator(this.matchExpression.getSearchOrder(), ElementGraphs.directed(elementGraph));
        while (iterator.hasNext()) {
            FlowElement flowElement = (FlowElement)iterator.next();
            if (exclusions.contains(flowElement) || !expression.applies(plannerContext, elementGraph, flowElement)) continue;
            foundElements.add(flowElement);
        }
        return new Match(this.matchExpression, elementGraph, null, foundElements, Collections.emptySet()){

            @Override
            public Set<FlowElement> getCapturedElements(ElementCapture ... captures) {
                if (!Arrays.asList(captures).contains((Object)ElementCapture.Primary)) {
                    return Collections.emptySet();
                }
                return (Set)this.foundElements;
            }
        };
    }

    public Match findAllMatchesOnPrimary(ElementGraph elementGraph) {
        return this.findAllMatchesOnPrimary(new PlannerContext(), elementGraph);
    }

    public Match findAllMatchesOnPrimary(PlannerContext plannerContext, ElementGraph elementGraph) {
        return this.findMatchesOnPrimary(new FinderContext(), plannerContext, elementGraph, false);
    }

    public Match findMatchesOnPrimary(PlannerContext plannerContext, ElementGraph elementGraph, boolean firstOnly, Set<FlowElement> excludes) {
        return this.findMatchesOnPrimary(new FinderContext(excludes), plannerContext, elementGraph, firstOnly);
    }

    public Match findAllMatchesOnPrimary(PlannerContext plannerContext, ElementGraph elementGraph, Set<FlowElement> excludes) {
        return this.findMatchesOnPrimary(new FinderContext(excludes), plannerContext, elementGraph, false);
    }

    protected Match findMatchesOnPrimary(FinderContext finderContext, PlannerContext plannerContext, ElementGraph elementGraph, boolean firstOnly) {
        Match current;
        Match match = null;
        EnumMultiMap<FlowElement> captureMap = new EnumMultiMap<FlowElement>();
        while ((current = this.findFirstMatch(finderContext, plannerContext, elementGraph)).foundMatch()) {
            Set<FlowElement> includedElements;
            captureMap.addAll(current.getCaptureMap());
            Set<FlowElement> anchoredElements = current.getCapturedElements(ElementCapture.Primary);
            if (finderContext.getRequiredElements().isEmpty()) {
                finderContext.getRequiredElements().addAll(anchoredElements);
            }
            match = current;
            Map<ElementExpression, FlowElement> vertexMapping = current.getVertexMapping();
            finderContext.getMatchedElements().addAll(vertexMapping.values());
            finderContext.getMatchedScopes().addAll(this.getCapturedEdges(plannerContext, elementGraph, vertexMapping));
            if (firstOnly || (includedElements = current.getIncludedElements()).isEmpty()) break;
            finderContext.getIgnoredElements().addAll(includedElements);
        }
        Map<ElementExpression, FlowElement> mapping = match == null ? null : match.getVertexMapping();
        return new Match(this.matchExpression, elementGraph, mapping, finderContext.getMatchedElements(), finderContext.getMatchedScopes(), captureMap);
    }

    public Map<ScopeExpression, Set<Scope>> getEdgeMapping(PlannerContext plannerContext, ElementGraph elementGraph, Map<ElementExpression, FlowElement> vertexMapping) {
        HashMap<ScopeExpression, Set<Scope>> edgeMapping = new HashMap<ScopeExpression, Set<Scope>>();
        DirectedMultigraph<ElementExpression, ScopeExpression> delegate = this.matchExpression.getGraph();
        for (ScopeExpression scopeExpression : delegate.edgeSet()) {
            FlowElement rhsElement;
            ElementExpression lhs = (ElementExpression)delegate.getEdgeSource((Object)scopeExpression);
            ElementExpression rhs = (ElementExpression)delegate.getEdgeTarget((Object)scopeExpression);
            FlowElement lhsElement = vertexMapping.get(lhs);
            Set<Scope> edges = elementGraph.getAllEdges(lhsElement, rhsElement = vertexMapping.get(rhs));
            if (edges == null) continue;
            edgeMapping.put(scopeExpression, edges);
        }
        return edgeMapping;
    }

    public Set<Scope> getCapturedEdges(PlannerContext plannerContext, ElementGraph elementGraph, Map<ElementExpression, FlowElement> vertexMapping) {
        HashSet<Scope> scopes = new HashSet<Scope>();
        if (vertexMapping.isEmpty()) {
            return scopes;
        }
        for (Map.Entry<ScopeExpression, Set<Scope>> entry : this.getEdgeMapping(plannerContext, elementGraph, vertexMapping).entrySet()) {
            if (!entry.getKey().isCapture()) continue;
            scopes.addAll((Collection<Scope>)entry.getValue());
        }
        return scopes;
    }

    public Map<ElementExpression, FlowElement> findMapping(PlannerContext plannerContext, ElementGraph elementGraph) {
        return this.findMapping(new FinderContext(), plannerContext, elementGraph);
    }

    protected Map<ElementExpression, FlowElement> findMapping(FinderContext finderContext, PlannerContext plannerContext, ElementGraph elementGraph) {
        LinkedHashMap<Integer, Integer> vertexMap;
        State state = new State(finderContext, plannerContext, this.matchExpression.getSearchOrder(), (DirectedGraph<ElementExpression, ScopeExpression>)this.matchExpression.getGraph(), elementGraph);
        boolean match = this.match(state, vertexMap = new LinkedHashMap<Integer, Integer>());
        if (!match) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ElementExpression, FlowElement> result = new LinkedHashMap<ElementExpression, FlowElement>();
        for (Map.Entry entry : vertexMap.entrySet()) {
            result.put(state.getMatcherNode((Integer)entry.getKey()), state.getElementNode((Integer)entry.getValue()));
        }
        return result;
    }

    private boolean match(State state, Map<Integer, Integer> vertexMap) {
        Pair<Integer, Integer> next;
        if (LOG.isTraceEnabled()) {
            LOG.trace("begin matching with state: {}", (Object)state);
        }
        if (state.isGoal()) {
            return true;
        }
        if (state.isDead()) {
            return false;
        }
        int n1 = -1;
        int n2 = -1;
        boolean found = false;
        while (!found && (next = state.nextPair(n1, n2)) != null) {
            n1 = next.getLhs();
            n2 = next.getRhs();
            if (LOG.isTraceEnabled()) {
                LOG.trace("begin matching pair: N1: {}, N2: {}", (Object)n1, (Object)n2);
            }
            boolean feasiblePair = state.isFeasiblePair(n1, n2);
            if (LOG.isTraceEnabled() && !feasiblePair) {
                LOG.trace("not feasible pair: N1: {}, N2: {}", (Object)n1, (Object)n2);
            }
            if (!feasiblePair) continue;
            State copy = state.copy();
            copy.addPair(n1, n2);
            found = this.match(copy, vertexMap);
            if (found) {
                for (Map.Entry<Integer, Integer> entry : copy.getVertexMapping().entrySet()) {
                    if (!vertexMap.containsKey(entry.getKey()) || vertexMap.get(entry.getKey()).equals(entry.getValue())) continue;
                    throw new IllegalStateException("duplicate key with differing values");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("match for feasible pair: N1: {}, N2: {}", (Object)n1, (Object)n2);
                }
                vertexMap.putAll(copy.getVertexMapping());
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("vertex map: {}", vertexMap);
                continue;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("no match for feasible pair: N1: {}, N2: {}", (Object)n1, (Object)n2);
            }
            copy.backTrack();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("completed matching with state: {}, found: {}", (Object)state, (Object)found);
        }
        return found;
    }
}

