/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.finder;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.util.Util;
import java.util.HashSet;
import java.util.Set;

class FinderContext {
    Set<FlowElement> excludedElements;
    Set<FlowElement> ignoredElements;
    Set<FlowElement> requiredElements;
    Set<FlowElement> foundElements;
    Set<Scope> foundScopes;

    public FinderContext(Set<FlowElement> excludes) {
        this.getExcludedElements().addAll(excludes);
    }

    public FinderContext() {
    }

    public Set<FlowElement> getExcludedElements() {
        if (this.excludedElements == null) {
            this.excludedElements = Util.createIdentitySet();
        }
        return this.excludedElements;
    }

    public boolean isExcluded(FlowElement flowElement) {
        return this.getExcludedElements().contains(flowElement);
    }

    public Set<FlowElement> getRequiredElements() {
        if (this.requiredElements == null) {
            this.requiredElements = Util.createIdentitySet();
        }
        return this.requiredElements;
    }

    public boolean isRequired(FlowElement flowElement) {
        return this.getRequiredElements().contains(flowElement);
    }

    public Set<FlowElement> getMatchedElements() {
        if (this.foundElements == null) {
            this.foundElements = Util.createIdentitySet();
        }
        return this.foundElements;
    }

    public Set<Scope> getMatchedScopes() {
        if (this.foundScopes == null) {
            this.foundScopes = new HashSet<Scope>();
        }
        return this.foundScopes;
    }

    public Set<FlowElement> getIgnoredElements() {
        if (this.ignoredElements == null) {
            this.ignoredElements = Util.createIdentitySet();
        }
        return this.ignoredElements;
    }

    public boolean isIgnored(FlowElement flowElement) {
        return this.getIgnoredElements().contains(flowElement);
    }
}

