/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.expression;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;

public class TypeExpression<Type>
extends ElementExpression {
    boolean exact = false;
    Class<? extends Type> type;
    Topo topo = Topo.Ignore;

    public TypeExpression(ElementCapture capture, boolean exact, Class<? extends Type> type, Topo topo) {
        super(capture);
        this.exact = exact;
        this.type = type;
        this.topo = topo;
    }

    public TypeExpression(ElementCapture capture, boolean exact, Class<? extends Type> type) {
        super(capture);
        this.exact = exact;
        this.type = type;
    }

    public TypeExpression(ElementCapture capture, Class<? extends Type> type, Topo topo) {
        super(capture);
        this.type = type;
        this.topo = topo;
    }

    public TypeExpression(ElementCapture capture, Class<? extends Type> type) {
        super(capture);
        this.type = type;
    }

    public TypeExpression(boolean exact, Class<? extends Type> type, Topo topo) {
        this.exact = exact;
        this.type = type;
        this.topo = topo;
    }

    public TypeExpression(boolean exact, Class<? extends Type> type) {
        this.exact = exact;
        this.type = type;
    }

    public TypeExpression(Class<? extends Type> type, Topo topo) {
        this.type = type;
        this.topo = topo;
    }

    public TypeExpression(Class<? extends Type> type) {
        this.type = type;
    }

    protected Class<? extends Type> getType(FlowElement flowElement) {
        return flowElement.getClass();
    }

    @Override
    public boolean applies(PlannerContext plannerContext, ElementGraph elementGraph, FlowElement flowElement) {
        boolean typeApplies = this.typeApplies(flowElement);
        if (!typeApplies) {
            return false;
        }
        if (this.topo == Topo.Ignore) {
            return true;
        }
        boolean isHead = elementGraph.inDegreeOf(flowElement) == 0;
        boolean isTail = elementGraph.outDegreeOf(flowElement) == 0;
        boolean isSplice = elementGraph.inDegreeOf(flowElement) > 1;
        boolean isSplit = elementGraph.outDegreeOf(flowElement) > 1;
        switch (this.topo) {
            case Head: {
                return isHead;
            }
            case Tail: {
                return isTail;
            }
            case Linear: {
                return !isSplice && !isSplit;
            }
            case LinearIn: {
                return !isSplice;
            }
            case LinearOut: {
                return !isSplit;
            }
            case Splice: {
                return isSplice;
            }
            case Split: {
                return isSplit;
            }
            case SpliceOnly: {
                return isSplice && !isSplit;
            }
            case SplitOnly: {
                return !isSplice && isSplit;
            }
            case SpliceSplit: {
                return isSplice && isSplit;
            }
        }
        throw new IllegalStateException("unknown switch, got: " + (Object)((Object)this.topo));
    }

    private boolean typeApplies(FlowElement flowElement) {
        Class<Type> givenType = this.getType(flowElement);
        if (givenType == null) {
            return false;
        }
        if (this.exact) {
            return givenType == this.type;
        }
        return this.type.isAssignableFrom(givenType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("exact=").append(this.exact);
        sb.append(", type=").append(this.type);
        sb.append(", topo=").append((Object)this.topo);
        sb.append('}');
        return sb.toString();
    }

    public static enum Topo {
        Ignore,
        Head,
        Tail,
        Linear,
        LinearIn,
        LinearOut,
        Splice,
        Split,
        SpliceOnly,
        SplitOnly,
        SpliceSplit;

    }
}

