/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.expression;

import cascading.flow.planner.Scope;
import cascading.flow.planner.iso.expression.Expression;
import cascading.flow.planner.iso.expression.PathScopeExpression;

public abstract class ScopeExpression
implements Expression<Scope> {
    public static final PathScopeExpression ANY = new PathScopeExpression(Applies.Any);
    public static final PathScopeExpression ALL = new PathScopeExpression(Applies.All);
    public static final PathScopeExpression EACH = new PathScopeExpression(Applies.Each);
    public static final PathScopeExpression NO_CAPTURE = new PathScopeExpression(false, Applies.All);
    protected boolean capture = true;
    protected Applies applies = Applies.Any;

    protected ScopeExpression() {
    }

    protected ScopeExpression(Applies applies) {
        this.applies = applies;
    }

    public ScopeExpression(boolean capture, Applies applies) {
        this.capture = capture;
        this.applies = applies;
        if (!capture && applies != Applies.All) {
            throw new IllegalArgumentException("applies must be ALL if capture is false");
        }
    }

    public boolean isCapture() {
        return this.capture;
    }

    public boolean appliesToAllPaths() {
        return this.applies == Applies.All;
    }

    public boolean appliesToAnyPath() {
        return this.applies == Applies.Any;
    }

    public boolean appliesToEachPath() {
        return this.applies == Applies.Each;
    }

    public boolean acceptsAll() {
        return this.appliesToAllPaths();
    }

    public Applies getApplies() {
        return this.applies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScopeExpression{");
        sb.append("capture=").append(this.capture);
        sb.append(", applies=").append((Object)this.applies);
        sb.append('}');
        return sb.toString();
    }

    public static enum Applies {
        Any,
        All,
        Each;

    }
}

