/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.expression;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.pipe.Operator;

public class PlannerLevelElementExpression
extends ElementExpression {
    private final Class<? extends PlannerLevel> plannerLevelClass;

    protected PlannerLevelElementExpression(ElementCapture capture, Class<? extends PlannerLevel> plannerLevelClass) {
        super(capture);
        this.plannerLevelClass = plannerLevelClass;
    }

    @Override
    public boolean applies(PlannerContext plannerContext, ElementGraph elementGraph, FlowElement flowElement) {
        if (!(flowElement instanceof Operator)) {
            return false;
        }
        Operator operator = (Operator)flowElement;
        if (!operator.hasPlannerLevel()) {
            return false;
        }
        PlannerLevel plannerLevel = plannerContext.getPlannerLevelFor(this.plannerLevelClass);
        if (plannerLevel == null) {
            return false;
        }
        if (!((PlannedOperation)operator.getOperation()).supportsPlannerLevel(plannerLevel)) {
            return false;
        }
        return operator.getPlannerLevel().isStricterThan(plannerLevel);
    }
}

