/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.expression;

import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ScopeExpression;

public class PathScopeExpression
extends ScopeExpression {
    public static final PathScopeExpression BLOCKING = new PathScopeExpression(Mode.Blocking);
    public static final PathScopeExpression NON_BLOCKING = new PathScopeExpression(Mode.NonBlocking);
    public static final PathScopeExpression ALL_BLOCKING = new PathScopeExpression(ScopeExpression.Applies.All, Mode.Blocking);
    public static final PathScopeExpression ALL_NON_BLOCKING = new PathScopeExpression(ScopeExpression.Applies.All, Mode.NonBlocking);
    public static final PathScopeExpression ANY_BLOCKING = new PathScopeExpression(ScopeExpression.Applies.Any, Mode.Blocking);
    public static final PathScopeExpression ANY_NON_BLOCKING = new PathScopeExpression(ScopeExpression.Applies.Any, Mode.NonBlocking);
    public static final PathScopeExpression ALL_BLOCKING_NO_CAPTURE = new PathScopeExpression(false, ScopeExpression.Applies.All, Mode.Blocking);
    public static final PathScopeExpression ALL_NON_BLOCKING_NO_CAPTURE = new PathScopeExpression(false, ScopeExpression.Applies.All, Mode.NonBlocking);
    private Mode mode = Mode.Ignore;

    public PathScopeExpression() {
    }

    public PathScopeExpression(ScopeExpression.Applies applies) {
        this.applies = applies;
    }

    public PathScopeExpression(boolean capture, ScopeExpression.Applies applies) {
        super(capture, applies);
    }

    public PathScopeExpression(Mode mode) {
        this.mode = mode;
    }

    public PathScopeExpression(ScopeExpression.Applies applies, Mode mode) {
        super(applies);
        this.mode = mode;
    }

    public PathScopeExpression(boolean capture, ScopeExpression.Applies applies, Mode mode) {
        super(capture, applies);
        this.mode = mode;
    }

    @Override
    public boolean acceptsAll() {
        return this.appliesToAllPaths() && this.isIgnoreMode();
    }

    public boolean isIgnoreMode() {
        return this.mode == Mode.Ignore;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public boolean applies(PlannerContext plannerContext, ElementGraph elementGraph, Scope scope) {
        switch (this.mode) {
            case Ignore: {
                return true;
            }
            case Blocking: {
                return !scope.isNonBlocking();
            }
            case NonBlocking: {
                return scope.isNonBlocking();
            }
        }
        throw new IllegalStateException("should never reach here");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PathScopeExpression{");
        sb.append("capture=").append(this.capture);
        sb.append(", applies=").append((Object)this.applies);
        sb.append(", mode=").append((Object)this.mode);
        sb.append('}');
        return sb.toString();
    }

    public static enum Mode {
        Ignore,
        Blocking,
        NonBlocking;

    }
}

