/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.expression;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import java.util.Arrays;

public class OrElementExpression
extends ElementExpression {
    String name;
    ElementExpression[] matchers;

    public static ElementExpression or(String name, ElementExpression ... elementMatchers) {
        return new OrElementExpression(name, elementMatchers);
    }

    public static ElementExpression or(String name, ElementCapture capture, ElementExpression ... elementMatchers) {
        return new OrElementExpression(name, capture, elementMatchers);
    }

    public static ElementExpression or(ElementExpression ... elementMatchers) {
        return new OrElementExpression(elementMatchers);
    }

    public static ElementExpression or(ElementCapture capture, ElementExpression ... elementMatchers) {
        return new OrElementExpression(capture, elementMatchers);
    }

    public OrElementExpression(String name, ElementExpression ... matchers) {
        this.name = name;
        this.matchers = matchers;
    }

    public OrElementExpression(String name, ElementCapture capture, ElementExpression ... matchers) {
        super(capture);
        this.name = name;
        this.matchers = matchers;
    }

    public OrElementExpression(ElementExpression ... matchers) {
        this.matchers = matchers;
    }

    public OrElementExpression(ElementCapture capture, ElementExpression ... matchers) {
        super(capture);
        this.matchers = matchers;
    }

    @Override
    public boolean applies(PlannerContext plannerContext, ElementGraph elementGraph, FlowElement flowElement) {
        for (ElementExpression matcher : this.matchers) {
            if (!matcher.applies(plannerContext, elementGraph, flowElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder("Or{");
        sb.append(Arrays.toString(this.matchers));
        sb.append('}');
        return sb.toString();
    }
}

