/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.expression;

import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import cascading.flow.planner.iso.expression.PathScopeExpression;
import cascading.flow.planner.iso.expression.ScopeExpression;
import cascading.flow.planner.iso.finder.SearchOrder;
import cascading.util.Util;
import cascading.util.jgrapht.DOTExporter;
import cascading.util.jgrapht.IntegerNameProvider;
import cascading.util.jgrapht.StringEdgeNameProvider;
import cascading.util.jgrapht.StringNameProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.ClassBasedEdgeFactory;
import org.jgrapht.graph.DirectedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionGraph {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionGraph.class);
    private final SearchOrder searchOrder;
    private final DirectedMultigraph<ElementExpression, ScopeExpression> graph;
    private boolean allowNonRecursiveMatching;

    public ExpressionGraph() {
        this.searchOrder = SearchOrder.ReverseTopological;
        this.graph = new DirectedMultigraph((EdgeFactory)new ClassBasedEdgeFactory(PathScopeExpression.class));
        this.allowNonRecursiveMatching = true;
    }

    public ExpressionGraph(boolean allowNonRecursiveMatching) {
        this();
        this.allowNonRecursiveMatching = allowNonRecursiveMatching;
    }

    public ExpressionGraph(ElementExpression ... matchers) {
        this();
        this.arcs(matchers);
    }

    public ExpressionGraph(SearchOrder searchOrder, ElementExpression ... matchers) {
        this(searchOrder);
        this.arcs(matchers);
    }

    public ExpressionGraph(SearchOrder searchOrder) {
        this(searchOrder, true);
    }

    public ExpressionGraph(SearchOrder searchOrder, boolean allowNonRecursiveMatching) {
        this.searchOrder = searchOrder;
        this.graph = new DirectedMultigraph((EdgeFactory)new ClassBasedEdgeFactory(PathScopeExpression.class));
        this.allowNonRecursiveMatching = allowNonRecursiveMatching;
    }

    public DirectedMultigraph<ElementExpression, ScopeExpression> getGraph() {
        return this.graph;
    }

    public SearchOrder getSearchOrder() {
        return this.searchOrder;
    }

    public boolean supportsNonRecursiveMatch() {
        return this.allowNonRecursiveMatching && this.getGraph().vertexSet().size() == 1 && ((ElementExpression)Util.getFirst(this.getGraph().vertexSet())).getCapture() == ElementCapture.Primary;
    }

    public ExpressionGraph setAllowNonRecursiveMatching(boolean allowNonRecursiveMatching) {
        this.allowNonRecursiveMatching = allowNonRecursiveMatching;
        return this;
    }

    public ExpressionGraph arcs(ElementExpression ... matchers) {
        ElementExpression lhs = null;
        for (ElementExpression matcher : matchers) {
            this.graph.addVertex((Object)matcher);
            if (lhs != null) {
                this.graph.addEdge((Object)lhs, (Object)matcher);
            }
            lhs = matcher;
        }
        return this;
    }

    public ExpressionGraph arc(ElementExpression lhsMatcher, ScopeExpression scopeMatcher, ElementExpression rhsMatcher) {
        this.graph.addVertex((Object)lhsMatcher);
        this.graph.addVertex((Object)rhsMatcher);
        this.graph.addEdge((Object)lhsMatcher, (Object)rhsMatcher, (Object)new DelegateScopeExpression(scopeMatcher));
        return this;
    }

    public void writeDOT(String filename) {
        try {
            File parentFile = new File(filename).getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileWriter writer = new FileWriter(filename);
            new DOTExporter<ElementExpression, ScopeExpression>(new IntegerNameProvider(), new StringNameProvider(), new StringEdgeNameProvider()).export(writer, (Graph<ElementExpression, ScopeExpression>)this.getGraph());
            ((Writer)writer).close();
            Util.writePDF(filename);
        }
        catch (IOException exception) {
            LOG.error("failed printing expression graph to: {}, with exception: {}", (Object)filename, (Object)exception);
        }
    }

    public static ScopeExpression unwind(ScopeExpression scopeExpression) {
        if (scopeExpression instanceof DelegateScopeExpression) {
            return ((DelegateScopeExpression)scopeExpression).delegate;
        }
        return scopeExpression;
    }

    private static class DelegateScopeExpression
    extends ScopeExpression {
        ScopeExpression delegate;

        protected DelegateScopeExpression(ScopeExpression delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isCapture() {
            return this.delegate.isCapture();
        }

        @Override
        public boolean acceptsAll() {
            return this.delegate.acceptsAll();
        }

        @Override
        public boolean appliesToAllPaths() {
            return this.delegate.appliesToAllPaths();
        }

        @Override
        public boolean appliesToAnyPath() {
            return this.delegate.appliesToAnyPath();
        }

        @Override
        public boolean appliesToEachPath() {
            return this.delegate.appliesToEachPath();
        }

        @Override
        public boolean applies(PlannerContext plannerContext, ElementGraph elementGraph, Scope scope) {
            return this.delegate.applies(plannerContext, elementGraph, scope);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

