/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.expression;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import java.util.Arrays;

public class AndElementExpression
extends ElementExpression {
    String name;
    ElementExpression[] matchers;

    public static ElementExpression and(String name, ElementExpression ... elementMatchers) {
        return new AndElementExpression(name, elementMatchers);
    }

    public static ElementExpression and(String name, ElementCapture capture, ElementExpression ... elementMatchers) {
        return new AndElementExpression(name, capture, elementMatchers);
    }

    public static ElementExpression and(ElementExpression ... elementMatchers) {
        return new AndElementExpression(elementMatchers);
    }

    public static ElementExpression and(ElementCapture capture, ElementExpression ... elementMatchers) {
        return new AndElementExpression(capture, elementMatchers);
    }

    public AndElementExpression(String name, ElementExpression ... matchers) {
        this.matchers = matchers;
    }

    public AndElementExpression(String name, ElementCapture capture, ElementExpression ... matchers) {
        super(capture);
        this.matchers = matchers;
    }

    public AndElementExpression(ElementExpression ... matchers) {
        this.matchers = matchers;
    }

    public AndElementExpression(ElementCapture capture, ElementExpression ... matchers) {
        super(capture);
        this.matchers = matchers;
    }

    @Override
    public boolean applies(PlannerContext plannerContext, ElementGraph elementGraph, FlowElement flowElement) {
        for (ElementExpression matcher : this.matchers) {
            if (matcher.applies(plannerContext, elementGraph, flowElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder("And{");
        sb.append(Arrays.toString(this.matchers));
        sb.append('}');
        return sb.toString();
    }
}

