/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.assertion;

import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.assertion.Asserted;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.finder.GraphFinder;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.Transformed;

public abstract class GraphAssert<E extends ElementGraph> {
    private final GraphFinder finder;
    private final String message;
    private AssertionType assertionType = AssertionType.Illegal;

    public GraphAssert(ExpressionGraph expressionGraph, String message) {
        this(expressionGraph, message, null);
    }

    public GraphAssert(ExpressionGraph expressionGraph, String message, AssertionType assertionType) {
        this.finder = new GraphFinder(expressionGraph);
        this.message = message;
        if (assertionType != null) {
            this.assertionType = assertionType;
        }
    }

    protected abstract Transformed transform(PlannerContext var1, E var2);

    public Asserted assertion(PlannerContext plannerContext, E graph) {
        Transformed transform = this.transform(plannerContext, graph);
        if (transform != null && transform.getEndGraph() != null) {
            graph = transform.getEndGraph();
        }
        Match match = this.finder.findFirstMatch(plannerContext, (ElementGraph)graph);
        Asserted asserted = new Asserted(plannerContext, this, (ElementGraph)graph, this.message, this.assertionType, match);
        if (transform != null) {
            asserted.addChildTransform(transform);
        }
        return asserted;
    }

    public static enum AssertionType {
        Unsupported,
        Illegal;

    }
}

