/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso.assertion;

import cascading.flow.FlowElement;
import cascading.flow.planner.PlannerContext;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementSubGraph;
import cascading.flow.planner.iso.GraphResult;
import cascading.flow.planner.iso.assertion.GraphAssert;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.Transformed;
import cascading.flow.planner.rule.Rule;
import cascading.util.Util;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Asserted
extends GraphResult {
    PlannerContext plannerContext;
    GraphAssert graphAssert;
    ElementGraph beginGraph;
    final String message;
    private GraphAssert.AssertionType assertionType;
    final Match match;
    List<Transformed> childTransforms;

    public Asserted(PlannerContext plannerContext, GraphAssert graphAssert, ElementGraph beginGraph, String message, GraphAssert.AssertionType assertionType, Match match) {
        this.plannerContext = plannerContext;
        this.graphAssert = graphAssert;
        this.beginGraph = beginGraph;
        this.message = message;
        this.assertionType = assertionType;
        this.match = match;
    }

    public GraphAssert getGraphAssert() {
        return this.graphAssert;
    }

    @Override
    public ElementGraph getBeginGraph() {
        return this.beginGraph;
    }

    public String getMessage() {
        String result = this.message;
        for (ElementCapture capture : ElementCapture.values()) {
            Iterator<FlowElement> iterator = this.match.getCapturedElements(capture).iterator();
            while (result.contains("{" + (Object)((Object)capture) + "}") && iterator.hasNext()) {
                result = result.replaceFirst("\\{" + (Object)((Object)capture) + "\\}", iterator.next().toString());
            }
        }
        return result;
    }

    public GraphAssert.AssertionType getAssertionType() {
        return this.assertionType;
    }

    @Override
    public String getRuleName() {
        if (this.getGraphAssert() instanceof Rule) {
            return ((Rule)((Object)this.getGraphAssert())).getRuleName();
        }
        return "none";
    }

    public ElementSubGraph getMatched() {
        return this.match.getMatchedGraph();
    }

    public Set<FlowElement> getAnchors() {
        return this.match.getCapturedElements(ElementCapture.Primary);
    }

    public FlowElement getFirstAnchor() {
        return Util.getFirst(this.getAnchors());
    }

    public ElementGraph getEndGraph() {
        return null;
    }

    public List<Transformed> getChildTransforms() {
        if (this.childTransforms == null) {
            this.childTransforms = new LinkedList<Transformed>();
        }
        return this.childTransforms;
    }

    public void addChildTransform(Transformed transformed) {
        if (this.plannerContext.isTransformTracingEnabled()) {
            this.getChildTransforms().add(transformed);
        }
    }

    @Override
    public void writeDOTs(String path) {
        int count = 0;
        for (int i = 0; i < this.getChildTransforms().size(); ++i) {
            Transformed transformed = this.getChildTransforms().get(i);
            String name = transformed.getTransformerName();
            transformed.writeDOTs(path + "/child-" + i + "-" + name + "/");
        }
        count = this.writeBeginGraph(path, count);
        this.writeEndGraph(path, count);
    }
}

