/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.iso;

import cascading.flow.planner.graph.ElementGraph;
import java.io.File;

public abstract class GraphResult<R extends ElementGraph> {
    public abstract ElementGraph getBeginGraph();

    public abstract String getRuleName();

    public abstract R getEndGraph();

    public abstract void writeDOTs(String var1);

    protected void writeEndGraph(String path, int count) {
        if (this.getEndGraph() != null) {
            String name = this.getEndGraph().getClass().getSimpleName();
            this.getEndGraph().writeDOT(new File(path, this.makeFileName(count, name, "end")).toString());
        }
    }

    protected int writeBeginGraph(String path, int count) {
        if (this.getBeginGraph() != null) {
            String name = this.getBeginGraph().getClass().getSimpleName();
            this.getBeginGraph().writeDOT(new File(path, this.makeFileName(count++, name, "begin")).toString());
        }
        return count;
    }

    protected String makeFileName(int ordinal, String name, String state) {
        return String.format("%04d-%s-%s.dot", ordinal, name, state);
    }
}

