/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.graph;

import cascading.flow.FlowElement;
import cascading.flow.FlowElements;
import cascading.flow.planner.ElementGraphException;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.BaseElementGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementMultiGraph;
import cascading.flow.planner.graph.Extent;
import cascading.pipe.Checkpoint;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.pipe.SubAssembly;
import cascading.tap.Tap;
import cascading.util.EnumMultiMap;
import cascading.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowElementGraph
extends ElementMultiGraph
implements AnnotatedGraph {
    private static final Logger LOG = LoggerFactory.getLogger(FlowElementGraph.class);
    private boolean resolved;
    protected PlatformInfo platformInfo;
    protected Map<String, Tap> sources;
    protected Map<String, Tap> sinks;
    protected Map<String, Tap> traps;
    protected Map<String, Tap> checkpoints;
    private boolean requireUniqueCheckpoints;

    protected FlowElementGraph() {
    }

    public FlowElementGraph(FlowElementGraph flowElementGraph) {
        this();
        this.platformInfo = flowElementGraph.platformInfo;
        this.sources = flowElementGraph.sources;
        this.sinks = flowElementGraph.sinks;
        this.traps = flowElementGraph.traps;
        this.checkpoints = flowElementGraph.checkpoints;
        this.requireUniqueCheckpoints = flowElementGraph.requireUniqueCheckpoints;
        if (flowElementGraph.annotations != null) {
            this.annotations = new EnumMultiMap(flowElementGraph.annotations);
        }
        this.copyFrom(flowElementGraph);
    }

    public FlowElementGraph(PlatformInfo platformInfo, ElementGraph elementGraph, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Map<String, Tap> checkpoints) {
        this();
        this.platformInfo = platformInfo;
        if (elementGraph == null) {
            elementGraph = BaseElementGraph.NULL;
        }
        if (sources == null || sources.isEmpty()) {
            throw new IllegalArgumentException("sources may not be null or empty");
        }
        if (sinks == null || sinks.isEmpty()) {
            throw new IllegalArgumentException("sinks may not be null or empty");
        }
        this.sources = new HashMap<String, Tap>(sources);
        this.sinks = new HashMap<String, Tap>(sinks);
        this.traps = new HashMap<String, Tap>(traps == null ? Collections.emptyMap() : traps);
        this.checkpoints = new HashMap<String, Tap>(checkpoints == null ? Collections.emptyMap() : checkpoints);
        EnumMultiMap<FlowElement> annotations = ElementGraphs.annotations(elementGraph);
        if (annotations != null) {
            this.annotations = new EnumMultiMap(annotations);
        }
        this.copyFrom(ElementGraphs.asExtentMaskedSubGraph(elementGraph));
        this.bindExtents();
    }

    public FlowElementGraph(Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks) {
        this(null, pipes, sources, sinks, Collections.emptyMap(), Collections.emptyMap(), false);
    }

    public FlowElementGraph(PlatformInfo platformInfo, Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Map<String, Tap> checkpoints, boolean requireUniqueCheckpoints) {
        this();
        this.platformInfo = platformInfo;
        this.sources = sources;
        this.sinks = sinks;
        this.traps = traps;
        this.checkpoints = checkpoints;
        this.requireUniqueCheckpoints = requireUniqueCheckpoints;
        this.assembleGraph(pipes, sources, sinks);
        this.verifyGraph();
    }

    public Map<String, Tap> getSourceMap() {
        return this.sources;
    }

    public Map<String, Tap> getSinkMap() {
        return this.sinks;
    }

    public Map<String, Tap> getTrapMap() {
        return this.traps;
    }

    public Map<String, Tap> getCheckpointsMap() {
        return this.checkpoints;
    }

    public Collection<Tap> getSources() {
        return this.sources.values();
    }

    public Collection<Tap> getSinks() {
        return this.sinks.values();
    }

    public Collection<Tap> getTraps() {
        return this.traps.values();
    }

    protected void initialize(Map<String, Tap> sources, Map<String, Tap> sinks, Pipe ... tails) {
        this.sources = sources;
        this.sinks = sinks;
        this.traps = Util.createHashMap();
        this.assembleGraph(tails, sources, sinks);
        this.verifyGraph();
    }

    private void assembleGraph(Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks) {
        HashMap<String, Tap> sourcesCopy = new HashMap<String, Tap>(sources);
        HashMap<String, Tap> sinksCopy = new HashMap<String, Tap>(sinks);
        for (Pipe pipe : pipes) {
            this.makeGraph(pipe, sourcesCopy, sinksCopy);
        }
        this.addExtents(sources, sinks);
    }

    private void verifyGraph() {
        if (this.vertexSet().isEmpty()) {
            return;
        }
        HashSet<String> checkpointNames = new HashSet<String>();
        TopologicalOrderIterator<FlowElement, Scope> iterator = this.getTopologicalIterator();
        FlowElement flowElement = null;
        while (iterator.hasNext()) {
            try {
                flowElement = (FlowElement)iterator.next();
            }
            catch (IllegalArgumentException exception) {
                if (flowElement == null) {
                    throw new ElementGraphException("unable to traverse to the first element");
                }
                throw new ElementGraphException(flowElement, "unable to traverse to the next element after " + flowElement);
            }
            if (this.requireUniqueCheckpoints && flowElement instanceof Checkpoint) {
                String name = ((Checkpoint)flowElement).getName();
                if (checkpointNames.contains(name)) {
                    throw new ElementGraphException((Pipe)flowElement, "may not have duplicate checkpoint names in assembly, found: " + name);
                }
                checkpointNames.add(name);
            }
            if (this.incomingEdgesOf(flowElement).size() != 0 && this.outgoingEdgesOf(flowElement).size() != 0 || flowElement instanceof Extent) continue;
            if (flowElement instanceof Pipe) {
                if (this.incomingEdgesOf(flowElement).size() == 0) {
                    throw new ElementGraphException((Pipe)flowElement, "no Tap connected to head Pipe: " + flowElement + ", possible ambiguous branching, try explicitly naming tails");
                }
                throw new ElementGraphException((Pipe)flowElement, "no Tap connected to tail Pipe: " + flowElement + ", possible ambiguous branching, try explicitly naming tails");
            }
            if (flowElement instanceof Tap) {
                throw new ElementGraphException((Tap)flowElement, "no Pipe connected to Tap: " + flowElement);
            }
            throw new ElementGraphException(flowElement, "unknown element type: " + flowElement);
        }
    }

    protected FlowElementGraph shallowCopyElementGraph() {
        FlowElementGraph copy = new FlowElementGraph();
        Graphs.addGraph((Graph)copy.graph, (Graph)this.graph);
        copy.traps = new HashMap<String, Tap>(this.traps);
        return copy;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    protected boolean allowMultipleExtentEdges() {
        return false;
    }

    private void addExtents(Map<String, Tap> sources, Map<String, Tap> sinks) {
        Scope scope;
        this.addVertex(Extent.head);
        for (String source : sources.keySet()) {
            scope = this.addEdge(Extent.head, sources.get(source));
            if (scope == null) continue;
            scope.setName(source);
        }
        this.addVertex(Extent.tail);
        for (String sink : sinks.keySet()) {
            try {
                scope = this.addEdge(sinks.get(sink), Extent.tail);
            }
            catch (IllegalArgumentException exception) {
                throw new ElementGraphException("missing pipe for sink tap: [" + sink + "]");
            }
            if (scope == null) {
                throw new ElementGraphException("cannot sink to the same path from multiple branches: [" + Util.join(sinks.values()) + "]");
            }
            scope.setName(sink);
        }
    }

    private void makeGraph(Pipe current, Map<String, Tap> sources, Map<String, Tap> sinks) {
        Tap source;
        LOG.debug("adding pipe: {}", (Object)current);
        if (current instanceof SubAssembly) {
            for (Pipe pipe : SubAssembly.unwind(current.getPrevious())) {
                this.makeGraph(pipe, sources, sinks);
            }
            return;
        }
        if (this.containsVertex(current)) {
            return;
        }
        this.addVertex(current);
        Tap sink = sinks.remove(current.getName());
        if (sink != null) {
            LOG.debug("adding sink: {}", (Object)sink);
            this.addVertex(sink);
            LOG.debug("adding edge: {} -> {}", (Object)current, (Object)sink);
            this.addEdge(current, sink).setName(current.getName());
        }
        if (SubAssembly.unwind(current.getPrevious()).length == 0 && (source = sources.remove(current.getName())) != null) {
            LOG.debug("adding source: {}", (Object)source);
            this.addVertex(source);
            LOG.debug("adding edge: {} -> {}", (Object)source, (Object)current);
            Scope scope = this.addEdge(source, current);
            scope.setName(current.getName());
            this.setOrdinal(source, current, scope);
        }
        for (Pipe previous : SubAssembly.unwind(current.getPrevious())) {
            this.makeGraph(previous, sources, sinks);
            LOG.debug("adding edge: {} -> ", (Object)previous, (Object)current);
            if (this.getEdge(previous, current) != null) {
                throw new ElementGraphException(previous, "cannot distinguish pipe branches, give pipe unique name: " + previous);
            }
            Scope scope = this.addEdge(previous, current);
            scope.setName(previous.getName());
            this.setOrdinal(previous, current, scope);
        }
    }

    private void setOrdinal(FlowElement previous, Pipe current, Scope scope) {
        if (current instanceof Splice) {
            Splice splice = (Splice)current;
            Integer ordinal = previous instanceof Tap ? splice.getPipePos().get(scope.getName()) : FlowElements.findOrdinal(splice, (Pipe)previous);
            scope.setOrdinal(ordinal);
            HashSet<Scope> scopes = new HashSet<Scope>(this.incomingEdgesOf(current));
            scopes.remove(scope);
            for (Scope other : scopes) {
                if (other.getOrdinal() != scope.getOrdinal()) continue;
                throw new IllegalStateException("duplicate ordinals");
            }
            if (splice.isJoin() && ordinal != 0) {
                scope.setNonBlocking(false);
            }
        }
    }

    public TopologicalOrderIterator<FlowElement, Scope> getTopologicalIterator() {
        return new TopologicalOrderIterator(this.graph);
    }

    public DepthFirstIterator<FlowElement, Scope> getDepthFirstIterator() {
        return new DepthFirstIterator(this.graph, (Object)Extent.head);
    }

    private BaseElementGraph copyWithTraps() {
        FlowElementGraph copy = this.shallowCopyElementGraph();
        copy.addTrapsToGraph();
        return copy;
    }

    private void addTrapsToGraph() {
        DepthFirstIterator<FlowElement, Scope> iterator = this.getDepthFirstIterator();
        while (iterator.hasNext()) {
            Pipe pipe;
            Tap trap;
            FlowElement element = (FlowElement)iterator.next();
            if (!(element instanceof Pipe) || (trap = this.traps.get((pipe = (Pipe)element).getName())) == null) continue;
            this.addVertex(trap);
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding trap edge: " + pipe + " -> " + trap);
            }
            if (this.getEdge(pipe, trap) != null) continue;
            this.addEdge(pipe, trap).setName(pipe.getName());
        }
    }

    @Override
    public void writeDOT(String filename) {
        boolean success = ElementGraphs.printElementGraph(filename, this.copyWithTraps(), this.platformInfo);
        if (success) {
            Util.writePDF(filename);
        }
    }

    @Override
    public ElementGraph copyElementGraph() {
        return new FlowElementGraph(this);
    }
}

