/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.graph;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.BaseElementGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jgrapht.graph.MaskSubgraph;

public class ElementMaskSubGraph
extends BaseElementGraph
implements ElementGraph {
    private ElementGraph elementGraph;
    private VertexMask vertexMask;
    private EdgeMask edgeMask;

    public ElementMaskSubGraph(ElementGraph elementGraph, FlowElement ... maskedFlowElements) {
        this(elementGraph, new VertexMask(Arrays.asList(maskedFlowElements)), new EdgeMask(null));
    }

    public ElementMaskSubGraph(ElementGraph elementGraph, Collection<FlowElement> maskedFlowElements) {
        this(elementGraph, new VertexMask(maskedFlowElements), new EdgeMask(null));
    }

    public ElementMaskSubGraph(ElementGraph elementGraph, Collection<FlowElement> maskedFlowElements, Collection<Scope> maskedScopes) {
        this(elementGraph, new VertexMask(maskedFlowElements), new EdgeMask(maskedScopes));
    }

    public ElementMaskSubGraph(ElementMaskSubGraph graph) {
        this(graph.elementGraph, graph.vertexMask, graph.edgeMask);
    }

    protected ElementMaskSubGraph(ElementGraph elementGraph, VertexMask vertexMask, EdgeMask edgeMask) {
        this.graph = new DirectedMaskSubGraph(ElementGraphs.directed(elementGraph), vertexMask, edgeMask);
        this.elementGraph = elementGraph;
        this.vertexMask = vertexMask;
        this.edgeMask = edgeMask;
    }

    @Override
    public ElementGraph copyElementGraph() {
        return new ElementMaskSubGraph(this);
    }

    private class DirectedMaskSubGraph
    extends MaskSubgraph<FlowElement, Scope> {
        public DirectedMaskSubGraph(Graph<FlowElement, Scope> base, VertexMask vertexMask, EdgeMask edgeMask) {
            super(base, (Predicate)vertexMask, (Predicate)edgeMask);
        }
    }

    private static class EdgeMask
    implements Predicate<Scope> {
        Set<Scope> maskedScopes = new HashSet<Scope>();

        public EdgeMask(Collection<Scope> scopes) {
            if (scopes != null) {
                this.maskedScopes.addAll(scopes);
            }
        }

        @Override
        public boolean test(Scope scope) {
            return this.maskedScopes.contains(scope);
        }
    }

    private static class VertexMask
    implements Predicate<FlowElement> {
        Set<FlowElement> maskedElements = Util.createIdentitySet();

        public VertexMask(Collection<FlowElement> flowElements) {
            if (flowElements != null) {
                this.maskedElements.addAll(flowElements);
            }
        }

        @Override
        public boolean test(FlowElement flowElement) {
            return this.maskedElements.contains(flowElement);
        }
    }
}

