/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.graph;

import cascading.flow.FlowElement;
import cascading.flow.FlowElements;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.BaseElementGraph;
import cascading.flow.planner.graph.DecoratedElementGraph;
import cascading.flow.planner.graph.ElementDirectedGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementMaskSubGraph;
import cascading.flow.planner.graph.ElementMultiGraph;
import cascading.flow.planner.graph.ElementSubGraph;
import cascading.flow.planner.graph.Extent;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.expression.FlowElementExpression;
import cascading.flow.planner.iso.expression.TypeExpression;
import cascading.flow.planner.iso.finder.SearchOrder;
import cascading.flow.planner.iso.subgraph.SubGraphIterator;
import cascading.flow.planner.iso.subgraph.iterator.ExpressionSubGraphIterator;
import cascading.flow.planner.process.FlowStepGraph;
import cascading.flow.planner.process.ProcessGraph;
import cascading.flow.planner.process.ProcessModel;
import cascading.pipe.Group;
import cascading.pipe.Operator;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tap.AdaptorTap;
import cascading.tap.Tap;
import cascading.util.DOTProcessGraphWriter;
import cascading.util.EnumMultiMap;
import cascading.util.Murmur3;
import cascading.util.Pair;
import cascading.util.Util;
import cascading.util.Version;
import cascading.util.jgrapht.ComponentAttributeProvider;
import cascading.util.jgrapht.EdgeNameProvider;
import cascading.util.jgrapht.IntegerNameProvider;
import cascading.util.jgrapht.VertexNameProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.alg.shortestpath.FloydWarshallShortestPaths;
import org.jgrapht.alg.shortestpath.KShortestPaths;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.specifics.DirectedSpecifics;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.jgrapht.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementGraphs {
    private static final Logger LOG = LoggerFactory.getLogger(ElementGraphs.class);

    private ElementGraphs() {
    }

    public static FlowElementGraph asFlowElementGraph(PlatformInfo platformInfo, FlowStepGraph flowStepGraph) {
        ElementMultiGraph elementDirectedGraph = ElementGraphs.asElementMultiGraph(flowStepGraph.getElementGraphs());
        Map<String, Tap> sources = ElementGraphs.asSourceMap(elementDirectedGraph, ElementGraphs.findSources(elementDirectedGraph));
        Map<String, Tap> sinks = ElementGraphs.asSinkMap(elementDirectedGraph, ElementGraphs.findSinks(elementDirectedGraph));
        return new FlowElementGraph(platformInfo, elementDirectedGraph, sources, sinks, null, null);
    }

    public static ElementDirectedGraph asElementDirectedGraph(Collection<ElementGraph> elementGraphs) {
        ElementDirectedGraph elementDirectedGraph = new ElementDirectedGraph();
        for (ElementGraph elementGraph : elementGraphs) {
            elementDirectedGraph.copyFrom(ElementGraphs.asExtentMaskedSubGraph(elementGraph));
        }
        return elementDirectedGraph;
    }

    public static ElementMultiGraph asElementMultiGraph(Collection<ElementGraph> elementGraphs) {
        ElementMultiGraph elementDirectedGraph = new ElementMultiGraph();
        for (ElementGraph elementGraph : elementGraphs) {
            elementDirectedGraph.copyFrom(ElementGraphs.asExtentMaskedSubGraph(elementGraph));
        }
        return elementDirectedGraph;
    }

    public static boolean isEmpty(ElementGraph elementGraph) {
        int size = elementGraph.vertexSet().size();
        if (size == 0) {
            return true;
        }
        return size == 2 && elementGraph.containsVertex(Extent.head) && elementGraph.containsVertex(Extent.tail);
    }

    public static Graph<FlowElement, Scope> directed(ElementGraph elementGraph) {
        if (elementGraph == null) {
            return null;
        }
        if (elementGraph instanceof DecoratedElementGraph) {
            return ElementGraphs.directed(((DecoratedElementGraph)elementGraph).getDecorated());
        }
        return ((BaseElementGraph)elementGraph).graph;
    }

    public static EnumMultiMap<FlowElement> annotations(ElementGraph elementGraph) {
        if (elementGraph == null) {
            return null;
        }
        if (elementGraph instanceof DecoratedElementGraph) {
            return ElementGraphs.annotations(((DecoratedElementGraph)elementGraph).getDecorated());
        }
        if (elementGraph instanceof AnnotatedGraph) {
            return ((AnnotatedGraph)((Object)elementGraph)).getAnnotations();
        }
        return null;
    }

    public static boolean isMultiGraph(ElementGraph elementGraph) {
        return ElementGraphs.directed(elementGraph) instanceof DirectedMultigraph;
    }

    public static int hashCodeIgnoreAnnotations(ElementGraph elementGraph) {
        return ElementGraphs.hashCodeIgnoreAnnotations(ElementGraphs.directed(elementGraph));
    }

    public static <V, E> int hashCodeIgnoreAnnotations(Graph<V, E> graph) {
        int hash = graph.vertexSet().hashCode();
        for (Object e : graph.edgeSet()) {
            int part = e.hashCode();
            int source = graph.getEdgeSource(e).hashCode();
            int target = graph.getEdgeTarget(e).hashCode();
            int pairing = ElementGraphs.pair(source, target);
            part = 27 * part + pairing;
            long weight = (long)graph.getEdgeWeight(e);
            part = 27 * part + (int)(weight ^ weight >>> 32);
            hash += part;
        }
        return hash;
    }

    public static boolean equalsIgnoreAnnotations(ElementGraph lhs, ElementGraph rhs) {
        return ElementGraphs.equalsIgnoreAnnotations(ElementGraphs.directed(lhs), ElementGraphs.directed(rhs));
    }

    public static <V, E> boolean equalsIgnoreAnnotations(Graph<V, E> lhs, Graph<V, E> rhs) {
        if (lhs == rhs) {
            return true;
        }
        TypeUtil typeDecl = null;
        Graph lhsGraph = (Graph)TypeUtil.uncheckedCast(lhs, typeDecl);
        Graph rhsGraph = (Graph)TypeUtil.uncheckedCast(rhs, typeDecl);
        if (!lhsGraph.vertexSet().equals(rhsGraph.vertexSet())) {
            return false;
        }
        if (lhsGraph.edgeSet().size() != rhsGraph.edgeSet().size()) {
            return false;
        }
        for (Object e : lhsGraph.edgeSet()) {
            Object source = lhsGraph.getEdgeSource(e);
            Object target = lhsGraph.getEdgeTarget(e);
            if (!rhsGraph.containsEdge(e)) {
                return false;
            }
            if (!rhsGraph.getEdgeSource(e).equals(source) || !rhsGraph.getEdgeTarget(e).equals(target)) {
                return false;
            }
            if (!(Math.abs(lhsGraph.getEdgeWeight(e) - rhsGraph.getEdgeWeight(e)) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(ElementGraph lhs, ElementGraph rhs) {
        if (!ElementGraphs.equalsIgnoreAnnotations(lhs, rhs)) {
            return false;
        }
        if (!(lhs instanceof AnnotatedGraph) && !(rhs instanceof AnnotatedGraph)) {
            return true;
        }
        if (!(lhs instanceof AnnotatedGraph) || !(rhs instanceof AnnotatedGraph)) {
            return false;
        }
        AnnotatedGraph lhsAnnotated = (AnnotatedGraph)((Object)lhs);
        AnnotatedGraph rhsAnnotated = (AnnotatedGraph)((Object)rhs);
        if (lhsAnnotated.hasAnnotations() != rhsAnnotated.hasAnnotations()) {
            return false;
        }
        if (!lhsAnnotated.hasAnnotations()) {
            return true;
        }
        return lhsAnnotated.getAnnotations().equals(rhsAnnotated.getAnnotations());
    }

    public static String canonicalHash(ElementGraph graph) {
        return ElementGraphs.canonicalHash(ElementGraphs.directed(graph));
    }

    public static String canonicalHash(Graph<FlowElement, Scope> graph) {
        int hash = -1756908916;
        int edges = 0;
        boolean hasExtents = false;
        for (Scope e : graph.edgeSet()) {
            FlowElement edgeSource = (FlowElement)graph.getEdgeSource((Object)e);
            FlowElement edgeTarget = (FlowElement)graph.getEdgeTarget((Object)e);
            if (edgeSource instanceof Extent || edgeTarget instanceof Extent) {
                hasExtents = true;
                continue;
            }
            int source = ElementGraphs.hash(edgeSource);
            int target = ElementGraphs.hash(edgeTarget);
            int pairing = ElementGraphs.pair(source, target);
            hash += pairing;
            ++edges;
        }
        int vertexes = graph.vertexSet().size() - (hasExtents ? 2 : 0);
        hash = Murmur3.fmix(hash, vertexes * edges);
        return Util.getHex(Util.intToByteArray(hash));
    }

    private static int hash(FlowElement flowElement) {
        int lhs = flowElement.getClass().getName().hashCode();
        int rhs = 0;
        if (flowElement instanceof Operator && ((Operator)flowElement).getOperation() != null) {
            rhs = ((Operator)flowElement).getOperation().getClass().getName().hashCode();
        } else if (flowElement instanceof AdaptorTap && ((AdaptorTap)flowElement).getOriginal().getScheme() != null) {
            rhs = ((AdaptorTap)flowElement).getOriginal().getScheme().getClass().getName().hashCode();
        } else if (flowElement instanceof Tap && ((Tap)flowElement).getScheme() != null) {
            rhs = ((Tap)flowElement).getScheme().getClass().getName().hashCode();
        } else if (flowElement instanceof Splice) {
            rhs = ((Splice)flowElement).getJoiner().getClass().getName().hashCode() + 31 * ((Splice)flowElement).getNumSelfJoins();
        }
        return ElementGraphs.pair(lhs, rhs);
    }

    protected static int pair(int lhs, int rhs) {
        if (rhs == 0) {
            return lhs;
        }
        return (lhs + rhs) * (lhs + rhs + 1) / 2 + rhs;
    }

    public static Iterator<FlowElement> getTopologicalIterator(ElementGraph graph) {
        if (graph == null) {
            return Collections.emptyIterator();
        }
        return new TopologicalOrderIterator(ElementGraphs.directed(graph));
    }

    public static Iterator<FlowElement> getReverseTopologicalIterator(ElementGraph graph) {
        return new TopologicalOrderIterator((Graph)new EdgeReversedGraph(ElementGraphs.directed(graph)));
    }

    public static Collection<FlowElement> getAllElementsBetweenExclusive(ElementGraph graph, FlowElement from, FlowElement to) {
        Collection<FlowElement> results = ElementGraphs.getAllElementsBetweenInclusive(graph, from, to);
        results.remove(from);
        results.remove(to);
        return results;
    }

    public static Collection<FlowElement> getAllElementsBetweenInclusive(ElementGraph graph, FlowElement from, FlowElement to) {
        Set<FlowElement> results = Util.createIdentitySet();
        List<GraphPath<FlowElement, Scope>> pathsBetween = ElementGraphs.getAllShortestPathsBetween(graph, from, to);
        for (GraphPath<FlowElement, Scope> graphPath : pathsBetween) {
            results.addAll(graphPath.getVertexList());
        }
        return results;
    }

    public static List<GraphPath<FlowElement, Scope>> getAllShortestPathsBetween(ElementGraph graph, FlowElement from, FlowElement to) {
        return ElementGraphs.getAllShortestPathsBetween(ElementGraphs.directed(graph), from, to);
    }

    public static <V, E> List<GraphPath<V, E>> getAllShortestPathsBetween(Graph<V, E> graph, V from, V to) {
        List paths = new KShortestPaths(graph, Integer.MAX_VALUE).getPaths(from, to);
        if (paths == null) {
            return new ArrayList<GraphPath<V, E>>();
        }
        return paths;
    }

    public static ElementSubGraph asSubGraph(ElementGraph elementGraph, ElementGraph contractedGraph, Set<FlowElement> excludes) {
        elementGraph = ElementGraphs.asExtentMaskedSubGraph(elementGraph);
        Pair<Set<FlowElement>, Set<Scope>> pair = ElementGraphs.findClosureViaFloydWarshall(ElementGraphs.directed(elementGraph), ElementGraphs.directed(contractedGraph), excludes);
        Set<FlowElement> vertices = pair.getLhs();
        Set<Scope> excludeEdges = pair.getRhs();
        HashSet<Scope> scopes = new HashSet<Scope>(elementGraph.edgeSet());
        scopes.removeAll(excludeEdges);
        return new ElementSubGraph(elementGraph, vertices, scopes);
    }

    public static ElementGraph asExtentMaskedSubGraph(ElementGraph elementGraph) {
        if (elementGraph.containsVertex(Extent.head) || elementGraph.containsVertex(Extent.tail)) {
            return new ElementMaskSubGraph(elementGraph, Extent.head, Extent.tail);
        }
        return elementGraph;
    }

    public static <V, E> Pair<Set<V>, Set<E>> findClosureViaFloydWarshall(DirectedGraph<V, E> full, DirectedGraph<V, E> contracted) {
        return ElementGraphs.findClosureViaFloydWarshall(full, contracted, null);
    }

    public static <V, E> Pair<Set<V>, Set<E>> findClosureViaFloydWarshall(Graph<V, E> full, Graph<V, E> contracted, Set<V> excludes) {
        Set vertices = Util.createIdentitySet(contracted.vertexSet());
        LinkedList allVertices = new LinkedList(full.vertexSet());
        allVertices.removeAll(vertices);
        HashSet excludeEdges = new HashSet();
        if (excludes != null) {
            for (Object v : excludes) {
                if (!full.containsVertex(v)) continue;
                excludeEdges.addAll(full.incomingEdgesOf(v));
                excludeEdges.addAll(full.outgoingEdgesOf(v));
            }
        }
        for (Object v : contracted.vertexSet()) {
            if (contracted.inDegreeOf(v) == 0) {
                excludeEdges.addAll(full.incomingEdgesOf(v));
            }
            if (contracted.outDegreeOf(v) != 0) continue;
            excludeEdges.addAll(full.outgoingEdgesOf(v));
        }
        for (Object outer : contracted.vertexSet()) {
            for (Object inner : contracted.vertexSet()) {
                if (outer == inner || !contracted.getAllEdges(inner, outer).isEmpty()) continue;
                excludeEdges.addAll(full.getAllEdges(inner, outer));
            }
        }
        Graph<V, E> disconnected = ElementGraphs.disconnectExtentsAndExclude(full, excludeEdges);
        FloydWarshallShortestPaths paths = new FloydWarshallShortestPaths(disconnected);
        for (Object edge : contracted.edgeSet()) {
            Object edgeSource = contracted.getEdgeSource(edge);
            Object edgeTarget = contracted.getEdgeTarget(edge);
            ListIterator iterator = allVertices.listIterator();
            while (iterator.hasNext()) {
                Object vertex = iterator.next();
                if (!ElementGraphs.isBetween(paths, edgeSource, edgeTarget, vertex)) continue;
                vertices.add(vertex);
                iterator.remove();
            }
        }
        return new Pair<Set<V>, Set<E>>(vertices, excludeEdges);
    }

    private static <V, E> Graph<V, E> disconnectExtentsAndExclude(Graph<V, E> full, Set<E> withoutEdges) {
        IdentityMultiGraphGraph copy = new IdentityMultiGraphGraph(Object.class);
        Graphs.addAllVertices(copy, (Collection)full.vertexSet());
        copy.removeVertex(Extent.head);
        copy.removeVertex(Extent.tail);
        HashSet edges = full.edgeSet();
        if (!withoutEdges.isEmpty()) {
            edges = new HashSet(edges);
            edges.removeAll(withoutEdges);
        }
        Graphs.addAllEdges(copy, full, (Collection)edges);
        return copy;
    }

    private static <V, E> boolean isBetween(FloydWarshallShortestPaths<V, E> paths, V edgeSource, V edgeTarget, V vertex) {
        return paths.getFirstHop(edgeSource, vertex) != null && paths.getFirstHop(vertex, edgeTarget) != null;
    }

    public static void removeAndContract(ElementGraph elementGraph, FlowElement flowElement) {
        LOG.debug("removing element, contracting edge for: {}", (Object)flowElement);
        Set<Scope> incomingScopes = elementGraph.incomingEdgesOf(flowElement);
        boolean contractIncoming = true;
        if (!contractIncoming && incomingScopes.size() != 1) {
            throw new IllegalStateException("flow element:" + flowElement + ", has multiple input paths: " + incomingScopes.size());
        }
        boolean isJoin = flowElement instanceof Splice && ((Splice)flowElement).isJoin();
        for (Scope incoming : incomingScopes) {
            Set<Scope> outgoingScopes = elementGraph.outgoingEdgesOf(flowElement);
            FlowElement source = elementGraph.getEdgeSource(incoming);
            for (Scope outgoing : outgoingScopes) {
                FlowElement target = elementGraph.getEdgeTarget(outgoing);
                boolean isNonBlocking = outgoing.isNonBlocking();
                if (isJoin) {
                    isNonBlocking = isNonBlocking && incoming.isNonBlocking();
                }
                Scope scope = new Scope(outgoing);
                if (flowElement instanceof Splice) {
                    scope.setOrdinal(incoming.getOrdinal());
                } else {
                    scope.setOrdinal(outgoing.getOrdinal());
                }
                scope.setNonBlocking(isNonBlocking);
                scope.addPriorNames(incoming, outgoing);
                boolean success = elementGraph.addEdge(source, target, scope);
                if (success) continue;
                throw new IllegalStateException("during graph contraction, unable to add new edge between: " + source + " and " + target);
            }
        }
        elementGraph.removeVertex(flowElement);
    }

    public static boolean printElementGraph(String filename, ElementGraph graph, PlatformInfo platformInfo) {
        try {
            File parentFile = new File(filename).getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, ElementGraphs.directed(graph), new IntegerNameProvider(), new FlowElementVertexNameProvider(graph, platformInfo), new ScopeEdgeNameProvider(), new VertexAttributeProvider(), new EdgeAttributeProvider());
            ((Writer)writer).close();
            return true;
        }
        catch (IOException | NullPointerException exception) {
            LOG.error("failed printing graph to: {}, with exception: {}", (Object)filename, (Object)exception);
            return false;
        }
    }

    public static boolean printProcessGraph(String filename, ElementGraph graph, ProcessGraph<? extends ProcessModel> processGraph) {
        try {
            File parentFile = new File(filename).getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileWriter writer = new FileWriter(filename);
            DOTProcessGraphWriter graphWriter = new DOTProcessGraphWriter(new IntegerNameProvider<Pair<ElementGraph, FlowElement>>(), new FlowElementVertexNameProvider(graph, null), new ScopeEdgeNameProvider(), new VertexAttributeProvider(), new EdgeAttributeProvider(), new ProcessGraphNameProvider(), new ProcessGraphLabelProvider());
            graphWriter.writeGraph(writer, graph, processGraph);
            ((Writer)writer).close();
            return true;
        }
        catch (IOException exception) {
            LOG.error("failed printing graph to: {}, with exception: {}", (Object)filename, (Object)exception);
            return false;
        }
    }

    public static void insertFlowElementAfter(ElementGraph elementGraph, FlowElement previousElement, FlowElement flowElement) {
        HashSet<Scope> outgoing = new HashSet<Scope>(elementGraph.outgoingEdgesOf(previousElement));
        elementGraph.addVertex(flowElement);
        String name = previousElement.toString();
        if (previousElement instanceof Pipe) {
            name = ((Pipe)previousElement).getName();
        }
        elementGraph.addEdge(previousElement, flowElement, new Scope(name));
        for (Scope scope : outgoing) {
            FlowElement target = elementGraph.getEdgeTarget(scope);
            Scope foundScope = elementGraph.removeEdge(previousElement, target);
            if (foundScope != scope) {
                throw new IllegalStateException("did not remove proper scope");
            }
            elementGraph.addEdge(flowElement, target, scope);
        }
    }

    public static void insertFlowElementBefore(ElementGraph graph, FlowElement nextElement, FlowElement flowElement) {
        HashSet<Scope> incoming = new HashSet<Scope>(graph.incomingEdgesOf(nextElement));
        graph.addVertex(flowElement);
        String name = nextElement.toString();
        if (nextElement instanceof Pipe) {
            name = ((Pipe)nextElement).getName();
        }
        graph.addEdge(flowElement, nextElement, new Scope(name));
        for (Scope scope : incoming) {
            FlowElement target = graph.getEdgeSource(scope);
            Scope foundScope = graph.removeEdge(target, nextElement);
            if (foundScope != scope) {
                throw new IllegalStateException("did not remove proper scope");
            }
            graph.addEdge(target, flowElement, scope);
        }
    }

    public static void insertFlowElementBetweenEdge(ElementGraph elementGraph, Scope previousEdge, FlowElement newElement) {
        FlowElement previousElement = elementGraph.getEdgeSource(previousEdge);
        FlowElement nextElement = elementGraph.getEdgeTarget(previousEdge);
        elementGraph.addVertex(newElement);
        elementGraph.addEdge(previousElement, newElement, new Scope(previousEdge));
        Scope scope = new Scope(previousEdge);
        scope.setOrdinal(previousEdge.getOrdinal());
        if (nextElement instanceof Splice && ((Splice)nextElement).isJoin() && previousEdge.getOrdinal() != 0) {
            scope.setNonBlocking(false);
        }
        elementGraph.addEdge(newElement, nextElement, scope);
        elementGraph.removeEdge(previousElement, nextElement);
    }

    public static <F extends FlowElement> Map<String, F> asSourceMap(ElementGraph elementGraph, Set<F> elements) {
        HashMap<String, FlowElement> map = new HashMap<String, FlowElement>();
        for (FlowElement element : elements) {
            for (Scope scope : elementGraph.outgoingEdgesOf(element)) {
                map.put(scope.getName(), element);
            }
        }
        return map;
    }

    public static Set<Tap> findSources(ElementGraph elementGraph) {
        return ElementGraphs.findSources(elementGraph, Tap.class);
    }

    public static <F extends FlowElement> Set<F> findSources(ElementGraph elementGraph, Class<F> type) {
        if (elementGraph == null) {
            return Collections.emptySet();
        }
        if (elementGraph.containsVertex(Extent.head)) {
            return Util.narrowIdentitySet(type, elementGraph.successorListOf(Extent.head));
        }
        ExpressionSubGraphIterator iterator = new ExpressionSubGraphIterator(new ExpressionGraph(SearchOrder.Topological, new FlowElementExpression(ElementCapture.Primary, (Class<? extends FlowElement>)type, TypeExpression.Topo.Head)), elementGraph);
        return Util.narrowIdentitySet(type, ElementGraphs.getAllVertices(iterator));
    }

    public static <F extends FlowElement> Map<String, F> asSinkMap(ElementGraph elementGraph, Set<F> elements) {
        HashMap<String, FlowElement> map = new HashMap<String, FlowElement>();
        for (FlowElement element : elements) {
            for (Scope scope : elementGraph.incomingEdgesOf(element)) {
                map.put(scope.getName(), element);
            }
        }
        return map;
    }

    public static <F extends FlowElement> Set<F> findSinks(ElementGraph elementGraph, Class<F> type) {
        if (elementGraph == null) {
            return Collections.emptySet();
        }
        if (elementGraph.containsVertex(Extent.tail)) {
            return Util.narrowIdentitySet(type, elementGraph.predecessorListOf(Extent.tail));
        }
        ExpressionSubGraphIterator iterator = new ExpressionSubGraphIterator(new ExpressionGraph(SearchOrder.ReverseTopological, new FlowElementExpression(ElementCapture.Primary, (Class<? extends FlowElement>)type, TypeExpression.Topo.Tail)), elementGraph);
        return Util.narrowIdentitySet(type, ElementGraphs.getAllVertices(iterator));
    }

    public static Set<Tap> findSinks(ElementGraph elementGraph) {
        return ElementGraphs.findSinks(elementGraph, Tap.class);
    }

    public static Set<Group> findAllGroups(ElementGraph elementGraph) {
        ExpressionSubGraphIterator iterator = new ExpressionSubGraphIterator(new ExpressionGraph(SearchOrder.Topological, new FlowElementExpression(ElementCapture.Primary, (Class<? extends FlowElement>)Group.class)), elementGraph);
        return Util.narrowIdentitySet(Group.class, ElementGraphs.getAllVertices(iterator));
    }

    private static Set<FlowElement> getAllVertices(SubGraphIterator iterator) {
        Set<FlowElement> vertices = Util.createIdentitySet();
        while (iterator.hasNext()) {
            vertices.addAll(((ElementGraph)iterator.next()).vertexSet());
        }
        return vertices;
    }

    public static Set<Scope> getAllMultiEdgesBetween(Collection<Scope> edgeList, ElementGraph current) {
        HashSet<Scope> allEdgesBetween = new HashSet<Scope>();
        for (Scope scope : edgeList) {
            FlowElement edgeSource = current.getEdgeSource(scope);
            FlowElement edgeTarget = current.getEdgeTarget(scope);
            allEdgesBetween.addAll(current.getAllEdges(edgeSource, edgeTarget));
        }
        return allEdgesBetween;
    }

    public static void replaceElementWith(ElementGraph elementGraph, FlowElement replace, FlowElement replaceWith) {
        HashSet<Scope> incoming = new HashSet<Scope>(elementGraph.incomingEdgesOf(replace));
        HashSet<Scope> outgoing = new HashSet<Scope>(elementGraph.outgoingEdgesOf(replace));
        if (!elementGraph.containsVertex(replaceWith)) {
            elementGraph.addVertex(replaceWith);
        }
        for (Scope scope : incoming) {
            FlowElement source = elementGraph.getEdgeSource(scope);
            elementGraph.removeEdge(source, replace);
            if (source == replaceWith) continue;
            elementGraph.addEdge(source, replaceWith, scope);
        }
        for (Scope scope : outgoing) {
            FlowElement target = elementGraph.getEdgeTarget(scope);
            elementGraph.removeEdge(replace, target);
            if (target == replaceWith) continue;
            elementGraph.addEdge(replaceWith, target, scope);
        }
        elementGraph.removeVertex(replace);
    }

    public static Pipe findFirstPipeNamed(ElementGraph elementGraph, String name) {
        Iterator<FlowElement> iterator = ElementGraphs.getTopologicalIterator(elementGraph);
        return ElementGraphs.find(name, iterator);
    }

    public static Pipe findLastPipeNamed(ElementGraph elementGraph, String name) {
        Iterator<FlowElement> iterator = ElementGraphs.getReverseTopologicalIterator(elementGraph);
        return ElementGraphs.find(name, iterator);
    }

    private static Pipe find(String name, Iterator<FlowElement> iterator) {
        while (iterator.hasNext()) {
            FlowElement flowElement = iterator.next();
            if (!(flowElement instanceof Pipe) || !((Pipe)flowElement).getName().equals(name)) continue;
            return (Pipe)flowElement;
        }
        return null;
    }

    public static boolean removeBranchContaining(ElementGraph elementGraph, FlowElement flowElement) {
        LinkedHashSet<FlowElement> branch = new LinkedHashSet<FlowElement>();
        ElementGraphs.walkUp(branch, elementGraph, flowElement);
        ElementGraphs.walkDown(branch, elementGraph, flowElement);
        if (branch.isEmpty()) {
            return false;
        }
        for (FlowElement element : branch) {
            elementGraph.removeVertex(element);
        }
        return true;
    }

    public static boolean removeBranchBetween(ElementGraph elementGraph, FlowElement first, FlowElement second, boolean inclusive) {
        LinkedHashSet<FlowElement> branch = new LinkedHashSet<FlowElement>(Arrays.asList(first, second));
        ElementGraphs.walkDown(branch, elementGraph, first);
        if (!inclusive) {
            branch.remove(first);
            branch.remove(second);
        }
        if (branch.isEmpty()) {
            return false;
        }
        for (FlowElement element : branch) {
            elementGraph.removeVertex(element);
        }
        return true;
    }

    private static void walkDown(Set<FlowElement> branch, ElementGraph elementGraph, FlowElement flowElement) {
        FlowElement current = flowElement;
        while (branch.contains(current) || elementGraph.inDegreeOf(current) == 1 && elementGraph.outDegreeOf(current) == 1) {
            branch.add(current);
            FlowElement element = elementGraph.getEdgeTarget(Util.getFirst(elementGraph.outgoingEdgesOf(current)));
            if (element instanceof Extent || branch.contains(element)) break;
            current = element;
        }
    }

    private static void walkUp(Set<FlowElement> branch, ElementGraph elementGraph, FlowElement flowElement) {
        FlowElement current = flowElement;
        while (elementGraph.inDegreeOf(current) == 1 && elementGraph.outDegreeOf(current) == 1) {
            branch.add(current);
            FlowElement element = elementGraph.getEdgeSource(Util.getFirst(elementGraph.incomingEdgesOf(current)));
            if (element instanceof Extent || branch.contains(element)) break;
            current = element;
        }
    }

    public static int shortestDistance(ElementGraph graph, FlowElement lhs, FlowElement rhs) {
        return DijkstraShortestPath.findPathBetween(ElementGraphs.directed(graph), (Object)lhs, (Object)rhs).getLength();
    }

    static void injectIdentityMap(AbstractGraph graph) {
        Object specifics = Util.returnInstanceFieldIfExistsSafe(graph, "specifics");
        if (specifics == null) {
            LOG.warn("unable to get jgrapht Specifics for identity map injection, may be using an incompatible jgrapht version");
            return;
        }
        boolean success = Util.setInstanceFieldIfExistsSafe(specifics, "vertexMapDirected", new IdentityHashMap());
        if (!success) {
            LOG.warn("unable to set IdentityHashMap on jgrapht Specifics, may be using an incompatible jgrapht version");
        }
    }

    private static class ProcessGraphLabelProvider
    implements VertexNameProvider<ProcessModel> {
        private ProcessGraphLabelProvider() {
        }

        @Override
        public String getVertexName(ProcessModel processModel) {
            return "ordinal: " + processModel.getOrdinal() + "\\nid: " + processModel.getID() + "\\nhash: " + ElementGraphs.canonicalHash(processModel.getElementGraph());
        }
    }

    private static class ProcessGraphNameProvider
    implements VertexNameProvider<ProcessModel> {
        private ProcessGraphNameProvider() {
        }

        @Override
        public String getVertexName(ProcessModel processModel) {
            return "" + processModel.getOrdinal();
        }
    }

    private static class EdgeAttributeProvider
    implements ComponentAttributeProvider<Scope> {
        static Map<String, String> attributes = new HashMap<String, String>(){
            {
                this.put("style", "dotted");
                this.put("arrowhead", "dot");
            }
        };

        private EdgeAttributeProvider() {
        }

        @Override
        public Map<String, String> getComponentAttributes(Scope scope) {
            if (scope.isNonBlocking()) {
                return null;
            }
            return attributes;
        }
    }

    private static class VertexAttributeProvider
    implements ComponentAttributeProvider<FlowElement> {
        static Map<String, String> defaultNode = new HashMap<String, String>(){
            {
                this.put("shape", "Mrecord");
            }
        };

        @Override
        public Map<String, String> getComponentAttributes(FlowElement object) {
            return defaultNode;
        }
    }

    private static class ScopeEdgeNameProvider
    implements EdgeNameProvider<Scope> {
        private ScopeEdgeNameProvider() {
        }

        @Override
        public String getEdgeName(Scope object) {
            return object.toString().replaceAll("\"", "'").replaceAll("\n", "\\\\n");
        }
    }

    private static class FlowElementVertexNameProvider
    implements VertexNameProvider<FlowElement> {
        private final ElementGraph elementGraph;
        private final PlatformInfo platformInfo;

        public FlowElementVertexNameProvider(ElementGraph elementGraph, PlatformInfo platformInfo) {
            this.elementGraph = elementGraph;
            this.platformInfo = platformInfo;
        }

        @Override
        public String getVertexName(FlowElement object) {
            String label;
            if (object instanceof Extent) {
                String result = object.toString().replaceAll("\"", "'");
                if (object == Extent.tail) {
                    return result;
                }
                result = result + "|hash: " + ElementGraphs.canonicalHash(this.elementGraph);
                String versionString = Version.getRelease();
                if (this.platformInfo != null) {
                    versionString = (versionString == null ? "" : versionString + "|") + this.platformInfo;
                }
                return "{" + (versionString == null ? result : result + "|" + versionString) + "}";
            }
            Iterator<Scope> iterator = this.elementGraph.outgoingEdgesOf(object).iterator();
            if (!(object instanceof Pipe) || !iterator.hasNext()) {
                label = object.toString().replaceAll("\"", "'").replaceAll("(\\)|\\])(\\[)", "$1|$2").replaceAll("(^[^(\\[]+)(\\(|\\[)", "$1|$2");
            } else {
                Scope scope = iterator.next();
                label = ((Pipe)object).print(scope).replaceAll("\"", "'").replaceAll("(\\)|\\])(\\[)", "$1|$2").replaceAll("(^[^(\\[]+)(\\(|\\[)", "$1|$2");
            }
            label = label.replaceFirst("([^|]+)\\|(.*)", "$1 : " + this.getID(object) + "|$2");
            label = "{" + label.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("<", "\\\\<").replaceAll(">", "\\\\>") + "}";
            if (!(this.elementGraph instanceof AnnotatedGraph) || !((AnnotatedGraph)((Object)this.elementGraph)).hasAnnotations()) {
                return label;
            }
            Set annotations = ((AnnotatedGraph)((Object)this.elementGraph)).getAnnotations().getKeysFor(object);
            if (!annotations.isEmpty()) {
                label = label + "|{" + Util.join(annotations, "|") + "}";
            }
            return label;
        }

        protected String getID(FlowElement object) {
            return FlowElements.id(object).substring(0, 5);
        }
    }

    private static class IdentityMultiGraphGraph<V, E>
    extends DirectedMultigraph<V, E> {
        public IdentityMultiGraphGraph(Class<? extends E> edgeClass) {
            super(edgeClass);
        }

        protected DirectedSpecifics createSpecifics(boolean directed) {
            return new DirectedSpecifics((AbstractBaseGraph)this, new IdentityHashMap());
        }
    }

    private static class IdentityDirectedGraph<V, E>
    extends SimpleDirectedGraph<V, E> {
        public IdentityDirectedGraph(Class<? extends E> edgeClass) {
            super(edgeClass);
        }

        protected DirectedSpecifics createSpecifics(boolean directed) {
            return new DirectedSpecifics((AbstractBaseGraph)this, new IdentityHashMap());
        }
    }
}

