/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.graph;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.ElementMultiGraph;
import cascading.flow.planner.graph.Extent;
import cascading.util.EnumMultiMap;
import java.util.Set;

public class BoundedElementMultiGraph
extends ElementMultiGraph {
    public BoundedElementMultiGraph(ElementGraph parentElementGraph, ElementGraph subElementGraph, EnumMultiMap annotations) {
        this.graph = new ElementMultiGraph.DirectedMultiGraph(this, ElementGraphs.directed(subElementGraph));
        this.addParentAnnotations(parentElementGraph);
        this.getAnnotations().addAll(annotations);
        this.bindHeadAndTail(parentElementGraph, subElementGraph);
    }

    @Override
    protected void addParentAnnotations(ElementGraph parentElementGraph) {
        if (!(parentElementGraph instanceof AnnotatedGraph) || !((AnnotatedGraph)((Object)parentElementGraph)).hasAnnotations()) {
            return;
        }
        Set<FlowElement> vertexSet = this.vertexSet();
        EnumMultiMap<FlowElement> parentAnnotations = ((AnnotatedGraph)((Object)parentElementGraph)).getAnnotations();
        Set allKeys = parentAnnotations.getKeys();
        for (Enum annotation : allKeys) {
            Set flowElements = (Set)parentAnnotations.getValues(annotation);
            for (FlowElement flowElement : flowElements) {
                if (!vertexSet.contains(flowElement)) continue;
                this.getAnnotations().addAll(annotation, flowElements);
            }
        }
    }

    protected void bindHeadAndTail(ElementGraph parentElementGraph, ElementGraph subElementGraph) {
        Set<Scope> scopes;
        Set<FlowElement> sources = ElementGraphs.findSources(subElementGraph, FlowElement.class);
        Set<FlowElement> sinks = ElementGraphs.findSinks(subElementGraph, FlowElement.class);
        this.addVertex(Extent.head);
        this.addVertex(Extent.tail);
        Set<FlowElement> parentElements = parentElementGraph.vertexSet();
        for (FlowElement source : sources) {
            if (!parentElements.contains(source)) continue;
            scopes = parentElementGraph.incomingEdgesOf(source);
            for (Scope scope : scopes) {
                this.addEdge(Extent.head, source, scope);
            }
        }
        for (FlowElement sink : sinks) {
            if (!parentElements.contains(sink)) continue;
            scopes = parentElementGraph.outgoingEdgesOf(sink);
            for (Scope scope : scopes) {
                this.addEdge(sink, Extent.tail, scope);
            }
        }
    }
}

