/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner.graph;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.Extent;
import cascading.util.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedGraph;

public abstract class BaseElementGraph
implements ElementGraph,
Serializable {
    public static final ElementGraph NULL = new BaseElementGraph((DirectedGraph)new SimpleDirectedGraph(Scope.class)){

        @Override
        public ElementGraph copyElementGraph() {
            return null;
        }
    };
    protected Graph<FlowElement, Scope> graph;

    public BaseElementGraph() {
    }

    public BaseElementGraph(DirectedGraph<FlowElement, Scope> graph) {
        this.graph = graph;
    }

    protected void copyFrom(ElementGraph elementGraph) {
        Graphs.addAllVertices(this.graph, elementGraph.vertexSet());
        Graphs.addAllEdges(this.graph, ElementGraphs.directed(elementGraph), elementGraph.edgeSet());
    }

    @Override
    public boolean containsEdge(FlowElement sourceVertex, FlowElement targetVertex) {
        return this.graph.containsEdge((Object)sourceVertex, (Object)targetVertex);
    }

    @Override
    public boolean removeAllEdges(Collection<? extends Scope> edges) {
        return this.graph.removeAllEdges(edges);
    }

    @Override
    public Set<Scope> removeAllEdges(FlowElement sourceVertex, FlowElement targetVertex) {
        return this.graph.removeAllEdges((Object)sourceVertex, (Object)targetVertex);
    }

    @Override
    public boolean removeAllVertices(Collection<? extends FlowElement> vertices) {
        return this.graph.removeAllVertices(vertices);
    }

    @Override
    public Set<Scope> getAllEdges(FlowElement sourceVertex, FlowElement targetVertex) {
        return this.graph.getAllEdges((Object)sourceVertex, (Object)targetVertex);
    }

    @Override
    public Scope getEdge(FlowElement sourceVertex, FlowElement targetVertex) {
        return (Scope)this.graph.getEdge((Object)sourceVertex, (Object)targetVertex);
    }

    @Override
    public Scope addEdge(FlowElement sourceVertex, FlowElement targetVertex) {
        if (!this.allowMultipleExtentEdges() && (sourceVertex == Extent.head || targetVertex == Extent.tail) && this.graph.containsEdge((Object)sourceVertex, (Object)targetVertex)) {
            return (Scope)this.graph.getEdge((Object)sourceVertex, (Object)targetVertex);
        }
        return (Scope)this.graph.addEdge((Object)sourceVertex, (Object)targetVertex);
    }

    @Override
    public boolean addEdge(FlowElement sourceVertex, FlowElement targetVertex, Scope scope) {
        if (!this.allowMultipleExtentEdges() && (sourceVertex == Extent.head || targetVertex == Extent.tail) && this.graph.containsEdge((Object)sourceVertex, (Object)targetVertex)) {
            return true;
        }
        return this.graph.addEdge((Object)sourceVertex, (Object)targetVertex, (Object)scope);
    }

    protected boolean allowMultipleExtentEdges() {
        return true;
    }

    @Override
    public boolean addHeadVertex(FlowElement flowElement) {
        if (!this.graph.containsVertex((Object)Extent.head)) {
            this.graph.addVertex((Object)Extent.head);
        }
        if (flowElement == Extent.head) {
            return false;
        }
        boolean result = true;
        if (!this.graph.containsVertex((Object)flowElement)) {
            result = this.graph.addVertex((Object)flowElement);
        }
        return result && this.graph.addEdge((Object)Extent.head, (Object)flowElement) != null;
    }

    @Override
    public boolean addTailVertex(FlowElement flowElement) {
        if (!this.graph.containsVertex((Object)Extent.tail)) {
            this.graph.addVertex((Object)Extent.tail);
        }
        if (flowElement == Extent.tail) {
            return false;
        }
        boolean result = true;
        if (!this.graph.containsVertex((Object)flowElement)) {
            result = this.graph.addVertex((Object)flowElement);
        }
        return result && this.graph.addEdge((Object)flowElement, (Object)Extent.tail) != null;
    }

    @Override
    public boolean addVertex(FlowElement flowElement) {
        return this.graph.addVertex((Object)flowElement);
    }

    @Override
    public FlowElement getEdgeSource(Scope scope) {
        return (FlowElement)this.graph.getEdgeSource((Object)scope);
    }

    @Override
    public FlowElement getEdgeTarget(Scope scope) {
        return (FlowElement)this.graph.getEdgeTarget((Object)scope);
    }

    @Override
    public boolean containsEdge(Scope scope) {
        return this.graph.containsEdge((Object)scope);
    }

    @Override
    public boolean containsVertex(FlowElement flowElement) {
        return this.graph.containsVertex((Object)flowElement);
    }

    @Override
    public Set<Scope> edgeSet() {
        return this.graph.edgeSet();
    }

    @Override
    public Set<Scope> edgesOf(FlowElement vertex) {
        return this.graph.edgesOf((Object)vertex);
    }

    @Override
    public int inDegreeOf(FlowElement vertex) {
        return this.graph.inDegreeOf((Object)vertex);
    }

    @Override
    public Set<Scope> incomingEdgesOf(FlowElement vertex) {
        return this.graph.incomingEdgesOf((Object)vertex);
    }

    @Override
    public int outDegreeOf(FlowElement vertex) {
        return this.graph.outDegreeOf((Object)vertex);
    }

    @Override
    public Set<Scope> outgoingEdgesOf(FlowElement vertex) {
        return this.graph.outgoingEdgesOf((Object)vertex);
    }

    @Override
    public Scope removeEdge(FlowElement sourceVertex, FlowElement targetVertex) {
        return (Scope)this.graph.removeEdge((Object)sourceVertex, (Object)targetVertex);
    }

    @Override
    public boolean removeEdge(Scope scope) {
        return this.graph.removeEdge((Object)scope);
    }

    @Override
    public boolean removeVertex(FlowElement flowElement) {
        return this.graph.removeVertex((Object)flowElement);
    }

    @Override
    public Set<FlowElement> vertexSet() {
        return this.graph.vertexSet();
    }

    @Override
    public Set<FlowElement> vertexSetCopy() {
        Set<FlowElement> result = Collections.newSetFromMap(new IdentityHashMap());
        result.addAll(this.vertexSet());
        return result;
    }

    @Override
    public List<FlowElement> predecessorListOf(FlowElement flowElement) {
        return Graphs.predecessorListOf(this.graph, (Object)flowElement);
    }

    @Override
    public List<FlowElement> successorListOf(FlowElement flowElement) {
        return Graphs.successorListOf(this.graph, (Object)flowElement);
    }

    @Override
    public ElementGraph bindExtents() {
        Set<FlowElement> vertexSet = this.vertexSetCopy();
        for (FlowElement flowElement : vertexSet) {
            if (this.inDegreeOf(flowElement) == 0) {
                this.addHeadVertex(flowElement);
            }
            if (this.outDegreeOf(flowElement) != 0) continue;
            this.addTailVertex(flowElement);
        }
        if (!this.vertexSet().contains(Extent.head)) {
            throw new IllegalStateException("did not bind head vertex to graph");
        }
        if (!this.vertexSet().contains(Extent.tail)) {
            throw new IllegalStateException("did not bind tail vertex to graph");
        }
        return this;
    }

    @Override
    public void writeDOT(String filename) {
        boolean success = ElementGraphs.printElementGraph(filename, this, null);
        if (success) {
            Util.writePDF(filename);
        }
    }

    public boolean equals(Object object) {
        return ElementGraphs.equals(this, (ElementGraph)object);
    }

    public int hashCode() {
        int result = this.graph.hashCode();
        result = 31 * result;
        return result;
    }
}

