/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.tuple.Fields;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class Scope
implements Serializable {
    private String name;
    private LinkedList<String> priorNames = new LinkedList();
    private Integer ordinal = 0;
    private boolean isNonBlocking = true;
    private Kind kind;
    private Fields incomingPassThroughFields;
    private Fields remainderPassThroughFields;
    private Fields operationArgumentFields;
    private Fields operationDeclaredFields;
    private Map<String, Fields> keySelectors;
    private Map<String, Fields> sortingSelectors;
    private Fields outGroupingSelector;
    private Fields outGroupingFields;
    private Fields outValuesSelector;
    private Fields outValuesFields;

    public Scope() {
    }

    public Scope(Scope scope) {
        this.name = scope.getName();
        this.copyFields(scope);
    }

    public Scope(Fields outFields) {
        this.kind = Kind.TAP;
        if (outFields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        this.outGroupingFields = outFields;
        this.outValuesFields = outFields;
    }

    public Scope(String name, Kind kind, Fields incomingPassThroughFields, Fields remainderPassThroughFields, Fields operationArgumentFields, Fields operationDeclaredFields, Fields outGroupingFields, Fields outValuesFields) {
        this.name = name;
        this.kind = kind;
        this.incomingPassThroughFields = incomingPassThroughFields;
        this.remainderPassThroughFields = remainderPassThroughFields;
        this.operationArgumentFields = operationArgumentFields;
        this.operationDeclaredFields = operationDeclaredFields;
        if (outGroupingFields == null) {
            throw new IllegalArgumentException("grouping may not be null");
        }
        if (outValuesFields == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (kind != Kind.EACH && kind != Kind.EVERY) {
            throw new IllegalArgumentException("may not use the constructor for kind: " + (Object)((Object)kind));
        }
        this.outGroupingSelector = outGroupingFields;
        this.outGroupingFields = Fields.asDeclaration(outGroupingFields);
        this.outValuesSelector = outValuesFields;
        this.outValuesFields = Fields.asDeclaration(outValuesFields);
    }

    public Scope(String name, Fields operationDeclaredFields, Fields outGroupingFields, Map<String, Fields> keySelectors, Map<String, Fields> sortingSelectors, Fields outValuesFields, Kind kind) {
        this.name = name;
        this.kind = kind;
        if (keySelectors == null) {
            throw new IllegalArgumentException("grouping may not be null");
        }
        if (outValuesFields == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        this.operationDeclaredFields = operationDeclaredFields;
        this.outGroupingFields = Fields.asDeclaration(outGroupingFields);
        this.keySelectors = keySelectors;
        this.sortingSelectors = sortingSelectors;
        this.outValuesFields = Fields.asDeclaration(outValuesFields);
    }

    public Scope(String name) {
        this.name = name;
    }

    public void addPriorNames(Scope incoming, Scope outgoing) {
        this.priorNames.addAll(0, outgoing.priorNames);
        this.priorNames.addFirst(incoming.getName());
        this.priorNames.addAll(0, incoming.priorNames);
    }

    public String getPriorName() {
        if (this.priorNames.isEmpty()) {
            return this.getName();
        }
        return this.priorNames.getFirst();
    }

    public Integer getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public void setNonBlocking(boolean isNonBlocking) {
        this.isNonBlocking = isNonBlocking;
    }

    public boolean isNonBlocking() {
        return this.isNonBlocking;
    }

    public boolean isSplice() {
        return this.isGroupBy() || this.isCoGroup() || this.isMerge() || this.isHashJoin();
    }

    public boolean isGroup() {
        return this.kind == Kind.GROUPBY || this.kind == Kind.COGROUP;
    }

    public boolean isGroupBy() {
        return this.kind == Kind.GROUPBY;
    }

    public boolean isCoGroup() {
        return this.kind == Kind.COGROUP;
    }

    public boolean isMerge() {
        return this.kind == Kind.MERGE;
    }

    public boolean isHashJoin() {
        return this.kind == Kind.HASHJOIN;
    }

    public boolean isEach() {
        return this.kind == Kind.EACH;
    }

    public boolean isEvery() {
        return this.kind == Kind.EVERY;
    }

    public boolean isTap() {
        return this.kind == Kind.TAP;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Fields getRemainderPassThroughFields() {
        return this.remainderPassThroughFields;
    }

    public Fields getArgumentsSelector() {
        return this.operationArgumentFields;
    }

    public Fields getArgumentsDeclarator() {
        return Fields.asDeclaration(this.operationArgumentFields);
    }

    public Fields getOperationDeclaredFields() {
        return this.operationDeclaredFields;
    }

    public Map<String, Fields> getKeySelectors() {
        return this.keySelectors;
    }

    public Map<String, Fields> getSortingSelectors() {
        return this.sortingSelectors;
    }

    public Fields getOutGroupingSelector() {
        return this.outGroupingSelector;
    }

    public Fields getIncomingTapFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingFunctionArgumentFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingFunctionPassThroughFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingAggregatorArgumentFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingAggregatorPassThroughFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutGroupingFields();
    }

    public Fields getIncomingBufferArgumentFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingBufferPassThroughFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingSpliceFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getOutGroupingFields() {
        if (!this.isSplice()) {
            return this.outGroupingFields;
        }
        Fields first = this.keySelectors.values().iterator().next();
        if (this.keySelectors.size() == 1 || this.isGroupBy()) {
            return first;
        }
        if (this.outGroupingFields != null) {
            return this.outGroupingFields;
        }
        HashSet<Fields> set = new HashSet<Fields>(this.keySelectors.values());
        if (set.size() == 1) {
            return first;
        }
        return Fields.size(first.size());
    }

    public Fields getOutGroupingValueFields() {
        return this.getOutValuesFields().subtract(this.getOutGroupingFields());
    }

    public Fields getOutValuesSelector() {
        return this.outValuesSelector;
    }

    public Fields getOutValuesFields() {
        return this.outValuesFields;
    }

    public void copyFields(Scope scope) {
        this.kind = scope.kind;
        this.incomingPassThroughFields = scope.incomingPassThroughFields;
        this.remainderPassThroughFields = scope.remainderPassThroughFields;
        this.operationArgumentFields = scope.operationArgumentFields;
        this.operationDeclaredFields = scope.operationDeclaredFields;
        this.keySelectors = scope.keySelectors;
        this.sortingSelectors = scope.sortingSelectors;
        this.outGroupingSelector = scope.outGroupingSelector;
        this.outGroupingFields = scope.outGroupingFields;
        this.outValuesSelector = scope.outValuesSelector;
        this.outValuesFields = scope.outValuesFields;
    }

    public String printSimple() {
        StringBuilder buffer = new StringBuilder();
        if (this.name != null) {
            buffer.append("[").append(this.name).append("]");
        }
        buffer.append("{id=").append(System.identityHashCode(this));
        if (this.ordinal != null) {
            buffer.append(",ordinal=").append(this.ordinal);
        }
        if (this.kind != null) {
            buffer.append(",kind=").append((Object)this.kind);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toString() {
        return this.print();
    }

    public String print() {
        StringBuilder buffer = new StringBuilder();
        if (this.ordinal != null) {
            buffer.append("[").append(this.ordinal).append("]");
        }
        if (this.getOutValuesFields() == null) {
            return buffer.toString();
        }
        buffer.append("\n");
        if (this.keySelectors != null && !this.keySelectors.isEmpty()) {
            for (String name : this.keySelectors.keySet()) {
                if (buffer.length() != 0 && buffer.charAt(buffer.length() - 1) != '\n') {
                    buffer.append(" | ");
                }
                buffer.append(name).append(this.keySelectors.get(name).printVerbose());
            }
            buffer.append("\n");
        }
        if (this.outGroupingFields != null) {
            buffer.append(this.getOutGroupingFields().printVerbose()).append("\n");
        }
        buffer.append(this.getOutValuesFields().printVerbose());
        return buffer.toString();
    }

    public static enum Kind {
        TAP,
        EACH,
        EVERY,
        GROUPBY,
        COGROUP,
        HASHJOIN,
        MERGE;

    }
}

