/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.finder.GraphFinderException;
import cascading.flow.planner.rule.PlanPhase;
import cascading.flow.planner.rule.Rule;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.util.TraceUtil;

public class PlannerException
extends FlowException {
    ElementGraph elementGraph;

    public PlannerException() {
    }

    public PlannerException(FlowElement flowElement, String message) {
        super(TraceUtil.formatTrace(flowElement, message));
    }

    public PlannerException(FlowElement flowElement, String message, Throwable throwable) {
        super(TraceUtil.formatTrace(flowElement, message), throwable);
    }

    public PlannerException(FlowElement flowElement, String message, Throwable throwable, ElementGraph elementGraph) {
        super(TraceUtil.formatTrace(flowElement, message), throwable);
        this.elementGraph = elementGraph;
    }

    public PlannerException(String string) {
        super(string);
    }

    public PlannerException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public PlannerException(Throwable throwable) {
        super(throwable);
    }

    public PlannerException(String string, ElementGraph elementGraph) {
        super(string);
        this.elementGraph = elementGraph;
    }

    public PlannerException(String string, Throwable throwable, ElementGraph elementGraph) {
        super(string, throwable);
        this.elementGraph = elementGraph;
    }

    public PlannerException(Rule rule, Exception exception) {
        super("failed on rule: " + rule.getRuleName(), exception);
    }

    public PlannerException(PlanPhase phase, Rule rule, Throwable throwable) {
        super("phase: " + (Object)((Object)phase) + ", failed on rule: " + rule.getRuleName(), throwable);
    }

    public PlannerException(PlanPhase phase, Rule rule, ElementGraph elementGraph, Throwable throwable) {
        super("phase: " + (Object)((Object)phase) + ", failed on rule: " + rule.getRuleName() + (elementGraph != null ? ", see attached source element-graph" : ""), throwable);
        this.elementGraph = elementGraph;
    }

    public PlannerException(RuleRegistry registry, PlanPhase phase, Rule rule, Throwable throwable) {
        super("registry: " + registry.getName() + ", phase: " + (Object)((Object)phase) + ", failed on rule: " + rule.getRuleName(), throwable);
    }

    public PlannerException(RuleRegistry registry, PlanPhase phase, Rule rule, ElementGraph elementGraph, Throwable throwable) {
        super("registry: " + registry.getName() + ", phase: " + (Object)((Object)phase) + ", failed on rule: " + rule.getRuleName() + (elementGraph != null ? ", see attached source element-graph" : ""), throwable);
        this.elementGraph = elementGraph;
    }

    public ElementGraph getElementGraph() {
        return this.elementGraph;
    }

    public void writeDOT(String filename) {
        if (this.elementGraph == null) {
            return;
        }
        this.elementGraph.writeDOT(filename);
    }

    public void writeCauseDOT(String filename) {
        if (this.getCause() instanceof GraphFinderException) {
            ((GraphFinderException)this.getCause()).writeDOT(filename);
        }
    }
}

