/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.planner.FlowPlanner;
import cascading.flow.planner.iso.transformer.ElementFactory;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.operation.PlannerLevel;
import cascading.property.PropertyUtil;
import cascading.util.ProcessLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PlannerContext {
    public static final PlannerContext NULL = new PlannerContext();
    RuleRegistry ruleRegistry;
    FlowPlanner flowPlanner;
    FlowDef flowDef;
    Flow flow;
    boolean isTransformTracingEnabled = false;
    private Map properties;

    public PlannerContext() {
        this.properties = new Properties();
    }

    public PlannerContext(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }

    public PlannerContext(RuleRegistry ruleRegistry, FlowPlanner flowPlanner, FlowDef flowDef, Flow flow, boolean isTransformTracingEnabled) {
        this.ruleRegistry = ruleRegistry;
        this.flowPlanner = flowPlanner;
        this.flowDef = flowDef;
        this.flow = flow;
        this.isTransformTracingEnabled = isTransformTracingEnabled;
        this.properties = flowPlanner != null ? flowPlanner.getDefaultProperties() : new Properties();
    }

    public String getStringProperty(String property) {
        return PropertyUtil.getStringProperty(System.getProperties(), this.properties, property);
    }

    public int getIntProperty(String property, int defaultValue) {
        return PropertyUtil.getIntProperty(System.getProperties(), this.properties, property, defaultValue);
    }

    public RuleRegistry getRuleRegistry() {
        return this.ruleRegistry;
    }

    public FlowPlanner getFlowPlanner() {
        return this.flowPlanner;
    }

    public FlowDef getFlowDef() {
        return this.flowDef;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public ProcessLogger getLogger() {
        Flow flow = this.getFlow();
        if (flow == null) {
            return ProcessLogger.NULL;
        }
        return (ProcessLogger)((Object)flow);
    }

    public boolean isTransformTracingEnabled() {
        return this.isTransformTracingEnabled;
    }

    public PlannerLevel getPlannerLevelFor(Class<? extends PlannerLevel> plannerLevelClass) {
        HashMap<Class<? extends PlannerLevel>, PlannerLevel> levels = new HashMap<Class<? extends PlannerLevel>, PlannerLevel>();
        this.addLevel(levels, this.flowPlanner.getDebugLevel(this.flowDef));
        this.addLevel(levels, this.flowPlanner.getAssertionLevel(this.flowDef));
        return (PlannerLevel)levels.get(plannerLevelClass);
    }

    private void addLevel(Map<Class<? extends PlannerLevel>, PlannerLevel> levels, PlannerLevel level) {
        if (level != null) {
            levels.put(level.getClass(), level);
        }
    }

    public ElementFactory getElementFactoryFor(String factoryName) {
        return this.ruleRegistry.getElementFactory(factoryName);
    }
}

