/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.AssemblyPlanner;
import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.flow.FlowConnector;
import cascading.flow.FlowDef;
import cascading.flow.FlowElement;
import cascading.flow.Flows;
import cascading.flow.planner.AssemblyPlannerContext;
import cascading.flow.planner.BaseFlowNodeFactory;
import cascading.flow.planner.ElementGraphException;
import cascading.flow.planner.PlannerException;
import cascading.flow.planner.PlannerInfo;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.process.FlowNodeFactory;
import cascading.flow.planner.process.FlowStepFactory;
import cascading.flow.planner.process.FlowStepGraph;
import cascading.flow.planner.rule.ProcessLevel;
import cascading.flow.planner.rule.RuleRegistry;
import cascading.flow.planner.rule.RuleRegistrySet;
import cascading.flow.planner.rule.RuleResult;
import cascading.flow.planner.rule.RuleSetExec;
import cascading.flow.planner.rule.transformer.IntermediatePipeElementFactory;
import cascading.flow.planner.rule.transformer.IntermediateTapElementFactory;
import cascading.flow.planner.rule.util.TraceWriter;
import cascading.operation.AssertionLevel;
import cascading.operation.DebugLevel;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.pipe.Checkpoint;
import cascading.pipe.Each;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.property.ConfigDef;
import cascading.property.PropertyUtil;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.util.TraceUtil;
import cascading.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowPlanner<F extends BaseFlow, Config> {
    public static final String TRACE_PLAN_PATH = "cascading.planner.plan.path";
    public static final String TRACE_PLAN_TRANSFORM_PATH = "cascading.planner.plan.transforms.path";
    public static final String TRACE_STATS_PATH = "cascading.planner.stats.path";
    private static final Logger LOG = LoggerFactory.getLogger(FlowPlanner.class);
    protected Map<Object, Object> defaultProperties;
    protected String checkpointTapRootPath = null;
    protected AssertionLevel defaultAssertionLevel;
    protected DebugLevel defaultDebugLevel;

    static AssertionLevel getAssertionLevel(Map<Object, Object> properties) {
        String assertionLevel = PropertyUtil.getProperty(properties, "cascading.flowconnector.assertionlevel", AssertionLevel.STRICT.name());
        return AssertionLevel.valueOf(assertionLevel);
    }

    static DebugLevel getDebugLevel(Map<Object, Object> properties) {
        String debugLevel = PropertyUtil.getProperty(properties, "cascading.flowconnector.debuglevel", DebugLevel.DEFAULT.name());
        return DebugLevel.valueOf(debugLevel);
    }

    public Map<Object, Object> getDefaultProperties() {
        return this.defaultProperties;
    }

    public abstract Config getDefaultConfig();

    public abstract PlannerInfo getPlannerInfo(String var1);

    public abstract PlatformInfo getPlatformInfo();

    public void initialize(FlowConnector flowConnector, Map<Object, Object> properties) {
        this.defaultProperties = properties;
        this.defaultAssertionLevel = FlowPlanner.getAssertionLevel(properties);
        this.defaultDebugLevel = FlowPlanner.getDebugLevel(properties);
    }

    public F buildFlow(FlowDef flowDef, RuleRegistrySet ruleRegistrySet) {
        FlowElementGraph flowElementGraph = null;
        try {
            flowDef = this.normalizeTaps(flowDef);
            this.verifyAllTaps(flowDef);
            F flow = this.createFlow(flowDef);
            Pipe[] tails = this.resolveTails(flowDef, flow);
            this.verifyAssembly(flowDef, tails);
            flowElementGraph = this.createFlowElementGraph(flowDef, tails);
            TraceWriter traceWriter = new TraceWriter((Flow)flow);
            RuleSetExec ruleSetExec = new RuleSetExec(traceWriter, this, (Flow)flow, ruleRegistrySet, flowDef, flowElementGraph);
            RuleResult ruleResult = ruleSetExec.exec();
            traceWriter.writeTracePlan(null, "0-initial-flow-element-graph", flowElementGraph);
            FlowElementGraph finalFlowElementGraph = ruleResult.getAssemblyGraph();
            finalFlowElementGraph = ((BaseFlow)flow).updateSchemes(finalFlowElementGraph);
            Map<ElementGraph, List<? extends ElementGraph>> stepToNodes = ruleResult.getStepToNodeGraphMap();
            Map<ElementGraph, List<? extends ElementGraph>> nodeToPipeline = ruleResult.getNodeToPipelineGraphMap();
            FlowStepGraph flowStepGraph = new FlowStepGraph(this.getFlowStepFactory(), finalFlowElementGraph, stepToNodes, nodeToPipeline);
            traceWriter.writeFinal("1-final-flow-registry", ruleResult);
            traceWriter.writeTracePlan(null, "2-final-flow-element-graph", finalFlowElementGraph);
            traceWriter.writeTracePlan(null, "3-final-flow-step-graph", flowStepGraph);
            traceWriter.writeTracePlanSteps("4-final-flow-steps", flowStepGraph);
            ((BaseFlow)flow).setPlannerInfo(this.getPlannerInfo(ruleResult.getRegistry().getName()));
            ((BaseFlow)flow).initialize(finalFlowElementGraph, flowStepGraph);
            return flow;
        }
        catch (Exception exception) {
            throw this.handleExceptionDuringPlanning(flowDef, exception, flowElementGraph);
        }
    }

    protected abstract F createFlow(FlowDef var1);

    public abstract FlowStepFactory<Config> getFlowStepFactory();

    public FlowNodeFactory getFlowNodeFactory() {
        return new BaseFlowNodeFactory();
    }

    public void configRuleRegistryDefaults(RuleRegistry ruleRegistry) {
        ruleRegistry.addDefaultElementFactory("cascading.registry.pipe.identity", new IdentityElementFactgory());
    }

    protected Pipe[] resolveTails(FlowDef flowDef, F flow) {
        Pipe[] tails = flowDef.getTailsArray();
        tails = this.resolveAssemblyPlanners(flowDef, (Flow)flow, tails);
        return tails;
    }

    protected Pipe[] resolveAssemblyPlanners(FlowDef flowDef, Flow flow, Pipe[] pipes) {
        List<Pipe> tails = Arrays.asList(pipes);
        List<AssemblyPlanner> assemblyPlanners = flowDef.getAssemblyPlanners();
        for (AssemblyPlanner assemblyPlanner : assemblyPlanners) {
            tails = assemblyPlanner.resolveTails(new AssemblyPlannerContext(flowDef, flow, tails));
            if (tails.isEmpty()) {
                throw new PlannerException("assembly planner: " + assemblyPlanner + ", returned zero tails");
            }
            tails = Collections.unmodifiableList(tails);
        }
        return tails.toArray(new Pipe[tails.size()]);
    }

    protected void verifyAssembly(FlowDef flowDef, Pipe[] tails) {
        this.verifyPipeAssemblyEndPoints(flowDef, tails);
        this.verifyTraps(flowDef, tails);
        this.verifyCheckpoints(flowDef, tails);
    }

    protected void verifyAllTaps(FlowDef flowDef) {
        this.verifySourceNotSinks(flowDef.getSources(), flowDef.getSinks());
        this.verifyTaps(flowDef.getSources(), true, true);
        this.verifyTaps(flowDef.getSinks(), false, true);
        this.verifyTaps(flowDef.getTraps(), false, false);
        this.verifyTaps(flowDef.getCheckpoints(), true, false);
        this.verifyTaps(flowDef.getCheckpoints(), false, false);
    }

    protected FlowElementGraph createFlowElementGraph(FlowDef flowDef, Pipe[] flowTails) {
        Map<String, Tap> sources = flowDef.getSourcesCopy();
        Map<String, Tap> sinks = flowDef.getSinksCopy();
        Map<String, Tap> traps = flowDef.getTrapsCopy();
        Map<String, Tap> checkpoints = flowDef.getCheckpointsCopy();
        this.checkpointTapRootPath = this.makeCheckpointRootPath(flowDef);
        return new FlowElementGraph(this.getPlatformInfo(), flowTails, sources, sinks, traps, checkpoints, this.checkpointTapRootPath != null);
    }

    private FlowDef normalizeTaps(FlowDef flowDef) {
        HashSet<Tap> taps = new HashSet<Tap>();
        Map<String, Tap> sources = flowDef.getSourcesCopy();
        Map<String, Tap> sinks = flowDef.getSinksCopy();
        Map<String, Tap> traps = flowDef.getTrapsCopy();
        Map<String, Tap> checkpoints = flowDef.getCheckpointsCopy();
        boolean sourcesHasDupes = this.addTaps(sources, taps);
        boolean sinksHasDupes = this.addTaps(sinks, taps);
        boolean trapsHasDupes = this.addTaps(traps, taps);
        boolean checkpointsHasDupes = this.addTaps(checkpoints, taps);
        if (sourcesHasDupes) {
            this.normalize(taps, sources);
        }
        if (sinksHasDupes) {
            this.normalize(taps, sinks);
        }
        if (trapsHasDupes) {
            this.normalize(taps, traps);
        }
        if (checkpointsHasDupes) {
            this.normalize(taps, checkpoints);
        }
        return Flows.copy(flowDef, sources, sinks, traps, checkpoints);
    }

    private boolean addTaps(Map<String, Tap> current, Set<Tap> taps) {
        int size = taps.size();
        taps.addAll(current.values());
        return size + current.size() != taps.size();
    }

    private void normalize(Set<Tap> taps, Map<String, Tap> current) {
        for (Tap tap : taps) {
            for (Map.Entry<String, Tap> entry : current.entrySet()) {
                if (!entry.getValue().equals(tap)) continue;
                entry.setValue(tap);
            }
        }
    }

    private String makeCheckpointRootPath(FlowDef flowDef) {
        String flowName = flowDef.getName();
        String runID = flowDef.getRunID();
        if (runID == null) {
            return null;
        }
        if (flowName == null) {
            throw new PlannerException("flow name is required when providing a run id");
        }
        return flowName + "/" + runID;
    }

    protected void verifySourceNotSinks(Map<String, Tap> sources, Map<String, Tap> sinks) {
        Collection<Tap> sourcesSet = sources.values();
        for (Tap tap : sinks.values()) {
            if (!sourcesSet.contains(tap)) continue;
            throw new PlannerException("tap may not be used as both source and sink in the same Flow: " + tap);
        }
    }

    protected void verifyTaps(Map<String, Tap> taps, boolean areSources, boolean mayNotBeEmpty) {
        if (mayNotBeEmpty && taps.isEmpty()) {
            throw new PlannerException((areSources ? "source" : "sink") + " taps are required");
        }
        for (String tapName : taps.keySet()) {
            if (areSources && !taps.get(tapName).isSource()) {
                throw new PlannerException("tap named: '" + tapName + "', cannot be used as a source: " + taps.get(tapName));
            }
            if (areSources || taps.get(tapName).isSink()) continue;
            throw new PlannerException("tap named: '" + tapName + "', cannot be used as a sink: " + taps.get(tapName));
        }
    }

    protected void verifyPipeAssemblyEndPoints(FlowDef flowDef, Pipe[] flowTails) {
        HashSet<String> tapNames = new HashSet<String>();
        tapNames.addAll(flowDef.getSources().keySet());
        tapNames.addAll(flowDef.getSinks().keySet());
        HashSet<Pipe> tails = new HashSet<Pipe>();
        HashSet<String> tailNames = new HashSet<String>();
        for (Pipe pipe : flowTails) {
            if (pipe instanceof SubAssembly) {
                Pipe[] pipeArray = ((SubAssembly)pipe).getTails();
                int n = pipeArray.length;
                for (int i = 0; i < n; ++i) {
                    Pipe tail = pipeArray[i];
                    String tailName = tail.getName();
                    if (!tapNames.contains(tailName)) {
                        throw new PlannerException(tail, "pipe name not found in either sink or source map: '" + tailName + "'");
                    }
                    if (tailNames.contains(tailName) && !tails.contains(tail)) {
                        throw new PlannerException(pipe, "duplicate tail name found: " + tailName);
                    }
                    tailNames.add(tailName);
                    tails.add(tail);
                }
                continue;
            }
            String tailName = pipe.getName();
            if (!tapNames.contains(tailName)) {
                throw new PlannerException(pipe, "pipe name not found in either sink or source map: '" + tailName + "'");
            }
            if (tailNames.contains(tailName) && !tails.contains(pipe)) {
                throw new PlannerException(pipe, "duplicate tail name found: " + tailName);
            }
            tailNames.add(tailName);
            tails.add(pipe);
        }
        tailNames.removeAll(flowDef.getSinks().keySet());
        HashSet<String> remainingSinks = new HashSet<String>(flowDef.getSinks().keySet());
        remainingSinks.removeAll(tailNames);
        if (tailNames.size() != 0) {
            throw new PlannerException("not all tail pipes bound to sink taps, remaining tail pipe names: [" + Util.join(Util.quote(tailNames, "'"), ", ") + "], remaining sink tap names: [" + Util.join(Util.quote(remainingSinks, "'"), ", ") + "]");
        }
        remainingSinks = new HashSet<String>(flowDef.getSinks().keySet());
        remainingSinks.removeAll(Arrays.asList(Pipe.names(flowTails)));
        if (remainingSinks.size() != 0) {
            throw new PlannerException("not all sink taps bound to tail pipes, remaining sink tap names: [" + Util.join(Util.quote(remainingSinks, "'"), ", ") + "]");
        }
        HashSet<Pipe> heads = new HashSet<Pipe>();
        HashSet<String> headNames = new HashSet<String>();
        for (Pipe pipe : flowTails) {
            for (Pipe head : pipe.getHeads()) {
                String headName = head.getName();
                if (!tapNames.contains(headName)) {
                    throw new PlannerException(head, "pipe name not found in either sink or source map: '" + headName + "'");
                }
                if (headNames.contains(headName) && !heads.contains(head)) {
                    LOG.warn("duplicate head name found, not an error but heads should have unique names: '{}'", (Object)headName);
                }
                headNames.add(headName);
                heads.add(head);
            }
        }
        HashSet hashSet = new HashSet(headNames);
        headNames.removeAll(flowDef.getSources().keySet());
        HashSet<String> remainingSources = new HashSet<String>(flowDef.getSources().keySet());
        remainingSources.removeAll(headNames);
        if (headNames.size() != 0) {
            throw new PlannerException("not all head pipes bound to source taps, remaining head pipe names: [" + Util.join(Util.quote(headNames, "'"), ", ") + "], remaining source tap names: [" + Util.join(Util.quote(remainingSources, "'"), ", ") + "]");
        }
        remainingSources = new HashSet<String>(flowDef.getSources().keySet());
        remainingSources.removeAll(hashSet);
        if (remainingSources.size() != 0) {
            throw new PlannerException("not all source taps bound to head pipes, remaining source tap names: [" + Util.join(Util.quote(remainingSources, "'"), ", ") + "], remaining head pipe names: [" + Util.join(Util.quote(headNames, "'"), ", ") + "]");
        }
    }

    protected void verifyTraps(FlowDef flowDef, Pipe[] flowTails) {
        this.verifyNotSourcesSinks(flowDef.getTraps(), flowDef.getSources(), flowDef.getSinks(), "trap");
        HashSet<String> names = new HashSet<String>(Arrays.asList(Pipe.names(flowTails)));
        for (String name : flowDef.getTraps().keySet()) {
            if (names.contains(name)) continue;
            throw new PlannerException("trap name not found in assembly: '" + name + "'");
        }
    }

    protected void verifyCheckpoints(FlowDef flowDef, Pipe[] flowTails) {
        this.verifyNotSourcesSinks(flowDef.getCheckpoints(), flowDef.getSources(), flowDef.getSinks(), "checkpoint");
        for (Tap checkpointTap : flowDef.getCheckpoints().values()) {
            Scheme scheme = checkpointTap.getScheme();
            if (scheme.getSourceFields().equals(Fields.UNKNOWN) && scheme.getSinkFields().equals(Fields.ALL)) continue;
            throw new PlannerException("checkpoint tap scheme must be undeclared, source fields must be UNKNOWN, and sink fields ALL, got: " + scheme.toString());
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(Pipe.names(flowTails)));
        for (String name : flowDef.getCheckpoints().keySet()) {
            if (!names.contains(name)) {
                throw new PlannerException("named checkpoint declared in FlowDef, but no named branch found in pipe assembly: '" + name + "'");
            }
            HashSet<Pipe> pipes = new HashSet<Pipe>(Arrays.asList(Pipe.named(name, flowTails)));
            int count = 0;
            for (Pipe pipe : pipes) {
                if (!(pipe instanceof Checkpoint)) continue;
                ++count;
            }
            if (count == 0) {
                throw new PlannerException("no checkpoint pipe with branch name found in pipe assembly: '" + name + "'");
            }
            if (count <= true) continue;
            throw new PlannerException("more than one checkpoint pipe with branch name found in pipe assembly: '" + name + "'");
        }
    }

    private void verifyNotSourcesSinks(Map<String, Tap> taps, Map<String, Tap> sources, Map<String, Tap> sinks, String role) {
        Collection<Tap> sourceTaps = sources.values();
        Collection<Tap> sinkTaps = sinks.values();
        for (Tap tap : taps.values()) {
            if (sourceTaps.contains(tap)) {
                throw new PlannerException("tap may not be used as both a " + role + " and a source in the same Flow: " + tap);
            }
            if (!sinkTaps.contains(tap)) continue;
            throw new PlannerException("tap may not be used as both a " + role + " and a sink in the same Flow: " + tap);
        }
    }

    public Exception verifyResult(RuleResult ruleResult) {
        try {
            this.verifyResultInternal(ruleResult);
        }
        catch (Exception exception) {
            return exception;
        }
        return null;
    }

    protected void verifyResultInternal(RuleResult ruleResult) {
        Set<ProcessLevel> processLevels = this.getReverseOrderedProcessLevels(ruleResult);
        block6: for (ProcessLevel processLevel : processLevels) {
            String registryName = ruleResult.getRegistry().getName();
            switch (processLevel) {
                case Assembly: {
                    FlowElementGraph finalFlowElementGraph = ruleResult.getAssemblyGraph();
                    if (!finalFlowElementGraph.vertexSet().isEmpty()) break;
                    throw new PlannerException("final assembly graph is empty: " + registryName);
                }
                case Step: {
                    Map<ElementGraph, List<? extends ElementGraph>> assemblyToSteps = ruleResult.getAssemblyToStepGraphMap();
                    if (assemblyToSteps.isEmpty()) {
                        throw new PlannerException("no steps partitioned: " + registryName);
                    }
                    for (ElementGraph elementGraph : assemblyToSteps.keySet()) {
                        List<? extends ElementGraph> steps = assemblyToSteps.get(elementGraph);
                        if (steps.isEmpty()) {
                            throw new PlannerException("no steps partitioned from assembly: " + registryName, elementGraph);
                        }
                        HashSet<ElementGraph> stepSet = new HashSet<ElementGraph>(steps.size());
                        for (ElementGraph elementGraph2 : steps) {
                            if (stepSet.add(elementGraph2)) continue;
                            throw new PlannerException("found duplicate step in flow: " + registryName, elementGraph2);
                        }
                        Set elements = Util.createIdentitySet();
                        for (ElementGraph elementGraph3 : steps) {
                            elements.addAll(elementGraph3.vertexSet());
                        }
                        Set<FlowElement> set = Util.differenceIdentity(elementGraph.vertexSet(), elements);
                        if (set.isEmpty()) continue;
                        String string = "union of steps have " + set.size() + " fewer elements than parent assembly: " + registryName + ", missing: [" + TraceUtil.formatTraces(set, ", ") + "]";
                        throw new PlannerException(string, elementGraph);
                    }
                    continue block6;
                }
                case Node: {
                    Map<ElementGraph, List<? extends ElementGraph>> stepToNodes = ruleResult.getStepToNodeGraphMap();
                    if (stepToNodes.isEmpty()) {
                        throw new PlannerException("no nodes partitioned: " + registryName);
                    }
                    for (ElementGraph step : stepToNodes.keySet()) {
                        List<? extends ElementGraph> nodes = stepToNodes.get(step);
                        if (nodes.isEmpty()) {
                            throw new PlannerException("no nodes partitioned from step: " + registryName, step);
                        }
                        HashSet<ElementGraph> nodesSet = new HashSet<ElementGraph>(nodes.size());
                        for (ElementGraph elementGraph : nodes) {
                            if (nodesSet.add(elementGraph)) continue;
                            throw new PlannerException("found duplicate node in step: " + registryName, elementGraph);
                        }
                        Set set = Util.createIdentitySet();
                        for (ElementGraph elementGraph : nodes) {
                            set.addAll(elementGraph.vertexSet());
                        }
                        Set<FlowElement> set2 = Util.differenceIdentity(step.vertexSet(), set);
                        if (set2.isEmpty()) continue;
                        String string = "union of nodes have " + set2.size() + " fewer elements than parent step: " + registryName + ", missing: [" + TraceUtil.formatTraces(set2, ", ") + "]";
                        throw new PlannerException(string, step);
                    }
                    continue block6;
                }
                case Pipeline: {
                    Map<ElementGraph, List<? extends ElementGraph>> map = ruleResult.getNodeToPipelineGraphMap();
                    if (map.isEmpty()) {
                        throw new PlannerException("no pipelines partitioned: " + registryName);
                    }
                    for (ElementGraph node : map.keySet()) {
                        List<? extends ElementGraph> pipelines = map.get(node);
                        if (pipelines.isEmpty()) {
                            throw new PlannerException("no pipelines partitioned from node: " + registryName, node);
                        }
                        HashSet<ElementGraph> hashSet = new HashSet<ElementGraph>(pipelines.size());
                        for (ElementGraph elementGraph : pipelines) {
                            if (hashSet.add(elementGraph)) continue;
                            throw new PlannerException("found duplicate pipeline in node: " + registryName, elementGraph);
                        }
                        Set set = Util.createIdentitySet();
                        for (ElementGraph pipeline3 : pipelines) {
                            set.addAll(pipeline3.vertexSet());
                        }
                        Set<FlowElement> set3 = Util.differenceIdentity(node.vertexSet(), set);
                        if (set3.isEmpty()) continue;
                        String message = "union of pipelines have " + set3.size() + " fewer elements than parent node: " + registryName + ", missing: [" + TraceUtil.formatTraces(set3, ", ") + "]";
                        throw new PlannerException(message, node);
                    }
                    break;
                }
            }
        }
    }

    protected PlannerException handleExceptionDuringPlanning(FlowDef flowDef, Exception exception, FlowElementGraph flowElementGraph) {
        if (exception instanceof PlannerException) {
            if (((PlannerException)exception).elementGraph == null) {
                ((PlannerException)exception).elementGraph = flowElementGraph;
            }
            return (PlannerException)exception;
        }
        if (exception instanceof ElementGraphException) {
            Throwable cause = exception.getCause();
            if (cause == null) {
                cause = exception;
            }
            String message = String.format("[%s] could not build flow from assembly", Util.truncate(flowDef.getName(), 25));
            if (cause.getMessage() != null) {
                message = String.format("%s: [%s]", message, cause.getMessage());
            }
            if (cause instanceof OperatorException) {
                return new PlannerException(message, cause, flowElementGraph);
            }
            if (cause instanceof TapException) {
                return new PlannerException(message, cause, flowElementGraph);
            }
            return new PlannerException(((ElementGraphException)exception).getPipe(), message, cause, flowElementGraph);
        }
        String message = String.format("[%s] could not build flow from assembly", Util.truncate(flowDef.getName(), 25));
        if (exception.getMessage() != null) {
            message = String.format("%s: [%s]", message, exception.getMessage());
        }
        return new PlannerException(message, exception, flowElementGraph);
    }

    private Tap makeTempTap(FlowElementGraph graph, Pipe pipe, String defaultDecoratorClassName) {
        Tap checkpointTap = graph.getCheckpointsMap().get(pipe.getName());
        if (checkpointTap != null) {
            LOG.info("found checkpoint: {}, using tap: {}", (Object)pipe.getName(), (Object)checkpointTap);
            checkpointTap = this.decorateTap(pipe, checkpointTap, "cascading.flowconnector.checkpoint_tap.decorator.classname", null);
        }
        if (checkpointTap == null) {
            if (pipe instanceof Checkpoint) {
                checkpointTap = this.makeTempTap(this.checkpointTapRootPath, pipe.getName());
                checkpointTap = this.decorateTap(pipe, checkpointTap, "cascading.flowconnector.checkpoint_tap.decorator.classname", null);
                checkpointTap.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "cascading.checkpoint", "true");
            } else {
                checkpointTap = this.makeTempTap(pipe.getName());
            }
        }
        return this.decorateTap(pipe, checkpointTap, "cascading.flowconnector.temporary_tap.decorator.classname", defaultDecoratorClassName);
    }

    private Tap decorateTap(Pipe pipe, Tap tempTap, String decoratorClassProp, String defaultDecoratorClassName) {
        String decoratorClassName = PropertyUtil.getProperty(this.defaultProperties, pipe, decoratorClassProp);
        if (Util.isEmpty(decoratorClassName)) {
            decoratorClassName = defaultDecoratorClassName;
        }
        if (Util.isEmpty(decoratorClassName)) {
            return tempTap;
        }
        LOG.info("found decorator property: {}, with value: {}, wrapping tap: {}", new Object[]{decoratorClassProp, decoratorClassName, tempTap});
        tempTap = (Tap)Util.newInstance(decoratorClassName, tempTap);
        return tempTap;
    }

    protected Tap makeTempTap(String name) {
        return this.makeTempTap(null, name);
    }

    protected DebugLevel getDebugLevel(FlowDef flowDef) {
        return flowDef.getDebugLevel() == null ? this.defaultDebugLevel : flowDef.getDebugLevel();
    }

    protected AssertionLevel getAssertionLevel(FlowDef flowDef) {
        return flowDef.getAssertionLevel() == null ? this.defaultAssertionLevel : flowDef.getAssertionLevel();
    }

    protected abstract Tap makeTempTap(String var1, String var2);

    private Set<ProcessLevel> getReverseOrderedProcessLevels(RuleResult ruleResult) {
        TreeSet<ProcessLevel> ordered = new TreeSet<ProcessLevel>(Collections.reverseOrder());
        ordered.addAll(ruleResult.getRegistry().getProcessLevels());
        return ordered;
    }

    public class TempTapElementFactory
    extends IntermediateTapElementFactory {
        private String defaultDecoratorClassName;

        public TempTapElementFactory() {
        }

        public TempTapElementFactory(String defaultDecoratorClassName) {
            this.defaultDecoratorClassName = defaultDecoratorClassName;
        }

        @Override
        public FlowElement create(ElementGraph graph, FlowElement flowElement) {
            if (flowElement instanceof Pipe) {
                return FlowPlanner.this.makeTempTap((FlowElementGraph)graph, (Pipe)flowElement, this.defaultDecoratorClassName);
            }
            if (flowElement instanceof Tap) {
                return FlowPlanner.this.decorateTap(null, (Tap)flowElement, "cascading.flowconnector.temporary_tap.decorator.classname", this.defaultDecoratorClassName);
            }
            throw new IllegalStateException("unknown flow element type: " + flowElement);
        }
    }

    public class IdentityElementFactgory
    extends IntermediatePipeElementFactory {
        @Override
        public FlowElement create(ElementGraph graph, FlowElement flowElement) {
            return new Each((Pipe)flowElement, Fields.ALL, (Function)new Identity(Fields.ALL), Fields.RESULTS);
        }
    }
}

