/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.FlowStep;
import cascading.flow.planner.process.FlowNodeFactory;
import cascading.flow.planner.process.FlowStepFactory;
import cascading.tap.Tap;
import cascading.util.Util;

public abstract class BaseFlowStepFactory<Config>
implements FlowStepFactory<Config> {
    FlowNodeFactory flowNodeFactory;

    protected BaseFlowStepFactory() {
    }

    public BaseFlowStepFactory(FlowNodeFactory flowNodeFactory) {
        this.flowNodeFactory = flowNodeFactory;
    }

    @Override
    public String makeFlowStepName(FlowStep flowStep, int numSteps, int stepNum) {
        Tap sink = Util.getFirst(flowStep.getSinkTaps());
        ++stepNum;
        if (sink == null || sink.isTemporary()) {
            return String.format("(%d/%d)", stepNum, numSteps);
        }
        String identifier = sink.getIdentifier();
        if (Util.isEmpty(identifier)) {
            return String.format("(%d/%d)", stepNum, numSteps);
        }
        if (identifier.length() > 25) {
            identifier = String.format("...%25s", identifier.substring(identifier.length() - 25));
        }
        return String.format("(%d/%d) %s", stepNum, numSteps, identifier);
    }

    @Override
    public FlowNodeFactory getFlowNodeFactory() {
        return this.flowNodeFactory;
    }
}

