/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.FlowElement;
import cascading.flow.FlowNode;
import cascading.flow.FlowStep;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.AnnotatedGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.ElementGraphs;
import cascading.flow.planner.graph.Extent;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.stream.annotations.StreamMode;
import cascading.pipe.Group;
import cascading.pipe.Pipe;
import cascading.stats.FlowNodeStats;
import cascading.tap.Tap;
import cascading.util.ProcessLogger;
import cascading.util.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseFlowNode
implements Serializable,
FlowNode,
ProcessLogger {
    private final String id;
    private int ordinal;
    private String name;
    private Map<String, String> processAnnotations;
    private transient FlowStep flowStep;
    protected ElementGraph nodeSubGraph;
    protected List<? extends ElementGraph> pipelineGraphs = Collections.emptyList();
    private transient Set<FlowElement> sourceElements;
    private transient Set<FlowElement> sinkElements;
    private Map<String, Tap> trapMap = Collections.emptyMap();
    protected Set<Tap> sourceTaps;
    protected Set<Tap> sinkTaps;
    private Map<Tap, Set<String>> reverseSourceTaps;
    private Map<Tap, Set<String>> reverseSinkTaps;
    private Map<FlowElement, ElementGraph> streamPipelineMap = Collections.emptyMap();
    private Map<String, String> flowNodeDescriptor = Collections.emptyMap();
    protected transient FlowNodeStats flowNodeStats;

    public BaseFlowNode(String name, int ordinal) {
        this(name, ordinal, null);
    }

    public BaseFlowNode(String name, int ordinal, Map<String, String> flowNodeDescriptor) {
        this(null, name, ordinal, flowNodeDescriptor);
    }

    public BaseFlowNode(ElementGraph nodeSubGraph, String name, int ordinal) {
        this(nodeSubGraph, name, ordinal, null);
    }

    public BaseFlowNode(ElementGraph nodeSubGraph, String name, int ordinal, Map<String, String> flowNodeDescriptor) {
        this.id = Util.createUniqueIDWhichStartsWithAChar();
        this.nodeSubGraph = nodeSubGraph;
        this.setName(name);
        this.ordinal = ordinal;
        this.trapMap = Collections.emptyMap();
        this.setFlowNodeDescriptor(flowNodeDescriptor);
    }

    public BaseFlowNode(ElementGraph nodeSubGraph) {
        this(null, nodeSubGraph, null, null);
    }

    public BaseFlowNode(ElementGraph nodeSubGraph, Map<String, String> flowNodeDescriptor) {
        this(null, nodeSubGraph, flowNodeDescriptor);
    }

    public BaseFlowNode(ElementGraph nodeSubGraph, List<? extends ElementGraph> pipelineGraphs) {
        this(null, nodeSubGraph, pipelineGraphs, null);
    }

    public BaseFlowNode(FlowElementGraph flowElementGraph, ElementGraph nodeSubGraph, Map<String, String> flowNodeDescriptor) {
        this(flowElementGraph, nodeSubGraph, null, flowNodeDescriptor);
    }

    public BaseFlowNode(FlowElementGraph flowElementGraph, ElementGraph nodeSubGraph, List<? extends ElementGraph> pipelineGraphs) {
        this(flowElementGraph, nodeSubGraph, pipelineGraphs, null);
    }

    public BaseFlowNode(FlowElementGraph flowElementGraph, ElementGraph nodeSubGraph, List<? extends ElementGraph> pipelineGraphs, Map<String, String> flowNodeDescriptor) {
        this.id = Util.createUniqueIDWhichStartsWithAChar();
        this.nodeSubGraph = nodeSubGraph;
        this.setPipelineGraphs(pipelineGraphs);
        this.setFlowNodeDescriptor(flowNodeDescriptor);
        this.verifyPipelines();
        this.createPipelineMap();
        if (flowElementGraph != null) {
            this.assignTrappableNames(flowElementGraph);
            this.assignTraps(flowElementGraph.getTrapMap());
        }
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getFlowNodeDescriptor() {
        return this.flowNodeDescriptor;
    }

    protected void setFlowNodeDescriptor(Map<String, String> flowNodeDescriptor) {
        if (flowNodeDescriptor != null) {
            this.flowNodeDescriptor = flowNodeDescriptor;
        }
    }

    @Override
    public Map<String, String> getProcessAnnotations() {
        if (this.processAnnotations == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.processAnnotations);
    }

    @Override
    public void addProcessAnnotation(Enum annotation) {
        if (annotation == null) {
            return;
        }
        this.addProcessAnnotation(annotation.getDeclaringClass().getName(), annotation.name());
    }

    @Override
    public void addProcessAnnotation(String key, String value) {
        if (this.processAnnotations == null) {
            this.processAnnotations = new HashMap<String, String>();
        }
        this.processAnnotations.put(key, value);
    }

    public void setFlowNodeStats(FlowNodeStats flowNodeStats) {
        this.flowNodeStats = flowNodeStats;
    }

    @Override
    public FlowNodeStats getFlowNodeStats() {
        return this.flowNodeStats;
    }

    public void setFlowStep(FlowStep flowStep) {
        this.flowStep = flowStep;
    }

    @Override
    public FlowStep getFlowStep() {
        return this.flowStep;
    }

    @Override
    public ElementGraph getElementGraph() {
        return this.nodeSubGraph;
    }

    @Override
    public Set<String> getSourceElementNames() {
        HashSet<String> results = new HashSet<String>();
        for (FlowElement flowElement : this.getSourceElements()) {
            if (flowElement instanceof Tap) {
                results.addAll(this.getSourceTapNames((Tap)flowElement));
                continue;
            }
            results.add(((Pipe)flowElement).getName());
        }
        return results;
    }

    @Override
    public Set<FlowElement> getSourceElements() {
        if (this.sourceElements == null) {
            this.sourceElements = Collections.unmodifiableSet(ElementGraphs.findSources(this.nodeSubGraph, FlowElement.class));
        }
        return this.sourceElements;
    }

    @Override
    public Set<? extends FlowElement> getSourceElements(Enum annotation) {
        Collection annotated = this.getFlowElementsFor(annotation);
        Set<FlowElement> sourceElements = this.getSourceElements();
        HashSet<FlowElement> results = new HashSet<FlowElement>();
        for (FlowElement sourceElement : sourceElements) {
            if (!annotated.contains(sourceElement)) continue;
            results.add(sourceElement);
        }
        return results;
    }

    @Override
    public Set<String> getSinkElementNames() {
        HashSet<String> results = new HashSet<String>();
        for (FlowElement flowElement : this.getSinkElements()) {
            if (flowElement instanceof Tap) {
                results.addAll(this.getSinkTapNames((Tap)flowElement));
                continue;
            }
            results.add(((Pipe)flowElement).getName());
        }
        return results;
    }

    @Override
    public Set<FlowElement> getSinkElements() {
        if (this.sinkElements == null) {
            this.sinkElements = Collections.unmodifiableSet(ElementGraphs.findSinks(this.nodeSubGraph, FlowElement.class));
        }
        return this.sinkElements;
    }

    @Override
    public Set<? extends FlowElement> getSinkElements(Enum annotation) {
        Collection annotated = this.getFlowElementsFor(annotation);
        Set<FlowElement> sinkElements = this.getSinkElements();
        HashSet<FlowElement> results = new HashSet<FlowElement>();
        for (FlowElement sinkElement : sinkElements) {
            if (!annotated.contains(sinkElement)) continue;
            results.add(sinkElement);
        }
        return results;
    }

    @Override
    public List<? extends ElementGraph> getPipelineGraphs() {
        return this.pipelineGraphs;
    }

    protected void setPipelineGraphs(List<? extends ElementGraph> pipelineGraphs) {
        if (pipelineGraphs != null) {
            this.pipelineGraphs = pipelineGraphs;
        }
    }

    @Override
    public ElementGraph getPipelineGraphFor(FlowElement streamedSource) {
        return this.streamPipelineMap.get(streamedSource);
    }

    @Override
    public Collection<Group> getGroups() {
        return ElementGraphs.findAllGroups(this.nodeSubGraph);
    }

    @Override
    public Set<Tap> getSourceTaps() {
        if (this.sourceTaps != null) {
            return this.sourceTaps;
        }
        this.sourceTaps = Collections.unmodifiableSet(Util.narrowIdentitySet(Tap.class, this.getSourceElements()));
        return this.sourceTaps;
    }

    @Override
    public Set<Tap> getSinkTaps() {
        if (this.sinkTaps != null) {
            return this.sinkTaps;
        }
        this.sinkTaps = Collections.unmodifiableSet(Util.narrowIdentitySet(Tap.class, this.getSinkElements()));
        return this.sinkTaps;
    }

    @Override
    public int getSubmitPriority() {
        return 0;
    }

    @Override
    public Set<String> getSourceTapNames(Tap source) {
        return this.reverseSourceTaps.get(source);
    }

    @Override
    public Set<String> getSinkTapNames(Tap sink) {
        return this.reverseSinkTaps.get(sink);
    }

    private void assignTrappableNames(FlowElementGraph flowElementGraph) {
        if (flowElementGraph == null) {
            return;
        }
        this.reverseSourceTaps = new HashMap<Tap, Set<String>>();
        this.reverseSinkTaps = new HashMap<Tap, Set<String>>();
        Set<Tap> sources = this.getSourceTaps();
        for (Tap tap : sources) {
            Set<Scope> set = flowElementGraph.outgoingEdgesOf(tap);
            for (Scope scope : set) {
                this.addSourceName(scope.getName(), tap);
            }
        }
        for (Map.Entry entry : flowElementGraph.getSourceMap().entrySet()) {
            if (!sources.contains(entry.getValue())) continue;
            this.addSourceName((String)entry.getKey(), (Tap)entry.getValue());
        }
        Set<Tap> sinks = this.getSinkTaps();
        for (Tap tap : sinks) {
            Set<Scope> scopes = flowElementGraph.incomingEdgesOf(tap);
            for (Scope scope : scopes) {
                this.addSinkName(scope.getName(), tap);
            }
        }
        for (Map.Entry<String, Tap> entry : flowElementGraph.getSinkMap().entrySet()) {
            if (!sinks.contains(entry.getValue())) continue;
            this.addSinkName(entry.getKey(), entry.getValue());
        }
    }

    private void addSourceName(String name, Tap source) {
        if (!this.reverseSourceTaps.containsKey(source)) {
            this.reverseSourceTaps.put(source, new HashSet());
        }
        this.reverseSourceTaps.get(source).add(name);
    }

    private void addSinkName(String name, Tap sink) {
        if (!this.reverseSinkTaps.containsKey(sink)) {
            this.reverseSinkTaps.put(sink, new HashSet());
        }
        this.reverseSinkTaps.get(sink).add(name);
    }

    @Override
    public Map<String, Tap> getTrapMap() {
        return this.trapMap;
    }

    @Override
    public Collection<? extends Tap> getTraps() {
        return this.getTrapMap().values();
    }

    private void assignTraps(Map<String, Tap> traps) {
        this.trapMap = new HashMap<String, Tap>();
        for (FlowElement flowElement : this.nodeSubGraph.vertexSet()) {
            HashSet<String> names = new HashSet<String>();
            if (flowElement instanceof Extent) continue;
            if (flowElement instanceof Pipe) {
                names.add(((Pipe)flowElement).getName());
            } else {
                Set<String> sinkTapNames;
                Set<String> sourceTapNames = this.getSourceTapNames((Tap)flowElement);
                if (sourceTapNames != null) {
                    names.addAll(sourceTapNames);
                }
                if ((sinkTapNames = this.getSinkTapNames((Tap)flowElement)) != null) {
                    names.addAll(sinkTapNames);
                }
            }
            for (String name : names) {
                if (!traps.containsKey(name)) continue;
                this.trapMap.put(name, traps.get(name));
            }
        }
    }

    private void verifyPipelines() {
        if (this.pipelineGraphs == null || this.pipelineGraphs.isEmpty()) {
            return;
        }
        Set<FlowElement> allElements = Util.createIdentitySet(this.nodeSubGraph.vertexSet());
        for (ElementGraph elementGraph : this.pipelineGraphs) {
            allElements.removeAll(elementGraph.vertexSet());
        }
        if (!allElements.isEmpty()) {
            throw new IllegalStateException("union of pipeline graphs for flow node are missing elements: " + Util.join(allElements, ", "));
        }
    }

    private void createPipelineMap() {
        if (this.pipelineGraphs == null || this.pipelineGraphs.isEmpty()) {
            return;
        }
        HashMap<FlowElement, ElementGraph> map = new HashMap<FlowElement, ElementGraph>(this.pipelineGraphs.size());
        for (ElementGraph elementGraph : this.pipelineGraphs) {
            if (!(elementGraph instanceof AnnotatedGraph)) {
                throw new IllegalStateException("pipeline graphs must be of type AnnotatedGraph, got: " + elementGraph.getClass().getName());
            }
            Set flowElements = ((AnnotatedGraph)((Object)elementGraph)).hasAnnotations() ? (Set)((AnnotatedGraph)((Object)elementGraph)).getAnnotations().getValues(StreamMode.Streamed) : ElementGraphs.findSources(elementGraph, FlowElement.class);
            for (FlowElement flowElement : flowElements) {
                if (map.containsKey(flowElement)) {
                    throw new IllegalStateException("duplicate streamable elements, found:  " + flowElement);
                }
                map.put(flowElement, elementGraph);
            }
        }
        this.streamPipelineMap = map;
    }

    @Override
    public Tap getTrap(String branchName) {
        return this.trapMap.get(branchName);
    }

    @Override
    public Collection<? extends Scope> getPreviousScopes(FlowElement flowElement) {
        return this.nodeSubGraph.incomingEdgesOf(flowElement);
    }

    @Override
    public Collection<? extends Scope> getNextScopes(FlowElement flowElement) {
        return this.nodeSubGraph.outgoingEdgesOf(flowElement);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BaseFlowNode flowNode = (BaseFlowNode)object;
        return !(this.id != null ? !this.id.equals(flowNode.id) : flowNode.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public Set<? extends FlowElement> getFlowElementsFor(Enum annotation) {
        if (this.pipelineGraphs.isEmpty()) {
            return (Set)((AnnotatedGraph)((Object)this.getElementGraph())).getAnnotations().getValues(annotation);
        }
        Set results = Util.createIdentitySet();
        for (ElementGraph elementGraph : this.pipelineGraphs) {
            results.addAll(((AnnotatedGraph)((Object)elementGraph)).getAnnotations().getValues(annotation));
        }
        return results;
    }

    private ProcessLogger getLogger() {
        if (this.flowStep != null && this.flowStep instanceof ProcessLogger) {
            return (ProcessLogger)((Object)this.flowStep);
        }
        return ProcessLogger.NULL;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public void logInfo(String message, Object ... arguments) {
        this.getLogger().logInfo(message, arguments);
    }

    @Override
    public void logDebug(String message, Object ... arguments) {
        this.getLogger().logDebug(message, arguments);
    }

    @Override
    public void logWarn(String message) {
        this.getLogger().logWarn(message);
    }

    @Override
    public void logWarn(String message, Object ... arguments) {
        this.getLogger().logWarn(message, arguments);
    }

    @Override
    public void logWarn(String message, Throwable throwable) {
        this.getLogger().logWarn(message, throwable);
    }

    @Override
    public void logError(String message, Object ... arguments) {
        this.getLogger().logError(message, arguments);
    }

    @Override
    public void logError(String message, Throwable throwable) {
        this.getLogger().logError(message, throwable);
    }
}

