/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.FlowElement;
import cascading.flow.FlowElements;
import cascading.flow.planner.FlowStepJob;
import cascading.flow.planner.graph.FlowElementGraph;
import cascading.flow.planner.process.FlowStepGraph;
import cascading.tap.Tap;
import java.util.Map;
import java.util.Set;

public final class Flows {
    private Flows() {
    }

    public static Map<String, FlowStepJob> getJobsMap(Flow flow) {
        return ((BaseFlow)flow).getJobsMap();
    }

    public static FlowElementGraph getFlowElementGraphFrom(Flow flow) {
        return ((BaseFlow)flow).getFlowElementGraph();
    }

    public static FlowStepGraph getStepGraphFrom(Flow flow) {
        return ((BaseFlow)flow).getFlowStepGraph();
    }

    public static String getNameOrID(Flow flow) {
        if (flow == null) {
            return null;
        }
        if (flow.getName() != null) {
            return flow.getName();
        }
        return flow.getID().substring(0, 6);
    }

    public static Tap getTapForID(Set<Tap> taps, String id) {
        for (Tap tap : taps) {
            if (!Tap.id(tap).equals(id)) continue;
            return tap;
        }
        return null;
    }

    public static FlowElement getFlowElementForID(Set<FlowElement> flowElements, String id) {
        for (FlowElement flowElement : flowElements) {
            if (!FlowElements.id(flowElement).equals(id)) continue;
            return flowElement;
        }
        return null;
    }

    public static FlowDef copy(FlowDef flowDef, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Map<String, Tap> checkpoints) {
        return new FlowDef(flowDef, sources, sinks, traps, checkpoints);
    }

    public static void fireOnCompleted(Flow flow) {
        if (flow instanceof BaseFlow) {
            ((BaseFlow)flow).fireOnCompleted();
        }
    }
}

