/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.property.Props;
import cascading.util.Util;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class FlowRuntimeProps
extends Props {
    public static final String GATHER_PARTITIONS = "cascading.flow.runtime.gather.partitions.num";
    public static final String LOG_COUNTERS = "cascading.flow.runtime.log.counters";
    public static final String COMBINE_SPLITS = "cascading.flow.runtime.splits.combine";
    int gatherPartitions = 0;
    Set<String> logCounters = new LinkedHashSet<String>();
    Boolean combineSplits;

    public static FlowRuntimeProps flowRuntimeProps() {
        return new FlowRuntimeProps();
    }

    public int getGatherPartitions() {
        return this.gatherPartitions;
    }

    public FlowRuntimeProps setGatherPartitions(int gatherPartitions) {
        if (gatherPartitions < 1) {
            throw new IllegalArgumentException("gatherPartitions value must be greater than zero");
        }
        this.gatherPartitions = gatherPartitions;
        return this;
    }

    public FlowRuntimeProps addLogCounter(Enum counter) {
        this.addLogCounter(counter.getDeclaringClass().getName(), counter.name());
        return this;
    }

    public FlowRuntimeProps addLogCounter(String group, String counter) {
        this.logCounters.add(group + ":" + counter);
        return this;
    }

    public Boolean getCombineSplits() {
        return this.combineSplits;
    }

    public FlowRuntimeProps setCombineSplits(Boolean combineSplits) {
        this.combineSplits = combineSplits;
        return this;
    }

    @Override
    protected void addPropertiesTo(Properties properties) {
        if (this.gatherPartitions > 0) {
            properties.setProperty(GATHER_PARTITIONS, Integer.toString(this.gatherPartitions));
        }
        if (!this.logCounters.isEmpty()) {
            properties.setProperty(LOG_COUNTERS, Util.join(this.logCounters, ","));
        }
        if (this.combineSplits != null) {
            properties.setProperty(COMBINE_SPLITS, Boolean.toString(this.combineSplits));
        }
    }
}

