/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.property.Props;
import java.util.Map;
import java.util.Properties;

public class FlowProps
extends Props {
    public static final String DEFAULT_ELEMENT_COMPARATOR = "cascading.flow.tuple.element.comparator";
    public static final String PRESERVE_TEMPORARY_FILES = "cascading.flow.preservetemporaryfiles";
    public static final String JOB_POLLING_INTERVAL = "cascading.flow.job.pollinginterval";
    public static final String MAX_CONCURRENT_STEPS = "cascading.flow.maxconcurrentsteps";
    public static final String STOP_JOBS_ON_EXIT = "cascading.flow.stopjobsonexit";
    String defaultTupleElementComparator = null;
    boolean preserveTemporaryFiles = false;
    int jobPollingInterval = 5000;
    int maxConcurrentSteps = 0;
    boolean stopJobsOnExit = true;

    public static void setDefaultTupleElementComparator(Map<Object, Object> properties, String className) {
        if (className != null) {
            properties.put(DEFAULT_ELEMENT_COMPARATOR, className);
        }
    }

    public static void setPreserveTemporaryFiles(Map<Object, Object> properties, boolean preserveTemporaryFiles) {
        properties.put(PRESERVE_TEMPORARY_FILES, Boolean.toString(preserveTemporaryFiles));
    }

    public static void setJobPollingInterval(Map<Object, Object> properties, long interval) {
        properties.put(JOB_POLLING_INTERVAL, Long.toString(interval));
    }

    public static void setMaxConcurrentSteps(Map<Object, Object> properties, int numConcurrentSteps) {
        properties.put(MAX_CONCURRENT_STEPS, Integer.toString(numConcurrentSteps));
    }

    public static void setStopJobsOnExit(Map<Object, Object> properties, boolean stopJobsOnExit) {
        properties.put(STOP_JOBS_ON_EXIT, Boolean.toString(stopJobsOnExit));
    }

    public static FlowProps flowProps() {
        return new FlowProps();
    }

    public String getDefaultTupleElementComparator() {
        return this.defaultTupleElementComparator;
    }

    public FlowProps setDefaultTupleElementComparator(String defaultTupleElementComparator) {
        this.defaultTupleElementComparator = defaultTupleElementComparator;
        return this;
    }

    public boolean isPreserveTemporaryFiles() {
        return this.preserveTemporaryFiles;
    }

    public FlowProps setPreserveTemporaryFiles(boolean preserveTemporaryFiles) {
        this.preserveTemporaryFiles = preserveTemporaryFiles;
        return this;
    }

    public int getJobPollingInterval() {
        return this.jobPollingInterval;
    }

    public FlowProps setJobPollingInterval(int jobPollingInterval) {
        this.jobPollingInterval = jobPollingInterval;
        return this;
    }

    public int getMaxConcurrentSteps() {
        return this.maxConcurrentSteps;
    }

    public FlowProps setMaxConcurrentSteps(int maxConcurrentSteps) {
        this.maxConcurrentSteps = maxConcurrentSteps;
        return this;
    }

    public boolean isStopJobsOnExit() {
        return this.stopJobsOnExit;
    }

    public FlowProps setStopJobsOnExit(boolean stopJobsOnExit) {
        this.stopJobsOnExit = stopJobsOnExit;
        return this;
    }

    @Override
    protected void addPropertiesTo(Properties properties) {
        FlowProps.setDefaultTupleElementComparator(properties, this.defaultTupleElementComparator);
        FlowProps.setPreserveTemporaryFiles(properties, this.preserveTemporaryFiles);
        FlowProps.setJobPollingInterval(properties, this.jobPollingInterval);
        FlowProps.setMaxConcurrentSteps(properties, this.maxConcurrentSteps);
        FlowProps.setStopJobsOnExit(properties, this.stopJobsOnExit);
    }
}

