/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.FlowSession;
import cascading.flow.stream.duct.DuctException;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class FlowProcess<Config> {
    public static FlowProcess NULL = new NullFlowProcess();
    private FlowSession currentSession = FlowSession.NULL;
    private Map<Tap, TupleEntryCollector> trapCollectors;
    private FlowProcessContext flowProcessContext = new FlowProcessContext();

    public static <C> FlowProcess<C> nullFlowProcess() {
        return NULL;
    }

    protected FlowProcess() {
    }

    protected FlowProcess(FlowSession currentSession) {
        this.setCurrentSession(currentSession);
    }

    protected FlowProcess(FlowProcess<Config> flowProcess) {
        this.setCurrentSession(flowProcess.getCurrentSession());
        this.trapCollectors = flowProcess.getTrapCollectors();
        this.flowProcessContext = flowProcess.getFlowProcessContext();
    }

    public FlowProcessContext getFlowProcessContext() {
        return this.flowProcessContext;
    }

    public abstract FlowProcess<Config> copyWith(Config var1);

    public String getID() {
        return this.getStringProperty("cascading.flow.step.id");
    }

    public FlowSession getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(FlowSession currentSession) {
        this.currentSession = currentSession;
        currentSession.setCurrentProcess(this);
    }

    public abstract int getNumProcessSlices();

    public abstract int getCurrentSliceNum();

    public abstract Object getProperty(String var1);

    public String getStringProperty(String key) {
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String getStringProperty(String key, String defaultValue) {
        Object value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public Integer getIntegerProperty(String key) {
        String value = this.getStringProperty(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String value = this.getStringProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public Boolean getBooleanProperty(String key) {
        String value = this.getStringProperty(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getStringProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public abstract Collection<String> getPropertyKeys();

    public abstract Object newInstance(String var1);

    public abstract void keepAlive();

    public abstract void increment(Enum var1, long var2);

    public abstract void increment(String var1, String var2, long var3);

    public abstract long getCounterValue(Enum var1);

    public abstract long getCounterValue(String var1, String var2);

    public abstract void setStatus(String var1);

    public abstract boolean isCounterStatusInitialized();

    public abstract TupleEntryIterator openTapForRead(Tap var1) throws IOException;

    public abstract TupleEntryCollector openTapForWrite(Tap var1) throws IOException;

    public abstract TupleEntryCollector openTrapForWrite(Tap var1) throws IOException;

    public abstract TupleEntryCollector openSystemIntermediateForWrite() throws IOException;

    public abstract Config getConfig();

    public abstract Config getConfigCopy();

    public abstract <C> C copyConfig(C var1);

    public abstract <C> Map<String, String> diffConfigIntoMap(C var1, C var2);

    public abstract Config mergeMapIntoConfig(Config var1, Map<String, String> var2);

    public TupleEntryCollector getTrapCollectorFor(Tap trap) {
        Map<Tap, TupleEntryCollector> trapCollectors = this.getTrapCollectors();
        TupleEntryCollector trapCollector = trapCollectors.get(trap);
        if (trapCollector == null) {
            try {
                trapCollector = this.openTrapForWrite(trap);
                trapCollectors.put(trap, trapCollector);
            }
            catch (IOException exception) {
                throw new DuctException(exception);
            }
        }
        return trapCollector;
    }

    protected synchronized Map<Tap, TupleEntryCollector> getTrapCollectors() {
        if (this.trapCollectors == null) {
            this.trapCollectors = Collections.synchronizedMap(new HashMap());
        }
        return this.trapCollectors;
    }

    public synchronized void closeTrapCollectors() {
        if (this.trapCollectors == null) {
            return;
        }
        for (TupleEntryCollector trapCollector : this.trapCollectors.values()) {
            try {
                trapCollector.close();
            }
            catch (Exception exception) {}
        }
        this.trapCollectors.clear();
    }

    public class FlowProcessContext {
        String sourcePath;

        public String getSourcePath() {
            return FlowProcess.this.getStringProperty("cascading.source.path", this.sourcePath);
        }

        public void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }
    }

    public static class NullFlowProcess
    extends FlowProcess<Object> {
        protected NullFlowProcess() {
        }

        @Override
        public FlowProcess copyWith(Object object) {
            return new NullFlowProcess();
        }

        @Override
        public Object getProperty(String key) {
            return null;
        }

        @Override
        public Collection<String> getPropertyKeys() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Object newInstance(String className) {
            return null;
        }

        @Override
        public void keepAlive() {
        }

        @Override
        public void increment(Enum counter, long amount) {
        }

        @Override
        public void increment(String group, String counter, long amount) {
        }

        @Override
        public long getCounterValue(Enum counter) {
            return 0L;
        }

        @Override
        public long getCounterValue(String group, String counter) {
            return 0L;
        }

        @Override
        public void setStatus(String status) {
        }

        @Override
        public boolean isCounterStatusInitialized() {
            return true;
        }

        @Override
        public int getNumProcessSlices() {
            return 1;
        }

        @Override
        public int getCurrentSliceNum() {
            return 0;
        }

        @Override
        public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
            return tap.openForRead(this);
        }

        @Override
        public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
            return tap.openForWrite(this);
        }

        @Override
        public TupleEntryCollector openTrapForWrite(Tap trap) throws IOException {
            return trap.openForWrite(this);
        }

        @Override
        public TupleEntryCollector openSystemIntermediateForWrite() throws IOException {
            return null;
        }

        @Override
        public Object getConfig() {
            return null;
        }

        @Override
        public Object getConfigCopy() {
            return null;
        }

        @Override
        public Object copyConfig(Object config) {
            return config;
        }

        @Override
        public Map<String, String> diffConfigIntoMap(Object defaultConfig, Object updatedConfig) {
            return null;
        }

        @Override
        public Object mergeMapIntoConfig(Object defaultConfig, Map<String, String> map) {
            return null;
        }
    }
}

