/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.FlowElement;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.TreeMap;

public class FlowElements {
    public static String id(FlowElement flowElement) {
        if (flowElement instanceof Pipe) {
            return Pipe.id((Pipe)flowElement);
        }
        if (flowElement instanceof Tap) {
            return Tap.id((Tap)flowElement);
        }
        String id = (String)Util.returnInstanceFieldIfExistsSafe(flowElement, "id");
        if (id != null) {
            return id;
        }
        throw new IllegalArgumentException("id not supported for: " + flowElement.getClass().getCanonicalName());
    }

    public static int isPrevious(Pipe pipe, Pipe previous) {
        if (pipe == previous) {
            return 0;
        }
        if (pipe instanceof SubAssembly) {
            Pipe[] unwind;
            for (Pipe unwound : unwind = SubAssembly.unwind(pipe)) {
                int result = FlowElements.collectPipes(unwound, 0, previous);
                if (result == -1) continue;
                return result;
            }
            return -1;
        }
        return FlowElements.collectPipes(pipe, 0, previous);
    }

    private static int collectPipes(Pipe pipe, int depth, Pipe ... allPrevious) {
        ++depth;
        for (Pipe previous : allPrevious) {
            if (pipe == previous) {
                return depth;
            }
            int result = previous instanceof SubAssembly ? FlowElements.collectPipes(pipe, depth, SubAssembly.unwind(previous)) : FlowElements.collectPipes(pipe, depth, previous.getPrevious());
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    public static Integer findOrdinal(Pipe pipe, Pipe previous) {
        Pipe[] previousPipes = pipe.getPrevious();
        TreeMap<Integer, Integer> sorted = new TreeMap<Integer, Integer>();
        for (int i = 0; i < previousPipes.length; ++i) {
            int result = FlowElements.isPrevious(previousPipes[i], previous);
            if (result == -1) continue;
            sorted.put(result, i);
        }
        return (Integer)sorted.firstEntry().getValue();
    }
}

