/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.AssemblyPlanner;
import cascading.operation.AssertionLevel;
import cascading.operation.DebugLevel;
import cascading.pipe.Checkpoint;
import cascading.pipe.Pipe;
import cascading.property.UnitOfWorkDef;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FlowDef
extends UnitOfWorkDef<FlowDef> {
    protected Map<String, Tap> sources = new HashMap<String, Tap>();
    protected Map<String, Tap> sinks = new HashMap<String, Tap>();
    protected Map<String, Tap> traps = new HashMap<String, Tap>();
    protected Map<String, Tap> checkpoints = new HashMap<String, Tap>();
    protected List<String> classPath = new ArrayList<String>();
    protected List<Pipe> tails = new ArrayList<Pipe>();
    protected List<AssemblyPlanner> assemblyPlanners = new ArrayList<AssemblyPlanner>();
    protected HashMap<String, String> flowDescriptor = new LinkedHashMap<String, String>();
    protected AssertionLevel assertionLevel;
    protected DebugLevel debugLevel;
    protected String runID;

    public static FlowDef flowDef() {
        return new FlowDef();
    }

    public FlowDef() {
    }

    protected FlowDef(FlowDef flowDef, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Map<String, Tap> checkpoints) {
        super(flowDef);
        this.sources = sources;
        this.sinks = sinks;
        this.traps = traps;
        this.checkpoints = checkpoints;
        this.classPath = flowDef.classPath;
        this.tails = flowDef.tails;
        this.assemblyPlanners = flowDef.assemblyPlanners;
        this.flowDescriptor = flowDef.flowDescriptor;
        this.assertionLevel = flowDef.assertionLevel;
        this.debugLevel = flowDef.debugLevel;
        this.runID = flowDef.runID;
    }

    public List<AssemblyPlanner> getAssemblyPlanners() {
        return this.assemblyPlanners;
    }

    public FlowDef addAssemblyPlanner(AssemblyPlanner assemblyPlanner) {
        this.assemblyPlanners.add(assemblyPlanner);
        this.addDescriptions(assemblyPlanner.getFlowDescriptor());
        return this;
    }

    public Map<String, Tap> getSources() {
        return this.sources;
    }

    public Map<String, Tap> getSourcesCopy() {
        return new HashMap<String, Tap>(this.sources);
    }

    public HashMap<String, String> getFlowDescriptor() {
        return this.flowDescriptor;
    }

    public FlowDef addSource(String name, Tap source) {
        if (this.sources.containsKey(name)) {
            throw new IllegalArgumentException("cannot add duplicate source: " + name);
        }
        this.sources.put(name, source);
        return this;
    }

    public FlowDef addSource(Pipe pipe, Tap source) {
        if (pipe == null) {
            throw new IllegalArgumentException("pipe may not be null");
        }
        Pipe[] heads = pipe.getHeads();
        if (heads.length != 1) {
            throw new IllegalArgumentException("pipe has too many heads, found: " + Arrays.toString(Pipe.names(heads)));
        }
        this.addSource(heads[0].getName(), source);
        return this;
    }

    public FlowDef addSources(Map<String, Tap> sources) {
        if (sources != null) {
            for (Map.Entry<String, Tap> entry : sources.entrySet()) {
                this.addSource(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public FlowDef addDescription(String description) {
        this.addDescription("description", description);
        return this;
    }

    public FlowDef addDescription(String key, String value) {
        String original;
        if (Util.isEmpty(value)) {
            return this;
        }
        if (this.flowDescriptor.containsKey(key) && !Util.isEmpty(original = this.flowDescriptor.get(key))) {
            value = original + "\u001e" + value;
        }
        this.flowDescriptor.put(key, value);
        return this;
    }

    public FlowDef addDescriptions(Map<String, String> descriptions) {
        for (Map.Entry<String, String> entry : descriptions.entrySet()) {
            this.addDescription(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Map<String, Tap> getSinks() {
        return this.sinks;
    }

    public Map<String, Tap> getSinksCopy() {
        return new HashMap<String, Tap>(this.sinks);
    }

    public FlowDef addSink(String name, Tap sink) {
        if (this.sinks.containsKey(name)) {
            throw new IllegalArgumentException("cannot add duplicate sink: " + name);
        }
        this.sinks.put(name, sink);
        return this;
    }

    public FlowDef addSink(Pipe tail, Tap sink) {
        this.addSink(tail.getName(), sink);
        return this;
    }

    public FlowDef addTailSink(Pipe tail, Tap sink) {
        this.addSink(tail.getName(), sink);
        this.addTail(tail);
        return this;
    }

    public FlowDef addSinks(Map<String, Tap> sinks) {
        if (sinks != null) {
            for (Map.Entry<String, Tap> entry : sinks.entrySet()) {
                this.addSink(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public Map<String, Tap> getTraps() {
        return this.traps;
    }

    public Map<String, Tap> getTrapsCopy() {
        return new HashMap<String, Tap>(this.traps);
    }

    public FlowDef addTrap(String name, Tap trap) {
        if (this.traps.containsKey(name)) {
            throw new IllegalArgumentException("cannot add duplicate trap: " + name);
        }
        this.traps.put(name, trap);
        return this;
    }

    public FlowDef addTrap(Pipe pipe, Tap trap) {
        this.addTrap(pipe.getName(), trap);
        return this;
    }

    public FlowDef addTraps(Map<String, Tap> traps) {
        if (traps != null) {
            for (Map.Entry<String, Tap> entry : traps.entrySet()) {
                this.addTrap(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public Map<String, Tap> getCheckpoints() {
        return this.checkpoints;
    }

    public Map<String, Tap> getCheckpointsCopy() {
        return new HashMap<String, Tap>(this.checkpoints);
    }

    public FlowDef addCheckpoint(String name, Tap checkpoint) {
        if (this.checkpoints.containsKey(name)) {
            throw new IllegalArgumentException("cannot add duplicate checkpoint: " + name);
        }
        this.checkpoints.put(name, checkpoint);
        return this;
    }

    public FlowDef addCheckpoint(Checkpoint pipe, Tap checkpoint) {
        this.addCheckpoint(pipe.getName(), checkpoint);
        return this;
    }

    public FlowDef addCheckpoints(Map<String, Tap> checkpoints) {
        if (checkpoints != null) {
            for (Map.Entry<String, Tap> entry : checkpoints.entrySet()) {
                this.addCheckpoint(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public List<Pipe> getTails() {
        return this.tails;
    }

    public Pipe[] getTailsArray() {
        return this.tails.toArray(new Pipe[this.tails.size()]);
    }

    public FlowDef addTail(Pipe tail) {
        if (tail != null) {
            this.tails.add(tail);
        }
        return this;
    }

    public FlowDef addTails(Collection<Pipe> tails) {
        for (Pipe tail : tails) {
            this.addTail(tail);
        }
        return this;
    }

    public FlowDef addTails(Pipe ... tails) {
        for (Pipe tail : tails) {
            this.addTail(tail);
        }
        return this;
    }

    public FlowDef setAssertionLevel(AssertionLevel assertionLevel) {
        this.assertionLevel = assertionLevel;
        return this;
    }

    public AssertionLevel getAssertionLevel() {
        return this.assertionLevel;
    }

    public FlowDef setDebugLevel(DebugLevel debugLevel) {
        this.debugLevel = debugLevel;
        return this;
    }

    public DebugLevel getDebugLevel() {
        return this.debugLevel;
    }

    public FlowDef setRunID(String runID) {
        if (runID != null && runID.isEmpty()) {
            return this;
        }
        this.runID = runID;
        return this;
    }

    public String getRunID() {
        return this.runID;
    }

    public List<String> getClassPath() {
        return this.classPath;
    }

    public FlowDef addToClassPath(String artifact) {
        if (artifact == null || artifact.isEmpty()) {
            return this;
        }
        this.classPath.add(artifact);
        return this;
    }
}

