/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.CascadingException;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.planner.FlowPlanner;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.rule.RuleRegistrySet;
import cascading.pipe.Pipe;
import cascading.property.PropertyUtil;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public abstract class FlowConnector {
    protected Map<Object, Object> properties;
    private RuleRegistrySet ruleRegistrySet;

    public Class getIntermediateSchemeClass(Map<Object, Object> properties) {
        Object type = PropertyUtil.getProperty(properties, "cascading.flowconnector.intermediateschemeclass", null);
        if (type == null) {
            return this.getDefaultIntermediateSchemeClass();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        try {
            return FlowConnector.class.getClassLoader().loadClass(type.toString());
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + type.toString(), exception);
        }
    }

    protected abstract Class<? extends Scheme> getDefaultIntermediateSchemeClass();

    protected FlowConnector() {
        this.properties = new HashMap<Object, Object>();
    }

    protected FlowConnector(RuleRegistrySet ruleRegistrySet) {
        this();
        this.ruleRegistrySet = ruleRegistrySet;
    }

    protected FlowConnector(Map<Object, Object> properties) {
        this.properties = properties == null ? new HashMap<Object, Object>() : (properties instanceof Properties ? new Properties((Properties)properties) : new HashMap<Object, Object>(properties));
    }

    protected FlowConnector(Map<Object, Object> properties, RuleRegistrySet ruleRegistrySet) {
        this(properties);
        this.ruleRegistrySet = ruleRegistrySet;
    }

    public Map<Object, Object> getProperties() {
        return Collections.unmodifiableMap(PropertyUtil.asFlatMap(this.properties));
    }

    public Flow connect(Tap source, Tap sink, Pipe tail) {
        return this.connect(null, source, sink, tail);
    }

    public Flow connect(String name, Tap source, Tap sink, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source);
        return this.connect(name, sources, sink, tail);
    }

    public Flow connect(String name, Tap source, Tap sink, Tap trap, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source);
        HashMap<String, Tap> traps = new HashMap<String, Tap>();
        traps.put(tail.getHeads()[0].getName(), trap);
        return this.connect(name, sources, sink, traps, tail);
    }

    public Flow connect(Map<String, Tap> sources, Tap sink, Pipe tail) {
        return this.connect(null, sources, sink, tail);
    }

    public Flow connect(String name, Map<String, Tap> sources, Tap sink, Pipe tail) {
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink);
        return this.connect(name, sources, sinks, tail);
    }

    public Flow connect(String name, Map<String, Tap> sources, Tap sink, Map<String, Tap> traps, Pipe tail) {
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink);
        return this.connect(name, sources, sinks, traps, tail);
    }

    public Flow connect(String name, Tap source, Tap sink, Map<String, Tap> traps, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source);
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink);
        return this.connect(name, sources, sinks, traps, tail);
    }

    public Flow connect(Tap source, Map<String, Tap> sinks, Collection<Pipe> tails) {
        return this.connect(null, source, sinks, tails.toArray(new Pipe[tails.size()]));
    }

    public Flow connect(String name, Tap source, Map<String, Tap> sinks, Collection<Pipe> tails) {
        return this.connect(name, source, sinks, tails.toArray(new Pipe[tails.size()]));
    }

    public Flow connect(Tap source, Map<String, Tap> sinks, Pipe ... tails) {
        return this.connect(null, source, sinks, tails);
    }

    public Flow connect(String name, Tap source, Map<String, Tap> sinks, Pipe ... tails) {
        HashSet heads = new HashSet();
        for (Pipe pipe : tails) {
            Collections.addAll(heads, pipe.getHeads());
        }
        if (heads.isEmpty()) {
            throw new IllegalArgumentException("no pipe instance found");
        }
        if (heads.size() != 1) {
            throw new IllegalArgumentException("there may be only 1 head pipe instance, found " + heads.size());
        }
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        for (Pipe pipe : heads) {
            sources.put(pipe.getName(), source);
        }
        return this.connect(name, sources, sinks, tails);
    }

    public Flow connect(Map<String, Tap> sources, Map<String, Tap> sinks, Pipe ... tails) {
        return this.connect(null, sources, sinks, tails);
    }

    public Flow connect(String name, Map<String, Tap> sources, Map<String, Tap> sinks, Pipe ... tails) {
        return this.connect(name, sources, sinks, new HashMap<String, Tap>(), tails);
    }

    public Flow connect(String name, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Pipe ... tails) {
        name = name == null ? this.makeName(tails) : name;
        FlowDef flowDef = ((FlowDef)FlowDef.flowDef().setName(name)).addSources(sources).addSinks(sinks).addTraps(traps).addTails(tails);
        return this.connect(flowDef);
    }

    public Flow connect(FlowDef flowDef) {
        FlowPlanner flowPlanner = this.createFlowPlanner();
        flowPlanner.initialize(this, this.properties);
        RuleRegistrySet ruleRegistrySet = this.getRuleRegistrySet();
        return flowPlanner.buildFlow(flowDef, ruleRegistrySet);
    }

    protected abstract FlowPlanner createFlowPlanner();

    public RuleRegistrySet getRuleRegistrySet() {
        if (this.ruleRegistrySet != null) {
            return this.ruleRegistrySet;
        }
        this.ruleRegistrySet = this.createDefaultRuleRegistrySet();
        return this.ruleRegistrySet;
    }

    protected abstract RuleRegistrySet createDefaultRuleRegistrySet();

    public PlatformInfo getPlatformInfo() {
        return this.createFlowPlanner().getPlatformInfo();
    }

    private String makeName(Pipe[] pipes) {
        Object[] names = new String[pipes.length];
        for (int i = 0; i < pipes.length; ++i) {
            names[i] = pipes[i].getName();
        }
        String name = Util.join(names, "+");
        if (name.length() > 32) {
            name = name.substring(0, 32);
        }
        return name;
    }
}

