/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade.planner;

import cascading.cascade.CascadeException;
import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jgrapht.graph.SimpleDirectedGraph;

public abstract class TopologyGraph<Vertex>
extends SimpleDirectedGraph<Vertex, BaseFlow.FlowHolder> {
    public TopologyGraph(Flow ... flows) {
        super(BaseFlow.FlowHolder.class);
        this.makeGraph(flows);
    }

    private void makeGraph(Flow[] flows) {
        for (Flow flow : flows) {
            LinkedList<Tap> sources = new LinkedList<Tap>(flow.getSourcesCollection());
            LinkedList<Tap> sinks = new LinkedList<Tap>(flow.getSinksCollection());
            sinks.addAll(flow.getCheckpointsCollection());
            this.unwrapCompositeTaps(sources);
            this.unwrapCompositeTaps(sinks);
            for (Tap source : sources) {
                this.addVertex(this.getVertex(flow, source));
            }
            for (Tap sink : sinks) {
                this.addVertex(this.getVertex(flow, sink));
            }
            for (Tap source : sources) {
                for (Tap sink : sinks) {
                    this.addEdgeFor(flow, source, sink);
                }
            }
        }
    }

    private void addEdgeFor(Flow flow, Tap source, Tap sink) {
        try {
            this.addEdge(this.getVertex(flow, source), this.getVertex(flow, sink), ((BaseFlow)flow).getHolder());
        }
        catch (IllegalArgumentException exception) {
            throw new CascadeException("no loops allowed in cascade, flow: " + flow.getName() + ", source: " + source + ", sink: " + sink);
        }
    }

    protected abstract Vertex getVertex(Flow var1, Tap var2);

    private void unwrapCompositeTaps(LinkedList<Tap> taps) {
        ListIterator iterator = taps.listIterator();
        while (iterator.hasNext()) {
            Tap tap = (Tap)iterator.next();
            if (!(tap instanceof CompositeTap)) continue;
            iterator.remove();
            Iterator childTaps = ((CompositeTap)((Object)tap)).getChildTaps();
            while (childTaps.hasNext()) {
                iterator.add(childTaps.next());
                iterator.previous();
            }
        }
    }
}

