/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade.planner;

import cascading.cascade.CascadeException;
import cascading.cascade.planner.IdentifierGraph;
import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowGraph
extends SimpleDirectedGraph<Flow, Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowGraph.class);

    public FlowGraph(IdentifierGraph identifierGraph) {
        super(Integer.class);
        this.makeGraph(identifierGraph);
        this.verifyNoCycles();
    }

    public TopologicalOrderIterator<Flow, Integer> getTopologicalIterator() {
        return new TopologicalOrderIterator((Graph)this, new PriorityQueue<Flow>(10, new Comparator<Flow>(){

            @Override
            public int compare(Flow lhs, Flow rhs) {
                return Integer.valueOf(lhs.getSubmitPriority()).compareTo(rhs.getSubmitPriority());
            }
        }));
    }

    private void verifyNoCycles() {
        HashSet<Object> flows = new HashSet<Object>();
        TopologicalOrderIterator topoIterator = new TopologicalOrderIterator((Graph)this);
        while (topoIterator.hasNext()) {
            flows.add(topoIterator.next());
        }
        if (flows.size() != this.vertexSet().size()) {
            throw new CascadeException("there are likely cycles in the set of given flows, topological iterator cannot traverse flows with cycles");
        }
    }

    private void makeGraph(IdentifierGraph identifierGraph) {
        Set identifiers = identifierGraph.vertexSet();
        int count = 0;
        for (String source : identifiers) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("handling flow source: {}", (Object)source);
            }
            List sinks = Graphs.successorListOf((Graph)identifierGraph, (Object)source);
            for (String sink : sinks) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handling flow path: {} -> {}", (Object)source, (Object)sink);
                }
                Flow flow = ((BaseFlow.FlowHolder)identifierGraph.getEdge((Object)source, (Object)sink)).flow;
                this.addVertex(flow);
                Set previous = identifierGraph.incomingEdgesOf(source);
                for (BaseFlow.FlowHolder previousFlow : previous) {
                    this.addVertex(previousFlow.flow);
                    if (this.getEdge(previousFlow.flow, flow) != null || this.addEdge(previousFlow.flow, flow, count++)) continue;
                    throw new CascadeException("unable to add path between: " + previousFlow.flow.getName() + " and: " + flow.getName());
                }
            }
        }
    }
}

