/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade;

import cascading.cascade.CascadeException;
import cascading.flow.Flow;
import cascading.property.UnitOfWorkDef;
import cascading.tap.Tap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CascadeDef
extends UnitOfWorkDef<CascadeDef> {
    Map<String, Flow> flows = new HashMap<String, Flow>();
    int maxConcurrentFlows = -1;

    public static CascadeDef cascadeDef() {
        return new CascadeDef();
    }

    public Collection<Flow> getFlows() {
        return this.flows.values();
    }

    public Flow[] getFlowsArray() {
        return this.getFlows().toArray(new Flow[this.flows.size()]);
    }

    public CascadeDef addFlow(Flow flow) {
        if (flow == null) {
            return this;
        }
        if (this.flows.containsKey(flow.getName())) {
            throw new CascadeException("all flow names must be unique, found duplicate: " + flow.getName());
        }
        Collection<Tap> sinks = flow.getSinksCollection();
        for (Tap sink : sinks) {
            String fullIdentifier = sink.getFullIdentifier(flow.getConfig());
            for (Flow existingFlow : this.flows.values()) {
                Collection<Tap> existingSinks = existingFlow.getSinksCollection();
                for (Tap existingSink : existingSinks) {
                    if (!fullIdentifier.equals(existingSink.getFullIdentifier(existingFlow.getConfig()))) continue;
                    throw new CascadeException("the flow: " + flow.getName() + ", has a sink identifier: " + fullIdentifier + ", in common with the flow: " + existingFlow.getName());
                }
            }
        }
        this.flows.put(flow.getName(), flow);
        return this;
    }

    public CascadeDef addFlows(Flow ... flows) {
        for (Flow flow : flows) {
            this.addFlow(flow);
        }
        return this;
    }

    public CascadeDef addFlows(Collection<Flow> flows) {
        for (Flow flow : flows) {
            this.addFlow(flow);
        }
        return this;
    }

    public CascadeDef setMaxConcurrentFlows(int maxConcurrentFlows) {
        this.maxConcurrentFlows = maxConcurrentFlows;
        return this;
    }

    public int getMaxConcurrentFlows() {
        return this.maxConcurrentFlows;
    }
}

