/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade;

import cascading.cascade.BaseCascade;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeDef;
import cascading.cascade.planner.FlowGraph;
import cascading.cascade.planner.IdentifierGraph;
import cascading.flow.Flow;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;

public class CascadeConnector {
    private Map<Object, Object> properties;

    public CascadeConnector() {
    }

    @ConstructorProperties(value={"properties"})
    public CascadeConnector(Map<Object, Object> properties) {
        this.properties = properties;
    }

    public Cascade connect(Collection<Flow> flows) {
        return this.connect((String)null, flows.toArray(new Flow[flows.size()]));
    }

    public Cascade connect(String name, Collection<Flow> flows) {
        return this.connect(name, flows.toArray(new Flow[flows.size()]));
    }

    public Cascade connect(Flow ... flows) {
        return this.connect((String)null, flows);
    }

    public Cascade connect(String name, Flow ... flows) {
        name = name == null ? this.makeName(flows) : name;
        CascadeDef cascadeDef = ((CascadeDef)CascadeDef.cascadeDef().setName(name)).addFlows(flows);
        return this.connect(cascadeDef);
    }

    public Cascade connect(CascadeDef cascadeDef) {
        IdentifierGraph identifierGraph = new IdentifierGraph(cascadeDef.getFlowsArray());
        FlowGraph flowGraph = new FlowGraph(identifierGraph);
        return new BaseCascade(cascadeDef, this.properties, flowGraph, identifierGraph);
    }

    private String makeName(Flow[] flows) {
        Object[] names = new String[flows.length];
        for (int i = 0; i < flows.length; ++i) {
            names[i] = flows[i].getName();
        }
        return Util.join(names, "+");
    }
}

