/*
 * Decompiled with CFR 0.152.
 */
package cascading.cascade;

import cascading.CascadingException;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeDef;
import cascading.cascade.CascadeException;
import cascading.cascade.CascadeListener;
import cascading.cascade.planner.FlowGraph;
import cascading.cascade.planner.IdentifierGraph;
import cascading.cascade.planner.TapGraph;
import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.flow.FlowException;
import cascading.flow.FlowSkipStrategy;
import cascading.flow.Flows;
import cascading.management.CascadingServices;
import cascading.management.UnitOfWorkExecutorStrategy;
import cascading.management.UnitOfWorkSpawnStrategy;
import cascading.management.state.ClientState;
import cascading.property.PropertyUtil;
import cascading.stats.CascadeStats;
import cascading.tap.Tap;
import cascading.util.ProcessLogger;
import cascading.util.ShutdownUtil;
import cascading.util.Util;
import cascading.util.Version;
import cascading.util.jgrapht.EdgeNameProvider;
import cascading.util.jgrapht.IntegerNameProvider;
import cascading.util.jgrapht.VertexNameProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCascade
implements ProcessLogger,
Cascade {
    private static final Logger LOG = LoggerFactory.getLogger(Cascade.class);
    private String id;
    private final String name;
    private String tags;
    private final Map<Object, Object> properties;
    private List<SafeCascadeListener> listeners;
    private final FlowGraph flowGraph;
    private final IdentifierGraph identifierGraph;
    private final CascadeStats cascadeStats;
    private CascadingServices cascadingServices;
    private Thread thread;
    private Throwable throwable;
    private transient UnitOfWorkSpawnStrategy spawnStrategy = new UnitOfWorkExecutorStrategy();
    private ShutdownUtil.Hook shutdownHook;
    private final Map<String, Callable<Throwable>> jobsMap = new LinkedHashMap<String, Callable<Throwable>>();
    private boolean stop;
    private FlowSkipStrategy flowSkipStrategy = null;
    private int maxConcurrentFlows = 0;
    private transient TapGraph tapGraph;

    static int getMaxConcurrentFlows(Map<Object, Object> properties, int maxConcurrentFlows) {
        if (maxConcurrentFlows != -1) {
            return maxConcurrentFlows;
        }
        return Integer.parseInt(PropertyUtil.getProperty(properties, "cascading.cascade.maxconcurrentflows", "0"));
    }

    protected BaseCascade() {
        this.name = null;
        this.tags = null;
        this.properties = null;
        this.flowGraph = null;
        this.identifierGraph = null;
        this.cascadeStats = null;
    }

    BaseCascade(CascadeDef cascadeDef, Map<Object, Object> properties, FlowGraph flowGraph, IdentifierGraph identifierGraph) {
        this.name = cascadeDef.getName();
        this.tags = cascadeDef.getTags();
        this.properties = properties;
        this.flowGraph = flowGraph;
        this.identifierGraph = identifierGraph;
        this.cascadeStats = this.createPrepareCascadeStats();
        this.setIDOnFlow();
        this.maxConcurrentFlows = cascadeDef.getMaxConcurrentFlows();
        this.addListeners(this.getAllTaps());
    }

    private CascadeStats createPrepareCascadeStats() {
        CascadeStats cascadeStats = new CascadeStats(this, this.getClientState());
        cascadeStats.prepare();
        cascadeStats.markPending();
        return cascadeStats;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = Util.createUniqueID();
        }
        return this.id;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    void addListeners(Collection listeners) {
        for (Object listener : listeners) {
            if (!(listener instanceof CascadeListener)) continue;
            this.addListener((CascadeListener)listener);
        }
    }

    List<SafeCascadeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<SafeCascadeListener>();
        }
        return this.listeners;
    }

    @Override
    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    @Override
    public void addListener(CascadeListener cascadeListener) {
        this.getListeners().add(new SafeCascadeListener(cascadeListener));
    }

    @Override
    public boolean removeListener(CascadeListener flowListener) {
        return this.getListeners().remove(new SafeCascadeListener(flowListener));
    }

    private void fireOnCompleted() {
        if (this.hasListeners()) {
            if (this.isDebugEnabled()) {
                this.logDebug("firing onCompleted event: " + this.getListeners().size(), new Object[0]);
            }
            for (CascadeListener cascadeListener : this.getListeners()) {
                cascadeListener.onCompleted(this);
            }
        }
    }

    private void fireOnThrowable() {
        if (this.hasListeners()) {
            if (this.isDebugEnabled()) {
                this.logDebug("firing onThrowable event: " + this.getListeners().size(), new Object[0]);
            }
            boolean isHandled = false;
            for (CascadeListener cascadeListener : this.getListeners()) {
                isHandled = cascadeListener.onThrowable(this, this.throwable) || isHandled;
            }
            if (isHandled) {
                this.throwable = null;
            }
        }
    }

    protected void fireOnStopping() {
        if (this.hasListeners()) {
            if (this.isDebugEnabled()) {
                this.logDebug("firing onStopping event: " + this.getListeners().size(), new Object[0]);
            }
            for (CascadeListener cascadeListener : this.getListeners()) {
                cascadeListener.onStopping(this);
            }
        }
    }

    protected void fireOnStarting() {
        if (this.hasListeners()) {
            if (this.isDebugEnabled()) {
                this.logDebug("firing onStarting event: " + this.getListeners().size(), new Object[0]);
            }
            for (CascadeListener cascadeListener : this.getListeners()) {
                cascadeListener.onStarting(this);
            }
        }
    }

    private CascadingServices getCascadingServices() {
        if (this.cascadingServices == null) {
            this.cascadingServices = new CascadingServices(this.properties);
        }
        return this.cascadingServices;
    }

    private ClientState getClientState() {
        return this.getCascadingServices().createClientState(this.getID());
    }

    @Override
    public CascadeStats getCascadeStats() {
        return this.cascadeStats;
    }

    @Override
    public CascadeStats getStats() {
        return this.getCascadeStats();
    }

    private void setIDOnFlow() {
        for (Flow flow : this.getFlows()) {
            ((BaseFlow)flow).setCascade(this);
        }
    }

    protected FlowGraph getFlowGraph() {
        return this.flowGraph;
    }

    protected IdentifierGraph getIdentifierGraph() {
        return this.identifierGraph;
    }

    @Override
    public List<Flow> getFlows() {
        LinkedList<Flow> flows = new LinkedList<Flow>();
        TopologicalOrderIterator<Flow, Integer> topoIterator = this.flowGraph.getTopologicalIterator();
        while (topoIterator.hasNext()) {
            flows.add((Flow)topoIterator.next());
        }
        return flows;
    }

    @Override
    public List<Flow> findFlows(String regex) {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (Flow flow : this.getFlows()) {
            if (!flow.getName().matches(regex)) continue;
            flows.add(flow);
        }
        return flows;
    }

    @Override
    public Collection<Flow> getHeadFlows() {
        HashSet<Flow> flows = new HashSet<Flow>();
        for (Flow flow : this.flowGraph.vertexSet()) {
            if (this.flowGraph.inDegreeOf(flow) != 0) continue;
            flows.add(flow);
        }
        return flows;
    }

    @Override
    public Collection<Flow> getTailFlows() {
        HashSet<Flow> flows = new HashSet<Flow>();
        for (Flow flow : this.flowGraph.vertexSet()) {
            if (this.flowGraph.outDegreeOf(flow) != 0) continue;
            flows.add(flow);
        }
        return flows;
    }

    @Override
    public Collection<Flow> getIntermediateFlows() {
        HashSet<Flow> flows = new HashSet<Flow>(this.flowGraph.vertexSet());
        flows.removeAll(this.getHeadFlows());
        flows.removeAll(this.getTailFlows());
        return flows;
    }

    protected TapGraph getTapGraph() {
        if (this.tapGraph == null) {
            this.tapGraph = new TapGraph(this.flowGraph.vertexSet());
        }
        return this.tapGraph;
    }

    @Override
    public Collection<Tap> getSourceTaps() {
        TapGraph tapGraph = this.getTapGraph();
        HashSet<Tap> taps = new HashSet<Tap>();
        for (Tap tap : tapGraph.vertexSet()) {
            if (tapGraph.inDegreeOf(tap) != 0) continue;
            taps.add(tap);
        }
        return taps;
    }

    @Override
    public Collection<Tap> getSinkTaps() {
        TapGraph tapGraph = this.getTapGraph();
        HashSet<Tap> taps = new HashSet<Tap>();
        for (Tap tap : tapGraph.vertexSet()) {
            if (tapGraph.outDegreeOf(tap) != 0) continue;
            taps.add(tap);
        }
        return taps;
    }

    @Override
    public Collection<Tap> getCheckpointsTaps() {
        HashSet<Tap> taps = new HashSet<Tap>();
        for (Flow flow : this.getFlows()) {
            taps.addAll(flow.getCheckpointsCollection());
        }
        return taps;
    }

    @Override
    public Collection<Tap> getIntermediateTaps() {
        TapGraph tapGraph = this.getTapGraph();
        HashSet<Tap> taps = new HashSet<Tap>(tapGraph.vertexSet());
        taps.removeAll(this.getSourceTaps());
        taps.removeAll(this.getSinkTaps());
        return taps;
    }

    @Override
    public Collection<Tap> getAllTaps() {
        return new HashSet<Tap>(this.getTapGraph().vertexSet());
    }

    @Override
    public Collection<Flow> getSuccessorFlows(Flow flow) {
        return Graphs.successorListOf((Graph)this.flowGraph, (Object)flow);
    }

    @Override
    public Collection<Flow> getPredecessorFlows(Flow flow) {
        return Graphs.predecessorListOf((Graph)this.flowGraph, (Object)flow);
    }

    @Override
    public Collection<Flow> findFlowsSourcingFrom(String identifier) {
        try {
            return this.unwrapFlows(this.identifierGraph.outgoingEdgesOf(identifier));
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    @Override
    public Collection<Flow> findFlowsSinkingTo(String identifier) {
        try {
            return this.unwrapFlows(this.identifierGraph.incomingEdgesOf(identifier));
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    private Collection<Flow> unwrapFlows(Set<BaseFlow.FlowHolder> flowHolders) {
        HashSet<Flow> flows = new HashSet<Flow>();
        for (BaseFlow.FlowHolder flowHolder : flowHolders) {
            flows.add(flowHolder.flow);
        }
        return flows;
    }

    @Override
    public FlowSkipStrategy getFlowSkipStrategy() {
        return this.flowSkipStrategy;
    }

    @Override
    public FlowSkipStrategy setFlowSkipStrategy(FlowSkipStrategy flowSkipStrategy) {
        try {
            FlowSkipStrategy flowSkipStrategy2 = this.flowSkipStrategy;
            return flowSkipStrategy2;
        }
        finally {
            this.flowSkipStrategy = flowSkipStrategy;
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void start() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                BaseCascade.this.run();
            }
        }, ("cascade " + Util.toNull(this.getName())).trim());
        this.thread.start();
    }

    @Override
    public void complete() {
        this.start();
        try {
            try {
                this.thread.join();
            }
            catch (InterruptedException exception) {
                throw new FlowException("thread interrupted", exception);
            }
            if (this.throwable instanceof CascadingException) {
                throw (CascadingException)this.throwable;
            }
            if (this.throwable != null) {
                throw new CascadeException("unhandled exception", this.throwable);
            }
        }
        finally {
            this.thread = null;
            this.throwable = null;
            this.shutdownHook = null;
            this.cascadeStats.cleanup();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.fireOnStopping();
        if (!this.cascadeStats.isFinished()) {
            this.cascadeStats.markStopped();
        }
        this.internalStopAllFlows();
        this.handleExecutorShutdown();
        this.cascadeStats.cleanup();
    }

    @Override
    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Version.printBanner();
        if (LOG.isInfoEnabled()) {
            this.logInfo("starting", new Object[0]);
        }
        this.registerShutdownHook();
        try {
            int numLocalFlows;
            boolean runFlowsLocal;
            BaseCascade baseCascade = this;
            synchronized (baseCascade) {
                block27: {
                    if (!this.stop) break block27;
                    return;
                }
                this.cascadeStats.markStartedThenRunning();
            }
            this.fireOnStarting();
            this.initializeNewJobsMap();
            int numThreads = BaseCascade.getMaxConcurrentFlows(this.properties, this.maxConcurrentFlows);
            if (numThreads == 0) {
                numThreads = this.jobsMap.size();
            }
            boolean bl = runFlowsLocal = (numLocalFlows = this.numLocalFlows()) > 1;
            if (runFlowsLocal) {
                numThreads = 1;
            }
            if (this.isInfoEnabled()) {
                this.logInfo(" parallel execution of flows is enabled: " + (numThreads != 1), new Object[0]);
                this.logInfo(" executing total flows: " + this.jobsMap.size(), new Object[0]);
                this.logInfo(" allocating management threads: " + numThreads, new Object[0]);
            }
            List<Future<Throwable>> futures = this.spawnStrategy.start(this, numThreads, this.jobsMap.values());
            for (Future<Throwable> future : futures) {
                this.throwable = future.get();
                if (this.throwable == null) continue;
                if (!this.stop) {
                    if (!this.cascadeStats.isFinished()) {
                        this.cascadeStats.markFailed(this.throwable);
                    }
                    this.internalStopAllFlows();
                    this.fireOnThrowable();
                }
                this.handleExecutorShutdown();
                break;
            }
        }
        catch (Throwable throwable) {
            this.throwable = throwable;
        }
        finally {
            if (!this.cascadeStats.isFinished()) {
                this.cascadeStats.markSuccessful();
            }
            try {
                this.fireOnCompleted();
            }
            finally {
                this.deregisterShutdownHook();
            }
        }
    }

    private void registerShutdownHook() {
        if (!this.isStopJobsOnExit()) {
            return;
        }
        this.shutdownHook = new ShutdownUtil.Hook(){

            @Override
            public ShutdownUtil.Hook.Priority priority() {
                return ShutdownUtil.Hook.Priority.WORK_PARENT;
            }

            @Override
            public void execute() {
                BaseCascade.this.logInfo("shutdown hook calling stop on cascade", new Object[0]);
                BaseCascade.this.stop();
            }
        };
        ShutdownUtil.addHook(this.shutdownHook);
    }

    private void deregisterShutdownHook() {
        if (!this.isStopJobsOnExit() || this.stop) {
            return;
        }
        ShutdownUtil.removeHook(this.shutdownHook);
    }

    private boolean isStopJobsOnExit() {
        if (this.getFlows().isEmpty()) {
            return false;
        }
        return this.getFlows().get(0).isStopJobsOnExit();
    }

    private int numLocalFlows() {
        int countLocalJobs = 0;
        for (Flow flow : this.getFlows()) {
            if (!flow.stepsAreLocal()) continue;
            ++countLocalJobs;
        }
        return countLocalJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNewJobsMap() {
        Map<String, Callable<Throwable>> map = this.jobsMap;
        synchronized (map) {
            TopologicalOrderIterator<Flow, Integer> topoIterator = this.flowGraph.getTopologicalIterator();
            while (topoIterator.hasNext()) {
                Flow flow = (Flow)topoIterator.next();
                this.cascadeStats.addFlowStats(flow.getFlowStats());
                CascadeJob job = new CascadeJob(flow);
                this.jobsMap.put(flow.getName(), job);
                ArrayList<CascadeJob> predecessors = new ArrayList<CascadeJob>();
                for (Flow predecessor : Graphs.predecessorListOf((Graph)this.flowGraph, (Object)flow)) {
                    predecessors.add((CascadeJob)this.jobsMap.get(predecessor.getName()));
                }
                job.init(predecessors);
            }
        }
    }

    private void handleExecutorShutdown() {
        if (this.spawnStrategy.isCompleted(this)) {
            return;
        }
        this.logInfo("shutting down flow executor", new Object[0]);
        try {
            this.spawnStrategy.complete(this, 300, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logInfo("shutdown complete", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStopAllFlows() {
        this.logInfo("stopping all flows", new Object[0]);
        Map<String, Callable<Throwable>> map = this.jobsMap;
        synchronized (map) {
            ArrayList<Callable<Throwable>> jobs = new ArrayList<Callable<Throwable>>(this.jobsMap.values());
            Collections.reverse(jobs);
            for (Callable callable : jobs) {
                ((CascadeJob)callable).stop();
            }
        }
        this.logInfo("stopped all flows", new Object[0]);
    }

    @Override
    public void writeDOT(String filename) {
        this.printElementGraph(filename, this.identifierGraph);
    }

    protected void printElementGraph(String filename, SimpleDirectedGraph<String, BaseFlow.FlowHolder> graph) {
        try {
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, graph, new IntegerNameProvider(), new VertexNameProvider<String>(){

                @Override
                public String getVertexName(String object) {
                    return object.toString().replaceAll("\"", "'");
                }
            }, new EdgeNameProvider<BaseFlow.FlowHolder>(){

                @Override
                public String getEdgeName(BaseFlow.FlowHolder object) {
                    return object.flow.getName().replaceAll("\"", "'").replaceAll("\n", "\\\\n");
                }
            });
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            this.logError("failed printing graph to: {}, with exception: {}", filename, exception);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isInfoEnabled() {
        return LOG.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    @Override
    public void logInfo(String message, Object ... arguments) {
        LOG.info("[" + Util.truncate(this.getName(), 25) + "] " + message, arguments);
    }

    @Override
    public void logDebug(String message, Object ... arguments) {
        LOG.debug("[" + Util.truncate(this.getName(), 25) + "] " + message, arguments);
    }

    @Override
    public void logWarn(String message) {
        LOG.warn("[" + Util.truncate(this.getName(), 25) + "] " + message);
    }

    @Override
    public void logWarn(String message, Throwable throwable) {
        LOG.warn("[" + Util.truncate(this.getName(), 25) + "] " + message, throwable);
    }

    @Override
    public void logWarn(String message, Object ... arguments) {
        LOG.warn("[" + Util.truncate(this.getName(), 25) + "] " + message, arguments);
    }

    @Override
    public void logError(String message, Object ... arguments) {
        LOG.warn("[" + Util.truncate(this.getName(), 25) + "] " + message, arguments);
    }

    @Override
    public void logError(String message, Throwable throwable) {
        LOG.warn("[" + Util.truncate(this.getName(), 25) + "] " + message, throwable);
    }

    @Override
    public UnitOfWorkSpawnStrategy getSpawnStrategy() {
        return this.spawnStrategy;
    }

    @Override
    public void setSpawnStrategy(UnitOfWorkSpawnStrategy spawnStrategy) {
        this.spawnStrategy = spawnStrategy;
    }

    private class SafeCascadeListener
    implements CascadeListener {
        final CascadeListener cascadeListener;
        Throwable throwable;

        private SafeCascadeListener(CascadeListener cascadeListener) {
            this.cascadeListener = cascadeListener;
        }

        @Override
        public void onStarting(Cascade cascade) {
            try {
                this.cascadeListener.onStarting(cascade);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
        }

        @Override
        public void onStopping(Cascade cascade) {
            try {
                this.cascadeListener.onStopping(cascade);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
        }

        @Override
        public void onCompleted(Cascade cascade) {
            try {
                this.cascadeListener.onCompleted(cascade);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
        }

        @Override
        public boolean onThrowable(Cascade cascade, Throwable flowThrowable) {
            try {
                return this.cascadeListener.onThrowable(cascade, flowThrowable);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
                return false;
            }
        }

        private void handleThrowable(Throwable throwable) {
            this.throwable = throwable;
            BaseCascade.this.logWarn(String.format("cascade listener %s threw throwable", this.cascadeListener), throwable);
            BaseCascade.this.stop();
        }

        public boolean equals(Object object) {
            if (object instanceof SafeCascadeListener) {
                return this.cascadeListener.equals(((SafeCascadeListener)object).cascadeListener);
            }
            return this.cascadeListener.equals(object);
        }

        public int hashCode() {
            return this.cascadeListener.hashCode();
        }
    }

    protected class CascadeJob
    implements Callable<Throwable> {
        final Flow flow;
        private List<CascadeJob> predecessors;
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean stop = false;
        private boolean failed = false;

        public CascadeJob(Flow flow) {
            this.flow = flow;
        }

        public String getName() {
            return this.flow.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Throwable call() {
            try {
                block21: {
                    Iterator<CascadeJob> iterator;
                    for (CascadeJob predecessor : this.predecessors) {
                        if (predecessor.isSuccessful()) continue;
                        Throwable throwable = null;
                        return throwable;
                    }
                    if (this.stop || BaseCascade.this.cascadeStats.isFinished()) {
                        iterator = null;
                        return iterator;
                    }
                    if (LOG.isInfoEnabled()) {
                        BaseCascade.this.logInfo("starting flow: " + this.flow.getName(), new Object[0]);
                    }
                    if (!(BaseCascade.this.flowSkipStrategy == null ? this.flow.isSkipFlow() : BaseCascade.this.flowSkipStrategy.skipFlow(this.flow))) break block21;
                    if (LOG.isInfoEnabled()) {
                        BaseCascade.this.logInfo("skipping flow: " + this.flow.getName(), new Object[0]);
                    }
                    this.flow.getFlowStats().markSkipped();
                    Flows.fireOnCompleted(this.flow);
                    iterator = null;
                    this.flow.cleanup();
                    return iterator;
                }
                try {
                    this.flow.prepare();
                    this.flow.complete();
                    if (LOG.isInfoEnabled()) {
                        BaseCascade.this.logInfo("completed flow: " + this.flow.getName(), new Object[0]);
                    }
                    this.flow.cleanup();
                }
                catch (Throwable exception) {
                    try {
                        this.failed = true;
                        BaseCascade.this.logWarn("flow failed: " + this.flow.getName(), exception);
                        CascadeException cascadeException = new CascadeException("flow failed: " + this.flow.getName(), exception);
                        if (!BaseCascade.this.cascadeStats.isFinished()) {
                            BaseCascade.this.cascadeStats.markFailed(cascadeException);
                        }
                        CascadeException cascadeException2 = cascadeException;
                        this.flow.cleanup();
                        this.latch.countDown();
                        return cascadeException2;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.flow.cleanup();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            this.failed = true;
                            Throwable throwable3 = throwable2;
                            return throwable3;
                        }
                        finally {
                        }
                    }
                }
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        public void init(List<CascadeJob> predecessors) {
            this.predecessors = predecessors;
        }

        public void stop() {
            if (LOG.isInfoEnabled()) {
                BaseCascade.this.logInfo("stopping flow: " + this.flow.getName(), new Object[0]);
            }
            this.stop = true;
            if (this.flow != null) {
                this.flow.stop();
            }
        }

        public boolean isSuccessful() {
            try {
                this.latch.await();
                return this.flow != null && !this.failed && !this.stop;
            }
            catch (InterruptedException exception) {
                BaseCascade.this.logWarn("latch interrupted", exception);
                return false;
            }
        }
    }
}

