/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.util.Trie;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class TrieTest {
    @Test
    public void testGetPrefix() {
        Trie trie = new Trie();
        trie.put("a", (Serializable)((Object)"a"));
        trie.put("aa", (Serializable)((Object)"aa"));
        trie.put("aaa", (Serializable)((Object)"aaa"));
        trie.put("ab", (Serializable)((Object)"ab"));
        trie.put("abb", (Serializable)((Object)"abb"));
        trie.put("aabb", (Serializable)((Object)"aabb"));
        Assert.assertEquals(null, (Object)trie.get(""));
        Assert.assertEquals((Object)"a", (Object)trie.get("a"));
        Assert.assertEquals((Object)"a", (Object)trie.get("azzz"));
        Assert.assertEquals((Object)"aa", (Object)trie.get("aa"));
        Assert.assertEquals((Object)"aaa", (Object)trie.get("aaa"));
        Assert.assertEquals((Object)"ab", (Object)trie.get("ab"));
        Assert.assertEquals((Object)"abb", (Object)trie.get("abb"));
        Assert.assertEquals((Object)"aabb", (Object)trie.get("aabb"));
        Assert.assertEquals((Object)"aabb", (Object)trie.get("aabbcdef"));
        Assert.assertNull((Object)trie.get("zzz"));
        Assert.assertNull((Object)trie.get(""));
    }

    @Test
    public void testHasPrefix() {
        Trie trie = new Trie();
        trie.put("a", (Serializable)((Object)"a"));
        trie.put("aa", (Serializable)((Object)"aa"));
        trie.put("aaa", (Serializable)((Object)"aaa"));
        trie.put("ab", (Serializable)((Object)"ab"));
        trie.put("abb", (Serializable)((Object)"abb"));
        trie.put("aabb", (Serializable)((Object)"aabb"));
        Assert.assertTrue((boolean)trie.hasPrefix("a"));
        Assert.assertTrue((boolean)trie.hasPrefix("aa"));
        Assert.assertTrue((boolean)trie.hasPrefix("aaa"));
        Assert.assertFalse((boolean)trie.hasPrefix(""));
        Assert.assertFalse((boolean)trie.hasPrefix("5"));
        Assert.assertFalse((boolean)trie.hasPrefix("zzzz"));
    }

    @Test
    public void testGetCommonPrefix() {
        Trie trie = new Trie();
        trie.put("a", (Serializable)((Object)"a"));
        trie.put("aa", (Serializable)((Object)"aa"));
        trie.put("aaa", (Serializable)((Object)"aaa"));
        trie.put("aabb", (Serializable)((Object)"aabb"));
        trie.put("aaabb", (Serializable)((Object)"aaabb"));
        trie.put("aacbb", (Serializable)((Object)"aacbb"));
        Assert.assertEquals((Object)"aa", (Object)trie.getCommonPrefix());
    }

    @Test
    public void testGetCommonPrefixNone() {
        Trie trie = new Trie();
        trie.put("a", (Serializable)((Object)"a"));
        trie.put("b", (Serializable)((Object)"a"));
        trie.put("c", (Serializable)((Object)"a"));
        trie.put("e", (Serializable)((Object)"a"));
        trie.put("f", (Serializable)((Object)"a"));
        Assert.assertEquals((Object)"", (Object)trie.getCommonPrefix());
    }
}

