/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.util.cache.CacheEvictionCallback;
import cascading.util.cache.CascadingCache;
import cascading.util.cache.DirectMappedCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DirectMappedCacheTest {
    @Test
    public void testDirectMappedCache() {
        CascadingCache<Object, Object> cache = this.getDirectMappedCache(10, CacheEvictionCallback.NULL);
        Assert.assertNotNull(cache);
        Assert.assertEquals((long)0L, (long)cache.size());
        String key = "abc";
        String value = "def";
        cache.put((Object)key, (Object)value);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertTrue((boolean)cache.containsKey((Object)key));
        Assert.assertTrue((boolean)cache.containsValue((Object)value));
        Assert.assertSame((Object)value, (Object)cache.get((Object)key));
        Set keys = cache.keySet();
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains(key));
        Collection values = cache.values();
        Assert.assertTrue((boolean)values.contains(value));
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
        Assert.assertFalse((boolean)cache.containsValue((Object)value));
    }

    @Test
    public void testDirectMappedCacheEviction() {
        TestCacheEvictionCallBack callBack = new TestCacheEvictionCallBack();
        CascadingCache<Object, Object> cache = this.getDirectMappedCache(10, callBack);
        Collider key = new Collider("key");
        String value = "value";
        cache.put((Object)key, (Object)value);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)callBack.evictionCounter);
        Collider secondKey = new Collider("anotherKey");
        cache.put((Object)secondKey, (Object)value);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)1L, (long)callBack.evictionCounter);
        Assert.assertTrue((boolean)cache.containsKey((Object)secondKey));
        Assert.assertTrue((boolean)cache.containsValue((Object)value));
        Assert.assertSame((Object)value, (Object)cache.get((Object)secondKey));
        Assert.assertTrue((boolean)callBack.evictedEntries.get(0).getKey().equals(key));
        Assert.assertTrue((boolean)callBack.evictedEntries.get(0).getValue().equals(value));
    }

    @Test
    public void testMaxCapacity() {
        TestCacheEvictionCallBack callBack = new TestCacheEvictionCallBack();
        CascadingCache<Object, Object> cache = this.getDirectMappedCache(10, callBack);
        for (int i = 0; i < cache.getCapacity() + 10; ++i) {
            cache.put((Object)i, (Object)i);
        }
        Assert.assertEquals((long)cache.getCapacity(), (long)cache.size());
        Assert.assertEquals((long)10L, (long)callBack.evictionCounter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullKey() {
        CascadingCache<Object, Object> cache = this.getDirectMappedCache(10, CacheEvictionCallback.NULL);
        cache.put(null, (Object)"a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullValue() {
        CascadingCache<Object, Object> cache = this.getDirectMappedCache(10, CacheEvictionCallback.NULL);
        cache.put((Object)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContainsKeyNull() {
        CascadingCache<Object, Object> cache = this.getDirectMappedCache(10, CacheEvictionCallback.NULL);
        cache.containsKey(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContainsValueNull() {
        CascadingCache<Object, Object> cache = this.getDirectMappedCache(10, CacheEvictionCallback.NULL);
        cache.containsValue(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateCacheNegative() {
        this.getDirectMappedCache(-1, CacheEvictionCallback.NULL);
    }

    private CascadingCache<Object, Object> getDirectMappedCache(int capacity, CacheEvictionCallback cacheEvictionCallback) {
        DirectMappedCache map = new DirectMappedCache();
        map.setCacheEvictionCallback(cacheEvictionCallback);
        map.setCapacity(capacity);
        map.initialize();
        return map;
    }

    class Collider {
        private final String value;

        Collider(String value) {
            this.value = value;
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Collider collider = (Collider)object;
            return !(this.value != null ? !this.value.equals(collider.value) : collider.value != null);
        }
    }

    class TestCacheEvictionCallBack
    implements CacheEvictionCallback<Object, Object> {
        int evictionCounter = 0;
        List<Map.Entry<Object, Object>> evictedEntries = new ArrayList<Map.Entry<Object, Object>>();

        TestCacheEvictionCallBack() {
        }

        public void evict(Map.Entry<Object, Object> entry) {
            Assert.assertNotNull(entry);
            ++this.evictionCounter;
            this.evictedEntries.add(entry);
        }
    }
}

