/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.CascadingTestCase;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.io.TuplePair;
import java.lang.reflect.Type;
import org.junit.Test;

public class TupleTest
extends CascadingTestCase {
    private Tuple tuple;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tuple = new Tuple();
        this.tuple.add((Comparable)((Object)"a"));
        this.tuple.add((Comparable)((Object)"b"));
        this.tuple.add((Comparable)((Object)"c"));
        this.tuple.add((Comparable)((Object)"d"));
        this.tuple.add((Comparable)((Object)"d"));
    }

    @Test
    public void testHas() {
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"a", (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"b", (Object)this.tuple.getObject(1));
    }

    @Test
    public void testGet() {
        Tuple aTuple = this.tuple.get(new int[]{0});
        TupleTest.assertEquals((String)"not equal: aTuple.size()", (int)1, (int)aTuple.size());
        TupleTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"a", (Object)aTuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"a", (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"b", (Object)this.tuple.getObject(1));
    }

    @Test
    public void testGetNull() {
        Tuple aTuple = this.tuple.get((int[])null);
        TupleTest.assertEquals((String)"not equal: aTuple.size()", (int)5, (int)aTuple.size());
        TupleTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"a", (Object)aTuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: aTuple.get( 1 )", (Object)"b", (Object)aTuple.getObject(1));
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"a", (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"b", (Object)this.tuple.getObject(1));
    }

    @Test
    public void testRemove() {
        Tuple aTuple = this.tuple.remove(new int[]{0});
        TupleTest.assertEquals((String)"not equal: aTuple.size()", (int)1, (int)aTuple.size());
        TupleTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"a", (Object)aTuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)4, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"b", (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"c", (Object)this.tuple.getObject(1));
    }

    @Test
    public void testRemove2() {
        Tuple aTuple = this.tuple.remove(new int[]{2, 4});
        TupleTest.assertEquals((String)"not equal: aTuple.size()", (int)2, (int)aTuple.size());
        TupleTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"c", (Object)aTuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)3, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"a", (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"b", (Object)this.tuple.getObject(1));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"d", (Object)this.tuple.getObject(2));
    }

    @Test
    public void testLeave() {
        Tuple aTuple = this.tuple.leave(new int[]{0});
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)1, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"a", (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: aTuple.size()", (int)4, (int)aTuple.size());
        TupleTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"b", (Object)aTuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"c", (Object)aTuple.getObject(1));
    }

    @Test
    public void testExtractSet() {
        Tuple aTuple = this.tuple.extract(new int[]{0});
        TupleTest.assertEquals((String)"not equal: aTuple.size()", (int)1, (int)aTuple.size());
        TupleTest.assertEquals((String)"not equal: aTuple.get( 0 )", (Object)"a", (Object)aTuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", null, (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"b", (Object)this.tuple.getObject(1));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"c", (Object)this.tuple.getObject(2));
        this.tuple.set(new int[]{0}, new Tuple(new Object[]{"A"}));
        TupleTest.assertEquals((String)"not equal: tuple.size()", (int)5, (int)this.tuple.size());
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"A", (Object)this.tuple.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get( 0 )", (Object)"b", (Object)this.tuple.getObject(1));
        TupleTest.assertEquals((String)"not equal: tuple.get( 1 )", (Object)"c", (Object)this.tuple.getObject(2));
    }

    @Test
    public void testEqualPrimitive() {
        TupleTest.assertEquals((String)"not equal: tuple", (Object)new Tuple(new Object[]{1}), (Object)new Tuple(new Object[]{1}));
        TupleTest.assertEquals((String)"not equal: tuple", (Object)new Tuple(new Object[]{"1"}), (Object)new Tuple(new Object[]{"1"}));
        TupleTest.assertEquals((String)"not equal: tuple", (Object)new Tuple(new Object[]{1, 2}), (Object)new Tuple(new Object[]{1, 2}));
        TupleTest.assertEquals((String)"not equal: tuple", (Object)new Tuple(new Object[]{"1", 2}), (Object)new Tuple(new Object[]{"1", 2}));
    }

    @Test
    public void testEqual() {
        Tuple aTuple = new Tuple(this.tuple);
        TupleTest.assertEquals((String)"not equal: tuple", (Object)aTuple, (Object)this.tuple);
        aTuple.remove(new int[]{0});
        TupleTest.assertNotSame((String)"equal: tuple", (Object)aTuple, (Object)this.tuple);
        aTuple = new Tuple(new Object[]{this.tuple, "a"});
        Tuple bTuple = new Tuple(new Object[]{this.tuple, "a"});
        TupleTest.assertEquals((String)"not equal: tuple", (Object)aTuple, (Object)bTuple);
        aTuple = new Tuple(new Object[]{"a", new Tuple(this.tuple), "a"});
        bTuple = new Tuple(new Object[]{"a", new Tuple(this.tuple), "a"});
        TupleTest.assertEquals((String)"not equal: tuple", (Object)aTuple, (Object)bTuple);
        TupleTest.assertEquals((String)"not equal: hash code", (int)aTuple.hashCode(), (int)bTuple.hashCode());
    }

    @Test
    public void testCompare() {
        Tuple aTuple = new Tuple(new Object[]{"a"});
        Tuple bTuple = new Tuple(new Object[]{"b"});
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) < 0 ? 1 : 0) != 0);
        TupleTest.assertTrue((String)"not less than: bTuple < aTuple", (bTuple.compareTo(aTuple) > 0 ? 1 : 0) != 0);
        aTuple.add((Comparable)((Object)"b"));
        TupleTest.assertTrue((String)"not greater than: aTuple > bTuple", (aTuple.compareTo(bTuple) > 0 ? 1 : 0) != 0);
        aTuple = new Tuple(new Object[]{bTuple, "a"});
        TupleTest.assertTrue((String)"not greater than: aTuple > bTuple", (aTuple.compareTo(bTuple) > 0 ? 1 : 0) != 0);
        bTuple = new Tuple(new Object[]{bTuple, "b"});
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare2() {
        Tuple aTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", "3.0", "LisaRose", "3.0"});
        Tuple bTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", "3.0", "LisaRose", "3.0"});
        TupleTest.assertEquals((String)"not equal: aTuple", (Object)bTuple, (Object)aTuple);
        TupleTest.assertTrue((String)"not equal than: aTuple = bTuple", (aTuple.compareTo(bTuple) == 0 ? 1 : 0) != 0);
        bTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", "3.0", "LisaRose", "2.0"});
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) > 0 ? 1 : 0) != 0);
        TupleTest.assertTrue((String)"not less than: bTuple > aTuple", (bTuple.compareTo(aTuple) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare3() {
        Tuple aTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", 3.0, "LisaRose", 3.0});
        Tuple bTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", 3.0, "LisaRose", 3.0});
        TupleTest.assertEquals((String)"not equal: aTuple", (Object)bTuple, (Object)aTuple);
        TupleTest.assertTrue((String)"not equal than: aTuple = bTuple", (aTuple.compareTo(bTuple) == 0 ? 1 : 0) != 0);
        bTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", 3.0, "LisaRose", 2.0});
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) > 0 ? 1 : 0) != 0);
        TupleTest.assertTrue((String)"not less than: bTuple > aTuple", (bTuple.compareTo(aTuple) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare4() {
        Tuple aTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", null, "LisaRose", null});
        Tuple bTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", null, "LisaRose", null});
        TupleTest.assertEquals((String)"not equal: aTuple", (Object)bTuple, (Object)aTuple);
        TupleTest.assertTrue((String)"not equal than: aTuple = bTuple", (aTuple.compareTo(bTuple) == 0 ? 1 : 0) != 0);
        bTuple = new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", null, "Z", null});
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) == "LisaRose".compareTo("Z") ? 1 : 0) != 0);
        TupleTest.assertTrue((String)"not less than: bTuple > aTuple", (bTuple.compareTo(aTuple) == "Z".compareTo("LisaRose") ? 1 : 0) != 0);
    }

    @Test
    public void testPairCompare() {
        TuplePair aTuple = new TuplePair(new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", 3.0, "LisaRose", 3.0}), new Tuple(new Object[]{"a"}));
        TuplePair bTuple = new TuplePair(new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", 3.0, "LisaRose", 3.0}), new Tuple(new Object[]{"a"}));
        TupleTest.assertEquals((String)"not equal: aTuple", (Object)bTuple, (Object)aTuple);
        TupleTest.assertTrue((String)"not equal than: aTuple = bTuple", (aTuple.compareTo(bTuple) == 0 ? 1 : 0) != 0);
        bTuple = new TuplePair(new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", 2.0, "LisaRose", 3.0}), new Tuple(new Object[]{"a"}));
        TupleTest.assertTrue((String)"not less than: aTuple > bTuple", (aTuple.compareTo(bTuple) > 0 ? 1 : 0) != 0);
        TupleTest.assertTrue((String)"not less than: bTuple < aTuple", (bTuple.compareTo(aTuple) < 0 ? 1 : 0) != 0);
        bTuple = new TuplePair(new Tuple(new Object[]{"Just My Luck", "ClaudiaPuig", 3.0, "LisaRose", 3.0}), new Tuple(new Object[]{"b"}));
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) < 0 ? 1 : 0) != 0);
        TupleTest.assertTrue((String)"not less than: bTuple > aTuple", (bTuple.compareTo(aTuple) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareNull() {
        Tuple aTuple = new Tuple(new Object[]{"a", null, "c"});
        Tuple bTuple = new Tuple(new Object[]{"a", "b", null});
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) < 0 ? 1 : 0) != 0);
        TupleTest.assertTrue((String)"not less than: bTuple < aTuple", (bTuple.compareTo(aTuple) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetAll() {
        int i;
        Tuple aTuple = new Tuple(this.tuple);
        int size = aTuple.size() + this.tuple.size();
        Tuple result = Tuple.size((int)size);
        result.setAll(new Tuple[]{aTuple, this.tuple});
        TupleTest.assertEquals((String)"wrong size", (int)size, (int)result.size());
        result.setAll(new Tuple[]{aTuple, this.tuple});
        TupleTest.assertEquals((String)"wrong size", (int)size, (int)result.size());
        int count = 0;
        for (i = 0; i < aTuple.size(); ++i) {
            TupleTest.assertEquals((String)("wrong value on: " + count), (Object)aTuple.getObject(i), (Object)result.getObject(count++));
        }
        for (i = 0; i < this.tuple.size(); ++i) {
            TupleTest.assertEquals((String)("wrong value on: " + count), (Object)this.tuple.getObject(i), (Object)result.getObject(count++));
        }
    }

    @Test
    public void testSetCoerce() {
        Fields fieldsA = new Fields(new Comparable[]{"a", "b", "c"}).applyTypes(new Type[]{String.class, String.class, String.class});
        Tuple tupleA = new Tuple(new Object[]{"0", "1", "2"});
        Fields fieldsB = new Fields(new Comparable[]{"c", "b"}).applyTypes(new Type[]{Integer.class, Integer.class});
        Tuple tupleB = new Tuple(new Object[]{-2, -1});
        tupleA.set(fieldsA, fieldsB, tupleB);
        TupleTest.assertEquals((String)"wrong size", (int)3, (int)tupleA.size());
        TupleTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"0", (Object)tupleA.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"-1", (Object)tupleA.getObject(1));
        TupleTest.assertEquals((String)"not equal: tuple.get(2)", (Object)"-2", (Object)tupleA.getObject(2));
    }

    @Test
    public void testSetCoerce2() {
        Fields fieldsA = new Fields(new Comparable[]{"a", "b", "c"}).applyTypes(new Type[]{Long.class, String.class, Integer.class});
        Tuple tupleA = new Tuple(new Object[]{0L, "1", 1});
        Fields fieldsB = new Fields(new Comparable[]{"c", "b", "a"}).applyTypes(new Type[]{Boolean.class, Integer.class, Float.class});
        Tuple tupleB = new Tuple(new Object[]{true, -2, Float.valueOf(-1.0f)});
        tupleA.set(fieldsA, fieldsB, tupleB);
        TupleTest.assertEquals((String)"wrong size", (int)3, (int)tupleA.size());
        TupleTest.assertEquals((String)"not equal: tuple.get(0)", (Object)-1L, (Object)tupleA.getObject(0));
        TupleTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"-2", (Object)tupleA.getObject(1));
        TupleTest.assertEquals((String)"not equal: tuple.get(2)", (Object)1, (Object)tupleA.getObject(2));
    }
}

