/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.CascadingTestCase;
import cascading.TestFunction;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import org.junit.Test;

public class PipeParamTest
extends CascadingTestCase {
    Fields[] ARGS_PASS = new Fields[]{new Fields(new Comparable[]{"x"}), Fields.ALL, Fields.GROUP, Fields.VALUES};
    Fields[] FUNCS_PASS = new Fields[]{new Fields(new Comparable[]{"y"}), Fields.UNKNOWN, Fields.ALL, Fields.GROUP, Fields.VALUES, Fields.ARGS};
    Fields[] OUTS_PASS = new Fields[]{new Fields(new Comparable[]{"y"}), Fields.RESULTS, Fields.ALL};
    Fields[] ARGS_FAIL = new Fields[]{Fields.UNKNOWN, Fields.ARGS, Fields.RESULTS};
    Fields[] FUNCS_FAIL = new Fields[]{Fields.RESULTS};
    Fields[] OUTS_FAIL = new Fields[]{Fields.UNKNOWN, Fields.ARGS, Fields.GROUP, Fields.VALUES};

    @Test
    public void testEachPassCtor() {
        for (Fields arg : this.ARGS_PASS) {
            for (Fields func : this.FUNCS_PASS) {
                for (Fields out : this.OUTS_PASS) {
                    try {
                        new Each(new Pipe("test"), arg, (Function)new TestFunction(func, new Tuple(new Object[]{"value"})), out);
                    }
                    catch (Exception exception) {
                        PipeParamTest.fail((String)("failed on: " + arg.print() + " " + func.print() + " " + out.print()));
                    }
                }
            }
        }
    }

    @Test
    public void testEachFailCtor() {
        for (Fields arg : this.ARGS_FAIL) {
            for (Fields func : this.FUNCS_PASS) {
                for (Fields out : this.OUTS_PASS) {
                    try {
                        new Each(new Pipe("test"), arg, (Function)new TestFunction(func, new Tuple(new Object[]{"value"})), out);
                        PipeParamTest.fail((String)("failed on: " + arg.print() + " " + func.print() + " " + out.print()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        for (Fields arg : this.ARGS_PASS) {
            for (Fields func : this.FUNCS_FAIL) {
                for (Fields out : this.OUTS_PASS) {
                    try {
                        new Each(new Pipe("test"), arg, (Function)new TestFunction(func, new Tuple(new Object[]{"value"})), out);
                        PipeParamTest.fail((String)("failed on: " + arg.print() + " " + func.print() + " " + out.print()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        for (Fields arg : this.ARGS_PASS) {
            for (Fields func : this.FUNCS_PASS) {
                for (Fields out : this.OUTS_FAIL) {
                    try {
                        new Each(new Pipe("test"), arg, (Function)new TestFunction(func, new Tuple(new Object[]{"value"})), out);
                        PipeParamTest.fail((String)("failed on: " + arg.print() + " " + func.print() + " " + out.print()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Test
    public void testGetFirst() {
        Pipe pipeFirst = new Pipe("first");
        Pipe pipe = new Pipe(pipeFirst);
        pipe = new Pipe(pipe);
        pipe = new Pipe(pipe);
        pipe = new Pipe(pipe);
        PipeParamTest.assertEquals((Object)pipeFirst, (Object)pipe.getHeads()[0]);
    }

    @Test
    public void testGetFirstSplit() {
        Pipe pipeFirst = new Pipe("first");
        Pipe pipe = new Pipe(pipeFirst);
        Pipe pipeA = new Pipe(pipe);
        Pipe pipeB = new Pipe(pipe);
        pipeA = new Pipe(pipeA);
        pipeB = new Pipe(pipeB);
        PipeParamTest.assertEquals((Object)pipeFirst, (Object)pipeA.getHeads()[0]);
        PipeParamTest.assertEquals((Object)pipeFirst, (Object)pipeB.getHeads()[0]);
    }

    @Test
    public void testGetFirstJoin() {
        Pipe pipeFirst = new Pipe("first");
        Pipe pipeSecond = new Pipe("second");
        CoGroup pipe = new CoGroup(new Pipe[]{pipeFirst, pipeSecond});
        pipe = new Pipe((Pipe)pipe);
        pipe = new Pipe((Pipe)pipe);
        PipeParamTest.assertTrue(((pipe = new Pipe((Pipe)pipe)).getHeads()[0] == pipeFirst || pipe.getHeads()[0] == pipeSecond ? 1 : 0) != 0);
    }

    @Test
    public void testGetNames() {
        Object pipe = new Pipe("first");
        pipe = new NestedSubAssembly((Pipe)pipe);
        Pipe pipe1 = new Pipe("fifth", ((SubAssembly)pipe).getTails()[0]);
        Pipe pipe2 = new Pipe("sixth", ((SubAssembly)pipe).getTails()[1]);
        PipeParamTest.assertEquals((int)6, (int)Pipe.names((Pipe[])new Pipe[]{pipe1, pipe2}).length);
        PipeParamTest.assertEquals((int)1, (int)Pipe.named((String)"second", (Pipe[])new Pipe[]{pipe1, pipe2}).length);
        PipeParamTest.assertEquals((int)1, (int)Pipe.named((String)"sixth", (Pipe[])new Pipe[]{pipe1, pipe2}).length);
        PipeParamTest.assertEquals((Object)pipe2, (Object)Pipe.named((String)"sixth", (Pipe[])new Pipe[]{pipe1, pipe2})[0]);
    }

    private static class NestedSubAssembly
    extends SubAssembly {
        private NestedSubAssembly(Pipe pipe) {
            Pipe pipe1 = new Pipe("second", pipe);
            Pipe pipe2 = new Pipe("third", pipe);
            pipe2 = new Each(pipe2, (Function)new Identity());
            pipe2 = new Pipe("fourth", pipe2);
            this.setTails(new Pipe[]{pipe1, pipe2});
        }
    }
}

