/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.CascadingTestCase;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexParser;
import cascading.operation.regex.RegexReplace;
import cascading.operation.regex.RegexSplitGenerator;
import cascading.operation.regex.RegexSplitter;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleListCollector;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.junit.Test;

public class RegexesTest
extends CascadingTestCase {
    @Test
    public void testSplitter() throws IOException {
        RegexSplitter splitter = new RegexSplitter("\t");
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.UNKNOWN;
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
        RegexesTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"bar", (Object)tuple.getObject(1));
    }

    @Test
    public void testSplitterGenerator() throws IOException {
        RegexSplitGenerator splitter = new RegexSplitGenerator(new Fields(new Comparable[]{"word"}), "\\s+");
        Tuple arguments = new Tuple(new Object[]{"foo\t  bar"});
        Fields resultFields = new Fields(new Comparable[]{"word"});
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)2, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        RegexesTest.assertEquals((String)"not equal: iterator.next().get(0)", (Object)"foo", (Object)iterator.next().getObject(0));
        RegexesTest.assertEquals((String)"not equal: iterator.next().get(0)", (Object)"bar", (Object)iterator.next().getObject(0));
    }

    @Test
    public void testReplace() throws IOException {
        RegexReplace splitter = new RegexReplace(new Fields(new Comparable[]{"words"}), "\\s+", "-", true);
        Tuple arguments = new Tuple(new Object[]{"foo\t bar"});
        Fields resultFields = Fields.UNKNOWN;
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo-bar", (Object)tuple.getObject(0));
    }

    @Test
    public void testParserDeclared() throws IOException {
        RegexParser splitter = new RegexParser(new Fields(new Comparable[]{"lhs", "rhs"}), "(\\S+)\\s+(\\S+)", new int[]{1, 2});
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.size((int)2);
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
        RegexesTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"bar", (Object)tuple.getObject(1));
    }

    @Test
    public void testParserDeclared2() throws IOException {
        RegexParser splitter = new RegexParser(new Fields(new Comparable[]{"lhs", "rhs"}), "(\\S+)\\s+(\\S+)");
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.size((int)2);
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
        RegexesTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"bar", (Object)tuple.getObject(1));
    }

    @Test
    public void testParserDeclared3() throws IOException {
        RegexParser splitter = new RegexParser(new Fields(new Comparable[]{"lhs"}), "(\\S+)\\s+\\S+");
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.size((int)1);
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"wrong tupel size", (int)1, (int)tuple.size());
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
    }

    @Test
    public void testParserDeclared4() throws IOException {
        RegexParser splitter = new RegexParser(new Fields(new Comparable[]{"lhs"}), "\\S+\\s+\\S+");
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.size((int)1);
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"wrong tupel size", (int)1, (int)tuple.size());
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo\tbar", (Object)tuple.getObject(0));
    }

    @Test
    public void testParserDeclared5() throws IOException {
        RegexParser splitter = new RegexParser(new Fields(new Comparable[]{"bar"}), "^GET /foo\\?bar=([^\\&]+)&");
        Tuple arguments = new Tuple(new Object[]{"GET /foo?bar=z123&baz=2"});
        Fields resultFields = Fields.size((int)1);
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"wrong tuple size", (int)1, (int)tuple.size());
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"z123", (Object)tuple.getObject(0));
    }

    @Test
    public void testParserDeclared6() throws IOException {
        RegexParser splitter = new RegexParser(new Fields(new Comparable[]{"lhs"}), "(\\S+)\\s+\\S+", new int[]{1});
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.size((int)1);
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"wrong tupel size", (int)1, (int)tuple.size());
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
    }

    @Test
    public void testParserUnknown() throws IOException {
        RegexParser splitter = new RegexParser(Fields.UNKNOWN, "(\\S+)\\s+(\\S+)", new int[]{1, 2});
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.UNKNOWN;
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
        RegexesTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"bar", (Object)tuple.getObject(1));
    }

    @Test
    public void testParserUnknown2() throws IOException {
        RegexParser splitter = new RegexParser("(\\S+)\\s+(\\S+)", new int[]{1, 2});
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.UNKNOWN;
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
        RegexesTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"bar", (Object)tuple.getObject(1));
    }

    @Test
    public void testParserUnknown3() throws IOException {
        RegexParser splitter = new RegexParser("(\\S+)\\s+(\\S+)");
        Tuple arguments = new Tuple(new Object[]{"foo\tbar"});
        Fields resultFields = Fields.UNKNOWN;
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)"foo", (Object)tuple.getObject(0));
        RegexesTest.assertEquals((String)"not equal: tuple.get(1)", (Object)"bar", (Object)tuple.getObject(1));
    }

    @Test
    public void testFilter() {
        RegexFilter filter = new RegexFilter("foo\tbar");
        Tuple arguments = new Tuple(new Object[]{"foo", "bar"});
        boolean isRemove = RegexesTest.invokeFilter((Filter)filter, arguments);
        RegexesTest.assertTrue((String)"was not remove", (!isRemove ? 1 : 0) != 0);
    }

    @Test
    public void testParserDeclaredTypes() throws IOException {
        RegexParser splitter = new RegexParser(new Fields(new Comparable[]{"lhs", "rhs"}).applyTypes(new Type[]{Integer.class, Integer.class}), "(\\S+)\\s+(\\S+)", new int[]{1, 2});
        Tuple arguments = new Tuple(new Object[]{"6666\t7777"});
        Fields resultFields = Fields.size((int)2);
        TupleListCollector collector = RegexesTest.invokeFunction((Function)splitter, arguments, resultFields);
        RegexesTest.assertEquals((String)"wrong size", (int)1, (int)collector.size());
        Iterator<Tuple> iterator = collector.iterator();
        Tuple tuple = iterator.next();
        RegexesTest.assertEquals((String)"not equal: tuple.get(0).getClass()", Integer.class, tuple.getObject(0).getClass());
        RegexesTest.assertEquals((String)"not equal: tuple.get(1).getClass()", Integer.class, tuple.getObject(1).getClass());
        RegexesTest.assertEquals((String)"not equal: tuple.get(0)", (Object)6666, (Object)tuple.getObject(0));
        RegexesTest.assertEquals((String)"not equal: tuple.get(1)", (Object)7777, (Object)tuple.getObject(1));
    }
}

