/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.function;

import cascading.CascadingTestCase;
import cascading.operation.CompositeFunction;
import cascading.operation.Function;
import cascading.pipe.assembly.AggregateBy;
import cascading.pipe.assembly.AggregateByLocally;
import cascading.pipe.assembly.CountBy;
import cascading.pipe.assembly.CountByLocally;
import cascading.pipe.assembly.SumBy;
import cascading.pipe.assembly.SumByLocally;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Test;

public class FunctionsTest
extends CascadingTestCase {
    @Test
    public void testPartialCounts() {
        AggregateBy.CompositeFunction function = new AggregateBy.CompositeFunction(new Fields(new Comparable[]{"value"}), Fields.ALL, (CompositeFunction.CoFunction)new CountBy.CountPartials(new Fields(new Comparable[]{"count"})), 2);
        Fields incoming = new Fields(new Comparable[]{"value"});
        TupleEntry[] tuples = new TupleEntry[]{new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"b"})), new TupleEntry(incoming, new Tuple(new Object[]{"b"})), new TupleEntry(incoming, new Tuple(new Object[]{"c"})), new TupleEntry(incoming, new Tuple(new Object[]{"c"})), new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"d"})), new TupleEntry(incoming, new Tuple(new Object[]{"d"}))};
        ArrayList<Tuple> expected = new ArrayList<Tuple>();
        expected.add(new Tuple(new Object[]{"a", 2L}));
        expected.add(new Tuple(new Object[]{"b", 2L}));
        expected.add(new Tuple(new Object[]{"c", 2L}));
        expected.add(new Tuple(new Object[]{"a", 2L}));
        expected.add(new Tuple(new Object[]{"d", 2L}));
        TupleListCollector collector = FunctionsTest.invokeFunction((Function)function, tuples, new Fields(new Comparable[]{"value", "count"}));
        Iterator<Tuple> iterator = collector.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            Tuple result = iterator.next();
            int index = expected.indexOf(result);
            FunctionsTest.assertTrue((index > -1 ? 1 : 0) != 0);
            FunctionsTest.assertEquals((Object)result, expected.get(index));
            expected.remove(index);
        }
        FunctionsTest.assertEquals((int)5, (int)count);
    }

    @Test
    public void testPartialSums() {
        AggregateBy.CompositeFunction function = new AggregateBy.CompositeFunction(new Fields(new Comparable[]{"key"}), new Fields(new Comparable[]{"value"}), (CompositeFunction.CoFunction)new SumBy.SumPartials(new Fields(new Comparable[]{"sum"}), Float.TYPE), 2);
        Fields incoming = new Fields(new Comparable[]{"key", "value"});
        TupleEntry[] tuples = new TupleEntry[]{new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"b", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"b", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"c", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"c", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"d", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"d", 1}))};
        ArrayList<Tuple> expected = new ArrayList<Tuple>();
        expected.add(new Tuple(new Object[]{"a", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"b", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"c", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"a", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"d", Float.valueOf(2.0f)}));
        TupleListCollector collector = FunctionsTest.invokeFunction((Function)function, tuples, new Fields(new Comparable[]{"key", "sum"}));
        Iterator<Tuple> iterator = collector.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            Tuple result = iterator.next();
            int index = expected.indexOf(result);
            FunctionsTest.assertTrue((index > -1 ? 1 : 0) != 0);
            FunctionsTest.assertEquals((Object)result, expected.get(index));
            expected.remove(index);
        }
        FunctionsTest.assertEquals((int)5, (int)count);
    }

    @Test
    public void testLocallyPartialSums() {
        AggregateByLocally.CompositeFunction function = new AggregateByLocally.CompositeFunction(new Fields(new Comparable[]{"key"}), new Fields(new Comparable[]{"value"}), (CompositeFunction.CoFunction)new SumByLocally.SumPartials(new Fields(new Comparable[]{"sum"}), Float.TYPE), 2);
        Fields incoming = new Fields(new Comparable[]{"key", "value"});
        TupleEntry[] tuples = new TupleEntry[]{new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"b", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"b", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"c", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"c", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"a", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"d", 1})), new TupleEntry(incoming, new Tuple(new Object[]{"d", 1}))};
        ArrayList<Tuple> expected = new ArrayList<Tuple>();
        expected.add(new Tuple(new Object[]{"a", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"b", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"c", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"a", Float.valueOf(2.0f)}));
        expected.add(new Tuple(new Object[]{"d", Float.valueOf(2.0f)}));
        TupleListCollector collector = FunctionsTest.invokeFunction((Function)function, tuples, new Fields(new Comparable[]{"key", "sum"}));
        Iterator<Tuple> iterator = collector.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            Tuple result = iterator.next();
            int index = expected.indexOf(result);
            FunctionsTest.assertTrue((index > -1 ? 1 : 0) != 0);
            FunctionsTest.assertEquals((Object)result, expected.get(index));
            expected.remove(index);
        }
        FunctionsTest.assertEquals((int)5, (int)count);
    }

    @Test
    public void testLocallyPartialCounts() {
        AggregateByLocally.CompositeFunction function = new AggregateByLocally.CompositeFunction(new Fields(new Comparable[]{"value"}), Fields.ALL, (CompositeFunction.CoFunction)new CountByLocally.CountPartials(new Fields(new Comparable[]{"count"})), 2);
        Fields incoming = new Fields(new Comparable[]{"value"});
        TupleEntry[] tuples = new TupleEntry[]{new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"b"})), new TupleEntry(incoming, new Tuple(new Object[]{"b"})), new TupleEntry(incoming, new Tuple(new Object[]{"c"})), new TupleEntry(incoming, new Tuple(new Object[]{"c"})), new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"a"})), new TupleEntry(incoming, new Tuple(new Object[]{"d"})), new TupleEntry(incoming, new Tuple(new Object[]{"d"}))};
        ArrayList<Tuple> expected = new ArrayList<Tuple>();
        expected.add(new Tuple(new Object[]{"a", 2L}));
        expected.add(new Tuple(new Object[]{"b", 2L}));
        expected.add(new Tuple(new Object[]{"c", 2L}));
        expected.add(new Tuple(new Object[]{"a", 2L}));
        expected.add(new Tuple(new Object[]{"d", 2L}));
        TupleListCollector collector = FunctionsTest.invokeFunction((Function)function, tuples, new Fields(new Comparable[]{"value", "count"}));
        Iterator<Tuple> iterator = collector.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            Tuple result = iterator.next();
            int index = expected.indexOf(result);
            FunctionsTest.assertTrue((index > -1 ? 1 : 0) != 0);
            FunctionsTest.assertEquals((Object)result, expected.get(index));
            expected.remove(index);
        }
        FunctionsTest.assertEquals((int)5, (int)count);
    }
}

