/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.operation.ConcreteCall;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import cascading.operation.filter.Limit;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.junit.Test;

public class LimitFilterTest
extends CascadingTestCase {
    private ConcreteCall operationCall;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.operationCall = new ConcreteCall();
    }

    private TupleEntry getEntry(Tuple tuple) {
        return new TupleEntry(Fields.size((int)tuple.size()), tuple);
    }

    @Test
    public void testLimit() {
        int limit = 20;
        int tasks = 20;
        int values = 10;
        for (int currentLimit = 0; currentLimit < limit; ++currentLimit) {
            for (int currentTask = 1; currentTask < tasks; ++currentTask) {
                for (int currentValue = 1; currentValue < values; ++currentValue) {
                    this.performLimitTest(currentLimit, currentTask, currentValue);
                }
            }
        }
    }

    private void performLimitTest(int limit, int tasks, int values) {
        Limit filter = new Limit((long)limit);
        int count = 0;
        for (int i = 0; i < tasks; ++i) {
            TestFlowProcess process = new TestFlowProcess(tasks, i);
            filter.prepare((FlowProcess)process, (OperationCall)this.operationCall);
            this.operationCall.setArguments(this.getEntry(new Tuple(new Object[]{1})));
            for (int j = 0; j < values; ++j) {
                if (filter.isRemove((FlowProcess)process, (FilterCall)this.operationCall)) continue;
                ++count;
            }
        }
        String message = String.format("limit:%d tasks:%d values:%d", limit, tasks, values);
        LimitFilterTest.assertEquals((String)message, (int)Math.min(limit, values * tasks), (int)count);
    }

    private class TestFlowProcess
    extends FlowProcess<Object> {
        private int numTasks;
        private int taskNum;

        public TestFlowProcess(int numTasks, int taskNum) {
            super(new FlowSession());
            this.numTasks = numTasks;
            this.taskNum = taskNum;
        }

        public FlowProcess copyWith(Object object) {
            return null;
        }

        public int getNumProcessSlices() {
            return this.numTasks;
        }

        public int getCurrentSliceNum() {
            return this.taskNum;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Collection<String> getPropertyKeys() {
            return null;
        }

        public Object newInstance(String className) {
            return null;
        }

        public void keepAlive() {
        }

        public void increment(Enum counter, long amount) {
        }

        public void increment(String group, String counter, long amount) {
        }

        public long getCounterValue(Enum counter) {
            return 0L;
        }

        public long getCounterValue(String group, String counter) {
            return 0L;
        }

        public void setStatus(String status) {
        }

        public boolean isCounterStatusInitialized() {
            return true;
        }

        public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
            return null;
        }

        public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
            return null;
        }

        public TupleEntryCollector openTrapForWrite(Tap trap) throws IOException {
            return null;
        }

        public TupleEntryCollector openSystemIntermediateForWrite() throws IOException {
            return null;
        }

        public Object getConfig() {
            return null;
        }

        public Object getConfigCopy() {
            return null;
        }

        public Object copyConfig(Object config) {
            return null;
        }

        public Map<String, String> diffConfigIntoMap(Object defaultConfig, Object updatedConfig) {
            return null;
        }

        public Object mergeMapIntoConfig(Object defaultConfig, Map<String, String> map) {
            return null;
        }
    }
}

