/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.filter.And;
import cascading.operation.filter.FilterNotNull;
import cascading.operation.filter.FilterNull;
import cascading.operation.filter.Not;
import cascading.operation.filter.Or;
import cascading.operation.filter.Xor;
import cascading.pipe.assembly.Unique;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import org.junit.Test;

public class FilterTest
extends CascadingTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testNotNull() {
        FilterNotNull filter = new FilterNotNull();
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1})));
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{null})));
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{"0", 1})));
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{"0", null})));
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{null, null})));
    }

    @Test
    public void testNull() {
        FilterNull filter = new FilterNull();
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1})));
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{null})));
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{"0", 1})));
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{"0", null})));
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{null, null})));
    }

    @Test
    public void testAnd() {
        Fields[] fields = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(0)}), new Fields(new Comparable[]{Integer.valueOf(1)})};
        Filter[] filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(true)};
        And filter = new And(fields, filters);
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(false)};
        filter = new And(fields, filters);
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(true)};
        filter = new And(fields, filters);
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(false)};
        filter = new And(fields, filters);
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
    }

    @Test
    public void testOr() {
        Fields[] fields = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(0)}), new Fields(new Comparable[]{Integer.valueOf(1)})};
        Filter[] filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(true)};
        Or filter = new Or(fields, filters);
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(false)};
        filter = new Or(fields, filters);
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(true)};
        filter = new Or(fields, filters);
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(false)};
        filter = new Or(fields, filters);
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
    }

    @Test
    public void testXor() {
        Fields[] fields = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(0)}), new Fields(new Comparable[]{Integer.valueOf(1)})};
        Filter[] filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(true)};
        Xor filter = new Xor(fields[0], filters[0], fields[1], filters[1]);
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(false)};
        filter = new Xor(fields[0], filters[0], fields[1], filters[1]);
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(true)};
        filter = new Xor(fields[0], filters[0], fields[1], filters[1]);
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(false)};
        filter = new Xor(fields[0], filters[0], fields[1], filters[1]);
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
    }

    @Test
    public void testNot() {
        Fields[] fields = new Fields[]{new Fields(new Comparable[]{Integer.valueOf(0)}), new Fields(new Comparable[]{Integer.valueOf(1)})};
        Filter[] filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(true)};
        Not filter = new Not((Filter)new Or(fields, filters));
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(true), new BooleanFilter(false)};
        filter = new Not((Filter)new Or(fields, filters));
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(true)};
        filter = new Not((Filter)new Or(fields, filters));
        FilterTest.assertFalse((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
        filters = new Filter[]{new BooleanFilter(false), new BooleanFilter(false)};
        filter = new Not((Filter)new Or(fields, filters));
        FilterTest.assertTrue((boolean)FilterTest.invokeFilter((Filter)filter, new Tuple(new Object[]{1, 2})));
    }

    @Test
    public void testPartialDuplicates() {
        Unique.FilterPartialDuplicates filter = new Unique.FilterPartialDuplicates(2);
        Tuple[] tuples = new Tuple[]{new Tuple(new Object[]{1}), new Tuple(new Object[]{1}), new Tuple(new Object[]{null}), new Tuple(new Object[]{null}), new Tuple(new Object[]{null}), new Tuple(new Object[]{null}), new Tuple(new Object[]{1}), new Tuple(new Object[]{2}), new Tuple(new Object[]{1})};
        boolean[] expected = new boolean[]{false, true, false, true, true, true, true, false, false};
        boolean[] results = FilterTest.invokeFilter((Filter)filter, tuples);
        for (int i = 0; i < results.length; ++i) {
            FilterTest.assertEquals((String)("failed on: " + i), (boolean)expected[i], (boolean)results[i]);
        }
    }

    public class BooleanFilter
    extends BaseOperation
    implements Filter {
        private final boolean result;

        public BooleanFilter(boolean result) {
            this.result = result;
        }

        public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
            return this.result;
        }
    }
}

