/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.operation.AssertionException;
import cascading.operation.ConcreteCall;
import cascading.operation.OperationCall;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.AssertEquals;
import cascading.operation.assertion.AssertEqualsAll;
import cascading.operation.assertion.AssertMatches;
import cascading.operation.assertion.AssertMatchesAll;
import cascading.operation.assertion.AssertNotEquals;
import cascading.operation.assertion.AssertNotNull;
import cascading.operation.assertion.AssertNull;
import cascading.operation.assertion.AssertSizeEquals;
import cascading.operation.assertion.AssertSizeLessThan;
import cascading.operation.assertion.AssertSizeMoreThan;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import org.junit.Test;

public class ValueAssertionsTest
extends CascadingTestCase {
    private TupleEntry getEntry(Tuple tuple) {
        return new TupleEntry(Fields.size((int)tuple.size()), tuple);
    }

    private void assertFail(ValueAssertion assertion, TupleEntry tupleEntry) {
        ConcreteCall concreteCall = this.getOperationCall(tupleEntry);
        assertion.prepare(FlowProcess.NULL, (OperationCall)concreteCall);
        try {
            assertion.doAssert(FlowProcess.NULL, (ValueAssertionCall)concreteCall);
            ValueAssertionsTest.fail();
        }
        catch (AssertionException assertionException) {
            // empty catch block
        }
    }

    private ConcreteCall getOperationCall(TupleEntry tupleEntry) {
        ConcreteCall operationCall = new ConcreteCall(tupleEntry.getFields());
        operationCall.setArguments(tupleEntry);
        return operationCall;
    }

    private void assertPass(ValueAssertion assertion, TupleEntry tupleEntry) {
        ConcreteCall concreteCall = this.getOperationCall(tupleEntry);
        assertion.prepare(FlowProcess.NULL, (OperationCall)concreteCall);
        assertion.doAssert(FlowProcess.NULL, (ValueAssertionCall)concreteCall);
    }

    @Test
    public void testNotNull() {
        AssertNotNull assertion = new AssertNotNull();
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testNull() {
        AssertNull assertion = new AssertNull();
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null, null})));
    }

    @Test
    public void testEquals() {
        AssertEquals assertion = new AssertEquals(new Object[]{1});
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertEquals(new Object[]{"one", "two"});
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"one", "two"})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null, null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testNotEquals() {
        AssertNotEquals assertion = new AssertNotEquals(new Object[]{4});
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{4})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertNotEquals(new Object[]{"one1", "two1"});
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"one1", "two1"})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"one", "two"})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null, null})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testEqualsAll() {
        AssertEqualsAll assertion = new AssertEqualsAll((Object)1);
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testMatches() {
        AssertMatches assertion = new AssertMatches("^1$");
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"1"})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertMatches("^1$", false);
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"1"})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertMatches("^1$", true);
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"1"})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testMatchesAll() {
        AssertMatchesAll assertion = new AssertMatchesAll("^1$");
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"1"})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 0, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertMatchesAll("^1$", false);
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"1"})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 0, 1, 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
        assertion = new AssertMatchesAll("^1$", true);
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"1"})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1, 1, 1, 1, 1, 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testTupleEquals() {
        AssertSizeEquals assertion = new AssertSizeEquals(1);
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testTupleLessThan() {
        AssertSizeLessThan assertion = new AssertSizeLessThan(2);
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }

    @Test
    public void testTupleMoreThan() {
        AssertSizeMoreThan assertion = new AssertSizeMoreThan(1);
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", 1})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }
}

