/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.iso;

import cascading.CascadingTestCase;
import cascading.flow.iso.graph.HashJoinSameSourceGraph;
import cascading.flow.iso.graph.JoinAroundJoinRightMostGraph;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.iso.expression.ElementCapture;
import cascading.flow.planner.iso.expression.ElementExpression;
import cascading.flow.planner.iso.expression.ExpressionGraph;
import cascading.flow.planner.iso.expression.FlowElementExpression;
import cascading.flow.planner.iso.expression.ScopeExpression;
import cascading.flow.planner.iso.expression.TypeExpression;
import cascading.flow.planner.iso.finder.GraphFinder;
import cascading.flow.planner.iso.finder.Match;
import cascading.flow.planner.iso.transformer.ContractedTransformer;
import cascading.flow.planner.rule.expressiongraph.NoGroupTapExpressionGraph;
import cascading.flow.planner.rule.expressiongraph.SyncPipeExpressionGraph;
import cascading.pipe.HashJoin;
import cascading.tap.Tap;
import org.junit.Test;

public class GraphFinderTest
extends CascadingTestCase {
    @Test
    public void testFind() {
        HashJoinSameSourceGraph graph = new HashJoinSameSourceGraph();
        graph = new ContractedTransformer((ExpressionGraph)new SyncPipeExpressionGraph()).transform((ElementGraph)graph).getEndGraph();
        FlowElementExpression SHARED_TAP = new FlowElementExpression(Tap.class, TypeExpression.Topo.SplitOnly);
        FlowElementExpression SHARED_HASHJOIN = new FlowElementExpression(HashJoin.class);
        ExpressionGraph expressionGraph = new ExpressionGraph().arcs(new ElementExpression[]{SHARED_TAP, SHARED_HASHJOIN}).arcs(new ElementExpression[]{SHARED_TAP, SHARED_HASHJOIN});
        GraphFinder graphFinder = new GraphFinder(expressionGraph);
        Match match = graphFinder.findFirstMatch((ElementGraph)graph);
        match.getMatchedGraph().writeDOT(this.getPlanPath() + "/match.dot");
    }

    @Test
    public void testFind2() {
        HashJoinSameSourceGraph graph = new HashJoinSameSourceGraph();
        graph = new ContractedTransformer((ExpressionGraph)new SyncPipeExpressionGraph()).transform((ElementGraph)graph).getEndGraph();
        FlowElementExpression sharedTap = new FlowElementExpression(Tap.class, TypeExpression.Topo.SplitOnly);
        FlowElementExpression sharedHashJoin = new FlowElementExpression(HashJoin.class);
        ExpressionGraph expressionGraph = new ExpressionGraph().arc((ElementExpression)sharedTap, (ScopeExpression)ScopeExpression.ALL, (ElementExpression)sharedHashJoin);
        GraphFinder graphFinder = new GraphFinder(expressionGraph);
        Match match = graphFinder.findFirstMatch((ElementGraph)graph);
        match.getMatchedGraph().writeDOT(this.getPlanPath() + "/match.dot");
    }

    @Test
    public void testFindAllOnPrimary() {
        JoinAroundJoinRightMostGraph graph = new JoinAroundJoinRightMostGraph();
        graph.writeDOT(this.getPlanPath() + "/full.dot");
        graph = new ContractedTransformer((ExpressionGraph)new NoGroupTapExpressionGraph()).transform((ElementGraph)graph).getEndGraph();
        graph.writeDOT(this.getPlanPath() + "/contracted.dot");
        ExpressionGraph expressionGraph = new ExpressionGraph().arc((ElementExpression)new FlowElementExpression(Tap.class), (ScopeExpression)ScopeExpression.ALL, (ElementExpression)new FlowElementExpression(ElementCapture.Primary, HashJoin.class));
        GraphFinder graphFinder = new GraphFinder(expressionGraph);
        Match match = graphFinder.findAllMatchesOnPrimary((ElementGraph)graph);
        match.getMatchedGraph().writeDOT(this.getPlanPath() + "/match.dot");
    }

    @Test
    public void testFindAllMatched() {
        JoinAroundJoinRightMostGraph graph = new JoinAroundJoinRightMostGraph();
        graph.writeDOT(this.getPlanPath() + "/full.dot");
        graph = new ContractedTransformer((ExpressionGraph)new NoGroupTapExpressionGraph()).transform((ElementGraph)graph).getEndGraph();
        graph.writeDOT(this.getPlanPath() + "/contracted.dot");
        ExpressionGraph expressionGraph = new ExpressionGraph(new ElementExpression[]{new FlowElementExpression(ElementCapture.Primary, Tap.class)});
        GraphFinder graphFinder = new GraphFinder(expressionGraph);
        Match match = graphFinder.findAllMatches((ElementGraph)graph);
        match.getMatchedGraph().writeDOT(this.getPlanPath() + "/match.dot");
    }
}

