/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.iso;

import cascading.flow.planner.graph.ElementGraphs;
import java.util.Set;
import junit.framework.TestCase;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DirectedSubgraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.junit.Test;

public class FindSubGraphTest
extends TestCase {
    @Test
    public void testFindSubGraph() {
        SimpleDirectedGraph full = new SimpleDirectedGraph(Object.class);
        full.addVertex((Object)"1");
        full.addVertex((Object)"0");
        full.addVertex((Object)"a");
        full.addVertex((Object)"b");
        full.addVertex((Object)"c");
        full.addVertex((Object)"d");
        full.addVertex((Object)"e");
        full.addEdge((Object)"a", (Object)"b");
        full.addEdge((Object)"b", (Object)"c");
        full.addEdge((Object)"c", (Object)"d");
        full.addEdge((Object)"c", (Object)"e");
        full.addEdge((Object)"1", (Object)"0");
        full.addEdge((Object)"0", (Object)"c");
        SimpleDirectedGraph contracted = new SimpleDirectedGraph(Object.class);
        contracted.addVertex((Object)"1");
        contracted.addVertex((Object)"a");
        contracted.addVertex((Object)"c");
        contracted.addEdge((Object)"a", (Object)"c");
        contracted.addEdge((Object)"1", (Object)"c");
        SimpleDirectedGraph result = new SimpleDirectedGraph(Object.class);
        result.addVertex((Object)"1");
        result.addVertex((Object)"0");
        result.addVertex((Object)"a");
        result.addVertex((Object)"b");
        result.addVertex((Object)"c");
        result.addEdge((Object)"a", (Object)"b", full.getEdge((Object)"a", (Object)"b"));
        result.addEdge((Object)"b", (Object)"c", full.getEdge((Object)"b", (Object)"c"));
        result.addEdge((Object)"1", (Object)"0", full.getEdge((Object)"1", (Object)"0"));
        result.addEdge((Object)"0", (Object)"c", full.getEdge((Object)"0", (Object)"c"));
        this.assertGraphs((SimpleDirectedGraph<String, Object>)full, (SimpleDirectedGraph<String, Object>)contracted, (SimpleDirectedGraph<String, Object>)result);
    }

    @Test
    public void testFindSubGraph2() {
        SimpleDirectedGraph full = new SimpleDirectedGraph(Object.class);
        full.addVertex((Object)"1");
        full.addVertex((Object)"0");
        full.addVertex((Object)"a");
        full.addVertex((Object)"b");
        full.addVertex((Object)"c");
        full.addVertex((Object)"d");
        full.addVertex((Object)"e");
        full.addEdge((Object)"a", (Object)"b");
        full.addEdge((Object)"b", (Object)"c");
        full.addEdge((Object)"c", (Object)"d");
        full.addEdge((Object)"c", (Object)"e");
        full.addEdge((Object)"1", (Object)"0");
        full.addEdge((Object)"0", (Object)"c");
        SimpleDirectedGraph contracted = new SimpleDirectedGraph(Object.class);
        contracted.addVertex((Object)"a");
        contracted.addVertex((Object)"c");
        contracted.addEdge((Object)"a", (Object)"c");
        SimpleDirectedGraph result = new SimpleDirectedGraph(Object.class);
        result.addVertex((Object)"a");
        result.addVertex((Object)"b");
        result.addVertex((Object)"c");
        result.addEdge((Object)"a", (Object)"b", full.getEdge((Object)"a", (Object)"b"));
        result.addEdge((Object)"b", (Object)"c", full.getEdge((Object)"b", (Object)"c"));
        this.assertGraphs((SimpleDirectedGraph<String, Object>)full, (SimpleDirectedGraph<String, Object>)contracted, (SimpleDirectedGraph<String, Object>)result);
    }

    @Test
    public void testFindSubGraph3() {
        SimpleDirectedGraph full = new SimpleDirectedGraph(Object.class);
        full.addVertex((Object)"A");
        full.addVertex((Object)"1");
        full.addVertex((Object)"0");
        full.addVertex((Object)"a");
        full.addVertex((Object)"b");
        full.addVertex((Object)"c");
        full.addVertex((Object)"d");
        full.addVertex((Object)"e");
        full.addEdge((Object)"A", (Object)"a");
        full.addEdge((Object)"A", (Object)"1");
        full.addEdge((Object)"a", (Object)"b");
        full.addEdge((Object)"b", (Object)"c");
        full.addEdge((Object)"c", (Object)"d");
        full.addEdge((Object)"c", (Object)"e");
        full.addEdge((Object)"1", (Object)"0");
        full.addEdge((Object)"0", (Object)"c");
        SimpleDirectedGraph contracted = new SimpleDirectedGraph(Object.class);
        contracted.addVertex((Object)"A");
        contracted.addVertex((Object)"1");
        contracted.addVertex((Object)"c");
        contracted.addEdge((Object)"A", (Object)"1");
        contracted.addEdge((Object)"A", (Object)"c");
        SimpleDirectedGraph result = new SimpleDirectedGraph(Object.class);
        result.addVertex((Object)"A");
        result.addVertex((Object)"1");
        result.addVertex((Object)"a");
        result.addVertex((Object)"b");
        result.addVertex((Object)"c");
        result.addEdge((Object)"A", (Object)"1", full.getEdge((Object)"A", (Object)"1"));
        result.addEdge((Object)"A", (Object)"a", full.getEdge((Object)"A", (Object)"a"));
        result.addEdge((Object)"a", (Object)"b", full.getEdge((Object)"a", (Object)"b"));
        result.addEdge((Object)"b", (Object)"c", full.getEdge((Object)"b", (Object)"c"));
        this.assertGraphs((SimpleDirectedGraph<String, Object>)full, (SimpleDirectedGraph<String, Object>)contracted, (SimpleDirectedGraph<String, Object>)result);
    }

    @Test
    public void testFindSubGraph4() {
        SimpleDirectedGraph full = new SimpleDirectedGraph(Object.class);
        full.addVertex((Object)"B");
        full.addVertex((Object)"A");
        full.addVertex((Object)"2");
        full.addVertex((Object)"1");
        full.addVertex((Object)"0");
        full.addVertex((Object)"a");
        full.addVertex((Object)"b");
        full.addVertex((Object)"c");
        full.addVertex((Object)"d");
        full.addVertex((Object)"e");
        full.addEdge((Object)"B", (Object)"A");
        full.addEdge((Object)"A", (Object)"a");
        full.addEdge((Object)"A", (Object)"2");
        full.addEdge((Object)"a", (Object)"b");
        full.addEdge((Object)"b", (Object)"c");
        full.addEdge((Object)"c", (Object)"d");
        full.addEdge((Object)"c", (Object)"e");
        full.addEdge((Object)"2", (Object)"1");
        full.addEdge((Object)"1", (Object)"0");
        full.addEdge((Object)"0", (Object)"c");
        SimpleDirectedGraph contracted = new SimpleDirectedGraph(Object.class);
        contracted.addVertex((Object)"B");
        contracted.addVertex((Object)"1");
        contracted.addVertex((Object)"c");
        contracted.addEdge((Object)"1", (Object)"c");
        contracted.addEdge((Object)"B", (Object)"c");
        SimpleDirectedGraph result = new SimpleDirectedGraph(Object.class);
        result.addVertex((Object)"B");
        result.addVertex((Object)"A");
        result.addVertex((Object)"1");
        result.addVertex((Object)"0");
        result.addVertex((Object)"a");
        result.addVertex((Object)"b");
        result.addVertex((Object)"c");
        result.addEdge((Object)"B", (Object)"A", full.getEdge((Object)"B", (Object)"A"));
        result.addEdge((Object)"1", (Object)"0", full.getEdge((Object)"1", (Object)"0"));
        result.addEdge((Object)"0", (Object)"c", full.getEdge((Object)"0", (Object)"c"));
        result.addEdge((Object)"A", (Object)"a", full.getEdge((Object)"A", (Object)"a"));
        result.addEdge((Object)"a", (Object)"b", full.getEdge((Object)"a", (Object)"b"));
        result.addEdge((Object)"b", (Object)"c", full.getEdge((Object)"b", (Object)"c"));
        this.assertGraphs((SimpleDirectedGraph<String, Object>)full, (SimpleDirectedGraph<String, Object>)contracted, (SimpleDirectedGraph<String, Object>)result);
    }

    private void assertGraphs(SimpleDirectedGraph<String, Object> full, SimpleDirectedGraph<String, Object> contracted, SimpleDirectedGraph<String, Object> result) {
        Set vertices = (Set)ElementGraphs.findClosureViaFloydWarshall(full, contracted).getLhs();
        DirectedSubgraph subgraph = new DirectedSubgraph(full, vertices, null);
        SimpleDirectedGraph clone = new SimpleDirectedGraph(Object.class);
        Graphs.addGraph((Graph)clone, (Graph)subgraph);
        FindSubGraphTest.assertEquals(result, (Object)clone);
    }
}

