/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.CascadingException;
import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.pipe.Merge;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.pipe.assembly.Rename;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.TraceUtil;
import java.io.IOException;
import org.junit.Test;

public class TraceTest
extends CascadingTestCase {
    @Test
    public void testOperation() {
        Identity operation = new Identity();
        TraceTest.assertEqualsTrace("cascading.TraceTest.testOperation(TraceTest.java", operation.getTrace());
    }

    @Test
    public void testPipe() {
        Pipe pipe = new Pipe("foo");
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipe(TraceTest.java", pipe.getTrace());
    }

    @Test
    public void testPipeEach() {
        Pipe pipe = new Pipe("foo");
        pipe = new Each(pipe, new Fields(new Comparable[]{"a"}), (Function)new Identity());
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipeEach(TraceTest.java", pipe.getTrace());
    }

    @Test
    public void testPipeCoGroup() {
        Pipe pipe = new Pipe("foo");
        pipe = new Each(pipe, new Fields(new Comparable[]{"a"}), (Function)new Identity());
        pipe = new CoGroup(pipe, new Fields(new Comparable[]{"b"}), 4);
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipeCoGroup(TraceTest.java", pipe.getTrace());
    }

    @Test
    public void testPipeHashJoin() {
        Pipe pipe = new Pipe("foo");
        pipe = new Each(pipe, new Fields(new Comparable[]{"a"}), (Function)new Identity());
        pipe = new HashJoin(pipe, new Fields(new Comparable[]{"b"}), new Pipe("bar"), new Fields(new Comparable[]{"c"}));
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipeHashJoin(TraceTest.java", pipe.getTrace());
    }

    @Test
    public void testPipeGroupBy() {
        Pipe pipe = new Pipe("foo");
        pipe = new Each(pipe, new Fields(new Comparable[]{"a"}), (Function)new Identity());
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"b"}));
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipeGroupBy(TraceTest.java", pipe.getTrace());
    }

    @Test
    public void testPipeMerge() {
        Pipe pipe = new Pipe("foo");
        pipe = new Each(pipe, new Fields(new Comparable[]{"a"}), (Function)new Identity());
        pipe = new Merge(new Pipe[]{pipe, new Pipe("bar")});
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipeMerge(TraceTest.java", pipe.getTrace());
    }

    @Test
    public void testPipeAssembly() {
        Pipe pipe = new Pipe("foo");
        pipe = new Rename(pipe, new Fields(new Comparable[]{"a"}), new Fields(new Comparable[]{"b"}));
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipeAssembly(TraceTest.java", pipe.getTrace());
    }

    @Test
    public void testPipeAssemblyDeep() {
        TestSubAssembly pipe = new TestSubAssembly();
        TraceTest.assertEqualsTrace("cascading.TraceTest.testPipeAssemblyDeep(TraceTest.java", pipe.getTrace());
        TraceTest.assertEqualsTrace("cascading.TraceTest$TestSubAssembly.<init>(TraceTest.java", pipe.pipe.getTrace());
        TraceTest.assertEqualsTrace("cascading.TraceTest$TestSubAssembly.<init>(TraceTest.java", pipe.getTails()[0].getTrace());
    }

    public static Pipe sampleApi() {
        return new Pipe("foo");
    }

    @Test
    public void testApiBoundary() {
        String regex = "cascading\\.TraceTest\\.sampleApi.*";
        TraceUtil.registerApiBoundary((String)"cascading\\.TraceTest\\.sampleApi.*");
        try {
            Pipe pipe1 = TraceTest.sampleApi();
            TraceTest.assertEqualsTrace("sampleApi() @ cascading.TraceTest.testApiBoundary(TraceTest.java", pipe1.getTrace());
        }
        finally {
            TraceUtil.unregisterApiBoundary((String)"cascading\\.TraceTest\\.sampleApi.*");
        }
        Pipe pipe2 = TraceTest.sampleApi();
        TraceTest.assertEqualsTrace("cascading.TraceTest.sampleApi(TraceTest.java", pipe2.getTrace());
    }

    @Test
    public void testTap() {
        Tap tap = new Tap(){

            public String getIdentifier() {
                return null;
            }

            public TupleEntryIterator openForRead(FlowProcess flowProcess, Object object) throws IOException {
                return null;
            }

            public TupleEntryCollector openForWrite(FlowProcess flowProcess, Object object) throws IOException {
                return null;
            }

            public boolean createResource(Object conf) throws IOException {
                return false;
            }

            public boolean deleteResource(Object conf) throws IOException {
                return false;
            }

            public boolean resourceExists(Object conf) throws IOException {
                return false;
            }

            public long getModifiedTime(Object conf) throws IOException {
                return 0L;
            }
        };
        TraceTest.assertEqualsTrace("cascading.TraceTest.testTap(TraceTest.java", tap.getTrace());
    }

    @Test
    public void testScheme() {
        Scheme scheme = new Scheme(){

            public void sourceConfInit(FlowProcess flowProcess, Tap tap, Object conf) {
            }

            public void sinkConfInit(FlowProcess flowProcess, Tap tap, Object conf) {
            }

            public boolean source(FlowProcess flowProcess, SourceCall sourceCall) throws IOException {
                return false;
            }

            public void sink(FlowProcess flowProcess, SinkCall sinkCall) throws IOException {
            }
        };
        TraceTest.assertEqualsTrace("cascading.TraceTest.testScheme(TraceTest.java", scheme.getTrace());
    }

    public static void assertEqualsTrace(String expected, String trace) {
        String substring = trace.substring(0, trace.lastIndexOf(":"));
        TraceTest.assertEquals((String)expected, (String)substring);
    }

    @Test
    public void testStringify() {
        CascadingException top = new CascadingException("test message", (Throwable)new NullPointerException("had an npe"));
        TraceTest.assertNotNull((Object)TraceUtil.stringifyStackTrace((Throwable)top, (String)"|", (boolean)true, (int)-1));
        TraceTest.assertTrue((!TraceUtil.stringifyStackTrace((Throwable)top, (String)"|", (boolean)true, (int)-1).contains("\t") ? 1 : 0) != 0);
        TraceTest.assertTrue((boolean)TraceUtil.stringifyStackTrace((Throwable)top, (String)"|", (boolean)false, (int)-1).contains("\t"));
        TraceTest.assertNull((Object)TraceUtil.stringifyStackTrace((Throwable)top, (String)"|", (boolean)true, (int)0));
        TraceTest.assertEquals((int)1, (int)TraceUtil.stringifyStackTrace((Throwable)top, (String)"|", (boolean)true, (int)1).split("\\|").length);
        TraceTest.assertEquals((int)2, (int)TraceUtil.stringifyStackTrace((Throwable)top, (String)"|", (boolean)true, (int)2).split("\\|").length);
    }

    protected static class TestSubAssembly
    extends SubAssembly {
        public Pipe pipe;

        public TestSubAssembly() {
            Pipe pipe = new Pipe("foo");
            this.setPrevious(new Pipe[]{pipe});
            this.pipe = pipe = new Rename(pipe, new Fields(new Comparable[]{"a"}), new Fields(new Comparable[]{"b"}));
            this.setTails(new Pipe[]{pipe});
        }
    }
}

